
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_continuous` tinyint(1) NOT NULL DEFAULT 0,
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 4\" x 1\"\\r\\nLabels per sheet: 20',3.7500,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.1562,2,0,0,20,NULL,'2017-12-18 08:13:44','2017-12-18 08:13:44'),(2,'30 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2.625\" x 1\"\\r\\nLabels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.2198,0.0000,0.1400,3,0,0,30,NULL,'2017-12-18 08:04:39','2017-12-18 08:10:40'),(3,'32 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1.25\"\\r\\nLabels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 07:55:40','2017-12-18 07:55:40'),(4,'40 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1\"\\r\\nLabels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 07:58:40','2017-12-18 07:58:40'),(5,'50 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 1.5\" x 1\"\\r\\nLabels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 07:51:10','2017-12-18 07:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm\\r\\nGap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 07:51:10','2017-12-18 07:51:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` enum('booked','completed','cancelled') COLLATE utf8mb4_unicode_ci NOT NULL,
  `booking_note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,2,'DIVERSOS',NULL,2,NULL,'2020-12-29 18:40:22','2020-12-29 18:40:22'),(2,2,'TIC TAC',NULL,2,NULL,NULL,NULL),(3,2,'PULLMAN',NULL,2,NULL,NULL,NULL),(4,2,'DANONE',NULL,2,NULL,NULL,NULL),(5,2,'BIG',NULL,2,NULL,NULL,NULL),(6,2,'BOM BRIL',NULL,2,NULL,NULL,NULL),(7,2,'MAGUARY',NULL,2,NULL,NULL,NULL),(8,2,'LACTA',NULL,2,NULL,NULL,NULL),(9,2,'COCA',NULL,2,NULL,NULL,NULL),(10,2,'GILLETTE',NULL,2,NULL,NULL,NULL),(11,2,'JOHNSON',NULL,2,NULL,NULL,NULL),(12,2,'FARMAX',NULL,2,NULL,NULL,NULL),(13,2,'MONANGE',NULL,2,NULL,NULL,NULL),(14,2,'START',NULL,2,NULL,NULL,NULL),(15,2,'MINUANO',NULL,2,NULL,NULL,NULL),(16,2,'AYMORE',NULL,2,NULL,NULL,NULL),(17,2,'SADIA',NULL,2,NULL,NULL,NULL),(18,2,'CANTO MINAS',NULL,2,NULL,NULL,NULL),(19,2,'NESTLE',NULL,2,NULL,NULL,NULL),(20,2,'LOANDA',NULL,2,NULL,NULL,NULL),(21,2,'ARCOR',NULL,2,NULL,NULL,NULL),(22,2,'CALU',NULL,2,NULL,NULL,NULL),(23,2,'PACH?',NULL,2,NULL,NULL,NULL),(24,2,'PROLANCHE',NULL,2,NULL,NULL,NULL),(25,2,'DAJUDA',NULL,2,NULL,NULL,NULL),(26,2,'HERSHEY`S',NULL,2,NULL,NULL,NULL),(27,2,'FINI',NULL,2,NULL,NULL,NULL),(28,2,'BUZZY',NULL,2,NULL,NULL,NULL),(29,2,'PLUTONITA',NULL,2,NULL,NULL,NULL),(30,2,'CEMIL',NULL,2,NULL,NULL,NULL),(31,2,'LE?O',NULL,2,NULL,NULL,NULL),(32,2,'CARGILL AGRICOLA S.A',NULL,2,NULL,NULL,NULL),(33,2,'FLICS',NULL,2,NULL,NULL,NULL),(34,2,'HERSHEY',NULL,2,NULL,NULL,NULL),(35,2,'FERREIRO',NULL,2,NULL,NULL,NULL),(36,2,'PEPSICO',NULL,2,NULL,NULL,NULL),(37,2,'COOPATOS',NULL,2,NULL,NULL,NULL),(38,2,'VIGOR',NULL,2,NULL,NULL,NULL),(39,2,'TREVINHO',NULL,2,NULL,NULL,NULL),(40,2,'BUNGE',NULL,2,NULL,NULL,NULL),(41,2,'ARALAT',NULL,2,NULL,NULL,NULL),(42,2,'CRISTAL',NULL,2,NULL,NULL,NULL),(43,2,'HEINEKEN',NULL,2,NULL,NULL,NULL),(44,2,'BAVARIA',NULL,2,NULL,NULL,NULL),(45,2,'KAISER',NULL,2,NULL,NULL,NULL),(46,2,'DEL VALLE',NULL,2,NULL,NULL,NULL),(47,2,'ANTARTICA',NULL,2,NULL,NULL,NULL),(48,2,'MINEIRO',NULL,2,NULL,NULL,NULL),(49,2,'TNT',NULL,2,NULL,NULL,NULL),(50,2,'ITAIPAVA',NULL,2,NULL,NULL,NULL),(51,2,'ABC',NULL,2,NULL,NULL,NULL),(52,2,'ARISCO',NULL,2,NULL,NULL,NULL),(53,2,'GRADINA',NULL,2,NULL,NULL,NULL),(54,2,'HARALD',NULL,2,NULL,NULL,NULL),(55,2,'PERDIGAO',NULL,2,NULL,NULL,NULL),(56,2,'SEARA',NULL,2,NULL,NULL,NULL),(57,2,'RADIO',NULL,2,NULL,NULL,NULL),(58,2,'RESENDE',NULL,2,NULL,NULL,NULL),(59,2,'MENTOS',NULL,2,NULL,NULL,NULL),(60,2,'ITAMBE',NULL,2,NULL,NULL,NULL),(61,2,'COCA COLA',NULL,2,NULL,NULL,NULL),(62,2,'HALLS',NULL,2,NULL,NULL,NULL),(63,2,'DANILLA',NULL,2,NULL,NULL,NULL),(64,2,'FLORESTAL',NULL,2,NULL,NULL,NULL),(65,2,'MONDELES',NULL,2,NULL,NULL,NULL),(66,2,'PALADIN',NULL,2,NULL,NULL,NULL),(67,2,'BECEL',NULL,2,NULL,NULL,NULL),(68,2,'MABEL',NULL,2,NULL,NULL,NULL),(69,2,'ELMA CHIPS',NULL,2,NULL,NULL,NULL),(70,2,'BELMA',NULL,2,NULL,NULL,NULL),(71,2,'MANDIOCA SERTANEJA',NULL,2,NULL,NULL,NULL),(72,2,'LOCTITE',NULL,2,NULL,NULL,NULL),(73,2,'MONSTER',NULL,2,NULL,NULL,NULL),(74,2,'ITAIGUARA',NULL,2,NULL,NULL,NULL),(75,2,'PEPSI',NULL,2,NULL,NULL,NULL),(76,2,'BRAHMA',NULL,2,NULL,NULL,NULL),(77,2,'SKOL',NULL,2,NULL,NULL,NULL),(78,2,'ENERGIZER',NULL,2,NULL,NULL,NULL),(79,2,'RAYOVAC',NULL,2,NULL,NULL,NULL),(80,2,'BEIJA-FLOR',NULL,2,NULL,NULL,NULL),(81,2,'FIAT LUX',NULL,2,NULL,NULL,NULL),(82,2,'PALOMA',NULL,2,NULL,NULL,NULL),(83,2,'FUGINI',NULL,2,NULL,NULL,NULL),(84,2,'JUNCO',NULL,2,NULL,NULL,NULL),(85,2,'LIZA',NULL,2,NULL,NULL,NULL),(86,2,'CAIPIR?O',NULL,2,NULL,NULL,NULL),(87,2,'NOSSO COCO',NULL,2,NULL,NULL,NULL),(88,2,'MINEIR?O',NULL,2,NULL,NULL,NULL),(89,2,'TANG',NULL,2,NULL,NULL,NULL),(90,2,'BATON',NULL,2,NULL,NULL,NULL),(91,2,'CAJUB?',NULL,2,NULL,NULL,NULL),(92,2,'TRIDENT',NULL,2,NULL,NULL,NULL),(93,2,'GAROTO',NULL,2,NULL,NULL,NULL),(94,2,'CONCORDIA',NULL,2,NULL,NULL,NULL),(95,2,'COPAGAS',NULL,2,NULL,NULL,NULL),(96,2,'COTOCHES',NULL,2,NULL,NULL,NULL),(97,2,'EXTRA POWER',NULL,2,NULL,NULL,NULL),(98,2,'FANTA',NULL,2,NULL,NULL,NULL),(99,2,'TODY',NULL,2,NULL,NULL,NULL),(100,2,'PAULISTA',NULL,2,NULL,NULL,NULL),(101,2,'ITALAC',NULL,2,NULL,NULL,NULL),(102,2,'ADES',NULL,2,NULL,NULL,NULL),(103,2,'COZINHA PREMIADA',NULL,2,NULL,NULL,NULL),(104,2,'ABELHINHA',NULL,2,NULL,NULL,NULL),(105,2,'DR.OETKER',NULL,2,NULL,NULL,NULL),(106,2,'SCHIN',NULL,2,NULL,NULL,NULL),(107,2,'EVEREADY',NULL,2,NULL,NULL,NULL),(108,2,'COMIGO',NULL,2,NULL,NULL,NULL),(109,2,'NISSIN',NULL,2,NULL,NULL,NULL),(110,2,'FLEISCHMANN',NULL,2,NULL,NULL,NULL),(111,2,'QUALIMAX',NULL,2,NULL,NULL,NULL),(112,2,'CAF? 3 MARCOS',NULL,2,NULL,NULL,NULL),(113,2,'COLOMBO',NULL,2,NULL,NULL,NULL),(114,2,'AVIVAR',NULL,2,NULL,NULL,NULL),(115,2,'BURN',NULL,2,NULL,NULL,NULL),(116,2,'PECCIN',NULL,2,NULL,NULL,NULL),(117,2,'KNORR',NULL,2,NULL,NULL,NULL),(118,2,'BRASIL UP',NULL,2,NULL,NULL,NULL),(119,2,'SINA',NULL,2,NULL,NULL,NULL),(120,2,'NUTRY',NULL,2,NULL,NULL,NULL),(121,2,'SUPERCOCO',NULL,2,NULL,NULL,NULL),(122,2,'SOL',NULL,2,NULL,NULL,NULL),(123,2,'BONUTRE',NULL,2,NULL,NULL,NULL),(124,2,'NUTRINECTAR',NULL,2,NULL,NULL,NULL),(125,2,'UTILFORMAS',NULL,2,NULL,NULL,NULL),(126,2,'VERDE CAMPO',NULL,2,NULL,NULL,NULL),(127,2,'JUSSARA',NULL,2,NULL,NULL,NULL),(128,2,'MAGNIFIK',NULL,2,NULL,NULL,NULL),(129,2,'FONTINI',NULL,2,NULL,NULL,NULL),(130,2,'SOYA',NULL,2,NULL,NULL,NULL),(131,2,'ITAMARATY',NULL,2,NULL,NULL,NULL),(132,2,'AMBEV',NULL,2,NULL,NULL,NULL),(133,2,'RED BULL',NULL,2,NULL,NULL,NULL),(134,2,'MINAS+',NULL,2,NULL,NULL,NULL),(135,2,'RAFIA',NULL,2,NULL,NULL,NULL),(136,2,'SOBERANA',NULL,2,NULL,NULL,NULL),(137,2,'TRIO',NULL,2,NULL,NULL,NULL),(138,2,'CERRADO DE MINAS',NULL,2,NULL,NULL,NULL),(139,2,'MAVAL?RIO',NULL,2,NULL,NULL,NULL),(140,2,'DUCOCO',NULL,2,NULL,NULL,NULL),(141,2,'ELEFANTE',NULL,2,NULL,NULL,NULL),(142,2,'HEINZ',NULL,2,NULL,NULL,NULL),(143,2,'NITA',NULL,2,NULL,NULL,NULL),(144,2,'PERFETTI VAN MELLI',NULL,2,NULL,NULL,NULL),(145,2,'IMPERIO',NULL,2,NULL,NULL,NULL),(146,2,'KEHDI',NULL,2,NULL,NULL,NULL),(147,2,'MAGO',NULL,2,NULL,NULL,NULL),(148,2,'QUERO',NULL,2,NULL,NULL,NULL),(149,2,'EISENBAHN',NULL,2,NULL,NULL,NULL),(150,2,'QUAKER',NULL,2,NULL,NULL,NULL),(151,2,'5 ESTRELAS',NULL,2,NULL,NULL,NULL),(152,2,'NUTRELLA',NULL,2,NULL,NULL,NULL),(153,2,'PRATS',NULL,2,NULL,NULL,NULL),(154,2,'VILMA',NULL,2,NULL,NULL,NULL),(155,2,'SUPREMA',NULL,2,NULL,NULL,NULL),(156,2,'DINIZ',NULL,2,NULL,NULL,NULL),(157,2,'MAURI',NULL,2,NULL,NULL,NULL),(158,2,'AM?LIA',NULL,2,NULL,NULL,NULL),(159,2,'PIL?O',NULL,2,NULL,NULL,NULL),(160,2,'VABENE',NULL,2,NULL,NULL,NULL),(161,2,'TRENTO',NULL,2,NULL,NULL,NULL),(162,2,'COPOPLAST',NULL,2,NULL,NULL,NULL),(163,2,'PIRACANJUBA',NULL,2,NULL,NULL,NULL),(164,2,'PREDILECTA',NULL,2,NULL,NULL,NULL),(165,2,'AUREA',NULL,2,NULL,NULL,NULL),(166,2,'SOCOCO',NULL,2,NULL,NULL,NULL),(167,2,'SOFRUTA',NULL,2,NULL,NULL,NULL),(168,2,'COPRA',NULL,2,NULL,NULL,NULL),(169,2,'SUPER FRANGO',NULL,2,NULL,NULL,NULL),(170,2,'AMAFIL',NULL,2,NULL,NULL,NULL),(171,2,'XEREN',NULL,2,NULL,NULL,NULL),(172,2,'BOUA',NULL,2,NULL,NULL,NULL),(173,2,'NUTELLA',NULL,2,NULL,NULL,NULL),(174,2,'RIBS',NULL,2,NULL,NULL,NULL),(175,2,'PIF PAF',NULL,2,NULL,NULL,NULL),(176,2,'RINGPOP',NULL,2,NULL,NULL,NULL),(177,2,'VELEIRO',NULL,2,NULL,NULL,NULL),(178,2,'NF BISCOITOS',NULL,2,NULL,NULL,NULL),(179,2,'CANTO DE MINAS',NULL,2,NULL,NULL,NULL);
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT 0.00,
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'America/Sao_Paulo',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT 1,
  `accounting_method` enum('fifo','lifo','avco') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `expiry_type` enum('add_expiry','add_manufacturing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT 1,
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT 30,
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT 30,
  `keyboard_shortcuts` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pos_settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weighing_scale_setting` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT 1,
  `enable_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT 1,
  `enable_purchase_status` tinyint(1) DEFAULT 1,
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT 0,
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT 0,
  `enable_racks` tinyint(1) NOT NULL DEFAULT 0,
  `enable_row` tinyint(1) NOT NULL DEFAULT 0,
  `enable_position` tinyint(1) NOT NULL DEFAULT 0,
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT 1,
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT 1,
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT 1,
  `currency_symbol_placement` enum('before','after') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `ref_no_prefixes` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `theme_color` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sms_settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_labels` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `common_settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `razao_social` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `cnpj` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00.000.000/0000-00',
  `ie` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00000000000',
  `senha_certificado` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1234',
  `certificado` blob NOT NULL,
  `cidade_id` int(10) unsigned DEFAULT NULL,
  `rua` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `numero` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `bairro` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `cep` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00000-000',
  `telefone` varchar(14) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00 00000-0000',
  `ultimo_numero_nfe` int(11) NOT NULL DEFAULT 0,
  `ultimo_numero_nfce` int(11) NOT NULL DEFAULT 0,
  `ultimo_numero_cte` int(11) NOT NULL DEFAULT 0,
  `numero_serie_nfe` int(11) NOT NULL DEFAULT 1,
  `numero_serie_nfce` int(11) NOT NULL DEFAULT 1,
  `ambiente` int(11) NOT NULL DEFAULT 2,
  `regime` int(11) NOT NULL DEFAULT 1,
  `cst_csosn_padrao` int(11) NOT NULL DEFAULT 101,
  `cst_cofins_padrao` int(11) NOT NULL DEFAULT 49,
  `cst_pis_padrao` int(11) NOT NULL DEFAULT 49,
  `cst_ipi_padrao` int(11) NOT NULL DEFAULT 99,
  `perc_icms_padrao` decimal(5,2) NOT NULL DEFAULT 0.00,
  `perc_pis_padrao` decimal(5,2) NOT NULL DEFAULT 0.00,
  `perc_cofins_padrao` decimal(5,2) NOT NULL DEFAULT 0.00,
  `perc_ipi_padrao` decimal(5,2) NOT NULL DEFAULT 0.00,
  `ncm_padrao` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfop_saida_estadual_padrao` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfop_saida_inter_estadual_padrao` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `csc` varchar(70) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `csc_id` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_cidade_id_foreign` (`cidade_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cities` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'EzCompany Soluções',18,'2020-12-29',NULL,NULL,NULL,NULL,NULL,25.00,1,'America/Sao_Paulo',1,'fifo',0.00,'includes','1609253990_ezcompany_logo_light_gray.jpg',NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}','{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\",\"tables\",\"modifiers\",\"service_staff\",\"booking\",\"kitchen\",\"subscription\",\"types_of_service\"]','d/m/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null}',NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null}}','{\"default_datatable_page_entries\":\"25\"}',1,'FERNANDA MENEZES MAIA 07116028676','39.961.781/0001-16','00000000000','1234','',3068,'Av. Francisco Ribeiro','836','Santa Mônica','38408-186','34 999089201',0,0,0,1,1,2,1,101,49,49,99,0.00,0.00,0.00,0.00,'','','','12312','1231231','2020-12-29 13:47:48','2020-12-29 16:01:21'),(2,'PADARIA GRAMADO',18,'2020-12-29',NULL,NULL,NULL,NULL,NULL,25.00,2,'America/Sao_Paulo',1,'fifo',0.00,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}','{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','d/m/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null}',NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null}}','{\"default_datatable_page_entries\":\"25\"}',1,'GRAMADO PAES E DOCES LTDA','07.634.787/0001-92','7023882750015','MDEyMzQ1Njc4OQ==','0`0	*H\r\r	00	*H\r00*H\r\n00\n*H\r0\"DNؐFD,<\"F8oRrZcF^o8 #\"th{tg#[_tp4쭘Ks\0k62}GڀeޭWP77c[(GDp4	\\[u+%NF6?9AP(_`(~$nOMCF>_m2WEqLbߞӚF=Tv!q	_p\\)B섋e	_f erMk0ї°GqmIB2)VpYO*DAڂ]iM.(b|µc7˟Z-_;AzD\ZcCۣ Lvj>6\rhx|A>UNA7|Qsy&ÅSHe\"<V(h#X13rVNP[}6%ѳO^.Hǌ7\'\0(,=.H\rud77Yi))>TLi3XPS?R	ǈ22O5Hf;d?sa?$VF UPdT\ZfbXݟOkOIX#xַRƁrD\'sY:SEe5ʬ$\0	.h%[)dq<5tys]*yƔH{kX|ֹ3ܐh#40uMd?;xٰM*~M+M	wKa:ݙ2/MBpEcWM-&𐻳*%h/ot*\075\0-ﮜޣl6:@u:;|k㟘Jk?ũ}\nCM\rNK酥Vliƀ#rP}\0Kā{CZFpRyI$l\n[T;9tmpXb1iQh\nL$918w$\"Sg 7G(S< RL5{Fi&ݼ[Hg{B߆>[,\'`|_|{іx2;q-cx42[Cb[x֕\rU*o	Vy/J@͝&u4\"i+f(CYc^ʨP\\f	s\0L!{UZM\0X<vcj2\ZeԭgQCy\\\ZîK&10	*H\r	1\0\0\00#	*H\r	1\01\00\00\01\06\02\04\05\09\060]	+71PN\0M\0i\0c\0r\0o\0s\0o\0f\0t\0 \0S\0t\0r\0o\0n\0g\0 \0C\0r\0y\0p\0t\0o\0g\0r\0a\0p\0h\0i\0c\0 \0P\0r\0o\0v\0i\0d\0e\0r07	*H\r(0$\00	*H\r0\n*H\r0q:HBЀjR`pwB&nn1D{ӌJiar\'AŘf$:=SN$Xrze)Ai0hLkn`;pĦ30c;猲fnzp\nms/\n{c=p*{NEp*-ixbob7\"ke,\Z|YN(cB:\ny|`C\\ڙ֞XnH(Iz|]k<8`]h\0Zз\'/ӥSVOOIP<#C0f|u\Z0\ZP6`ܩvfqQOEt$a)n/Q\n\\QܗMY +u̥E1r8\'AI,Sv=E2Z?}\Z\ZMXI{aMRZVLOJ-1\0H5GILWi\n&;vpH軩+\Z|vyL]=M{l*sX/;\"/k`:xZ@Vh\0>\Z3f	KjPOT\Z-	MHg\0f3(q1xQMr4xOt8;UЄ`{1޼Y;c?/^ރxIbmW6)BV*xM3[7\nLצ1[W`^+xH8{k儡PDv쨾Ltwc/%QeZ8T!\'H=R$W^J.WafRHU7Y\Z\08l\Z-GA\rRҙ	C\nI\"\",Qi`l$\nvϋb%u@e%>	\rT	KN\rTi\\	BhܮUOTOW0\"yۗ$.<Ie dؼjm.[%_cәn76wHk?7JMGe%X7Ҭ,)qi7\n-Hy0Jԧlz{!ȘX>5fMo\riwMU#2,5[b?\06k\n붤e!1%cRn[&Aome\ZFǗ:_3ܶv;ɩN=4؝ah39ӵR-\rQaN;u&j.>\"Lq3&|ĵy9Ķa̦ߑ<$xą)X),x|ı\0?\'Vh;F#*+E){\ZqbRXt9:%3Lհ]Y!a\rQn-,ݧ.T hg9L(QVA@.܍e4\Z\r~>D7ԑ	NMDSYGӡCb	iyV(:\"BSi\0hyUC\\(0=\r\r5\0Ծe#J#d)(`\'0GtcYO~R0ޚF3),J!bO7~eQEo8vlܱf\0\r	\\Z4\\\r&\':^99gl\",NIwS@?-5B|NF%\\V#E~@HE:p71	\n+Hu4rpK2Y~J)yCؿ5nl7=5ɕ#5		(Ɣ&pfn92p>Z\n*$n\0	5XF;/;xLNik^~AUQTr,f;T;R}SYHp)nSܽA;21	,S$y?1o4ǣ:GfsT*{B\r[fPV9xZ([N-\06xati!raĦA\ZU`O{>gnqFs\rg.ߍo=|E0;00+\Zv7m:bX&dVm.@gM',3068,'PRACA COMENDADOR TUFFIC ISSA','02','RESIDENCIAL GRAMADO','38415-599','34 32132090',0,0,0,1,1,2,1,101,49,49,99,0.00,0.00,0.00,0.00,'','','','646128DFB0EB3C33','000001','2020-12-29 17:51:34','2020-12-29 18:17:22'),(3,'Doces Luana',18,'2020-12-30',NULL,NULL,NULL,NULL,NULL,25.00,3,'America/Sao_Paulo',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','d/m/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'*','00.000.000/0000-00','00000000000','1234','',NULL,'*','*','*','00000-000','00 00000-0000',0,0,0,1,1,2,1,101,49,49,99,0.00,0.00,0.00,0.00,'','','','','','2020-12-30 20:41:04','2020-12-30 20:41:04'),(5,'Bolo e cia',18,'2021-02-03',NULL,NULL,NULL,NULL,NULL,25.00,5,'America/Sao_Paulo',1,'fifo',NULL,'includes','1612353831_Bolo e Cia.logo.jpg',NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','d/m/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'*','00.000.000/0000-00','00000000000','1234','',NULL,'*','*','*','00000-000','00 00000-0000',0,0,0,1,1,2,1,101,49,49,99,0.00,0.00,0.00,0.00,'','','','','','2021-02-03 13:03:51','2021-02-03 13:03:51');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT 1,
  `receipt_printer_type` enum('browser','printer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `featured_products` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `default_payment_accounts` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','EzCompany Soluções','Nenhum','Brasil','MG','Uberlândia','38408-1',1,1,NULL,1,'browser',NULL,'+5534999089201','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(2,2,'BL0001','GRAMADO PAES E DOCES LTDA','Nenhum','Brasil','MG','UBERLANDIA','38415-5',2,2,NULL,1,'browser',NULL,'34999089201','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2020-12-29 17:51:35','2020-12-29 17:51:35'),(3,3,'BL0001','Doces Luana','Nenhum','Brasil','SP','Monte Aprazível','1515000',3,3,NULL,1,'browser',NULL,'1732952300','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(5,5,'BL0001','Bolo e cia','Aeroporto','Brasil','MG','Uberlândia','3840818',5,5,NULL,1,'browser',NULL,'34996937670','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2021-02-03 13:03:51','2021-02-03 13:03:51');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pay_method` enum('cash','card','cheque','bank_transfer','custom_pay_1','custom_pay_2','custom_pay_3','other') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` enum('initial','sell','transfer','refund') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,1,100.0000,'cash','credit','initial',NULL,'2020-12-29 20:24:53','2020-12-29 20:24:53'),(2,1,30.4100,'cash','credit','sell',5,'2020-12-29 20:28:08','2020-12-29 20:28:08'),(3,1,0.0000,'cash','credit','sell',5,'2020-12-29 20:28:08','2020-12-29 20:28:08'),(4,1,16.1400,'card','credit','sell',6,'2020-12-29 20:28:51','2020-12-29 20:28:51'),(5,1,0.0000,'cash','credit','sell',6,'2020-12-29 20:28:51','2020-12-29 20:28:51');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_card_slips` int(11) NOT NULL DEFAULT 0,
  `total_cheques` int(11) NOT NULL DEFAULT 0,
  `closing_note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,2,2,2,'open',NULL,0.0000,0,0,NULL,'2020-12-29 20:24:00','2020-12-29 20:24:53');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `category_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'GERAL',2,'1',0,2,'product','Produtos gerais para venda',NULL,NULL,'2020-12-29 18:18:49','2020-12-29 18:18:49'),(2,'Linha 1,00',3,'1',0,3,'product',NULL,NULL,NULL,'2020-12-30 20:43:13','2020-12-30 20:43:13'),(3,'Linha Paçoca Rolha',3,'2',0,3,'product',NULL,NULL,NULL,'2020-12-30 20:43:38','2020-12-30 20:43:38'),(4,'Linha 1,99',3,'3',0,3,'product',NULL,NULL,NULL,'2020-12-30 20:44:00','2020-12-30 20:44:00'),(5,'Linha Pote com 20',3,'4',0,3,'product',NULL,NULL,NULL,'2020-12-30 20:44:25','2020-12-30 20:44:25'),(6,'Linha Barras Pacote',3,'5',0,3,'product',NULL,NULL,NULL,'2020-12-30 20:44:50','2020-12-30 20:44:50');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uf` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5571 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'1100015','Alta Floresta D\'Oeste','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(2,'1100023','Ariquemes','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(3,'1100031','Cabixi','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(4,'1100049','Cacoal','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(5,'1100056','Cerejeiras','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(6,'1100064','Colorado do Oeste','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(7,'1100072','Corumbiara','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(8,'1100080','Costa Marques','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(9,'1100098','Espigão D\'Oeste','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(10,'1100106','Guajará-Mirim','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(11,'1100114','Jaru','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(12,'1100122','Ji-Paraná','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(13,'1100130','Machadinho D\'Oeste','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(14,'1100148','Nova Brasilândia D\'Oeste','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(15,'1100155','Ouro Preto do Oeste','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(16,'1100189','Pimenta Bueno','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(17,'1100205','Porto Velho','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(18,'1100254','Presidente Médici','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(19,'1100262','Rio Crespo','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(20,'1100288','Rolim de Moura','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(21,'1100296','Santa Luzia D\'Oeste','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(22,'1100304','Vilhena','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(23,'1100320','São Miguel do Guaporé','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(24,'1100338','Nova Mamoré','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(25,'1100346','Alvorada D\'Oeste','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(26,'1100379','Alto Alegre dos Parecis','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(27,'1100403','Alto Paraíso','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(28,'1100452','Buritis','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(29,'1100502','Novo Horizonte do Oeste','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(30,'1100601','Cacaulândia','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(31,'1100700','Campo Novo de Rondônia','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(32,'1100809','Candeias do Jamari','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(33,'1100908','Castanheiras','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(34,'1100924','Chupinguaia','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(35,'1100940','Cujubim','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(36,'1101005','Governador Jorge Teixeira','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(37,'1101104','Itapuã do Oeste','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(38,'1101203','Ministro Andreazza','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(39,'1101302','Mirante da Serra','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(40,'1101401','Monte Negro','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(41,'1101435','Nova União','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(42,'1101450','Parecis','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(43,'1101468','Pimenteiras do Oeste','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(44,'1101476','Primavera de Rondônia','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(45,'1101484','São Felipe D\'Oeste','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(46,'1101492','São Francisco do Guaporé','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(47,'1101500','Seringueiras','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(48,'1101559','Teixeirópolis','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(49,'1101609','Theobroma','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(50,'1101708','Urupá','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(51,'1101757','Vale do Anari','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(52,'1101807','Vale do Paraíso','RO','2020-11-24 14:29:02','2020-11-24 14:29:02'),(53,'1200013','Acrelândia','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(54,'1200054','Assis Brasil','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(55,'1200104','Brasiléia','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(56,'1200138','Bujari','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(57,'1200179','Capixaba','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(58,'1200203','Cruzeiro do Sul','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(59,'1200252','Epitaciolândia','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(60,'1200302','Feijó','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(61,'1200328','Jordão','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(62,'1200336','Mâncio Lima','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(63,'1200344','Manoel Urbano','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(64,'1200351','Marechal Thaumaturgo','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(65,'1200385','Plácido de Castro','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(66,'1200393','Porto Walter','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(67,'1200401','Rio Branco','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(68,'1200427','Rodrigues Alves','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(69,'1200435','Santa Rosa do Purus','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(70,'1200450','Senador Guiomard','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(71,'1200500','Sena Madureira','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(72,'1200609','Tarauacá','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(73,'1200708','Xapuri','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(74,'1200807','Porto Acre','AC','2020-11-24 14:29:02','2020-11-24 14:29:02'),(75,'1300029','Alvarães','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(76,'1300060','Amaturá','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(77,'1300086','Anamã','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(78,'1300102','Anori','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(79,'1300144','Apuí','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(80,'1300201','Atalaia do Norte','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(81,'1300300','Autazes','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(82,'1300409','Barcelos','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(83,'1300508','Barreirinha','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(84,'1300607','Benjamin Constant','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(85,'1300631','Beruri','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(86,'1300680','Boa Vista do Ramos','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(87,'1300706','Boca do Acre','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(88,'1300805','Borba','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(89,'1300839','Caapiranga','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(90,'1300904','Canutama','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(91,'1301001','Carauari','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(92,'1301100','Careiro','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(93,'1301159','Careiro da Várzea','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(94,'1301209','Coari','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(95,'1301308','Codajás','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(96,'1301407','Eirunepé','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(97,'1301506','Envira','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(98,'1301605','Fonte Boa','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(99,'1301654','Guajará','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(100,'1301704','Humaitá','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(101,'1301803','Ipixuna','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(102,'1301852','Iranduba','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(103,'1301902','Itacoatiara','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(104,'1301951','Itamarati','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(105,'1302009','Itapiranga','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(106,'1302108','Japurá','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(107,'1302207','Juruá','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(108,'1302306','Jutaí','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(109,'1302405','Lábrea','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(110,'1302504','Manacapuru','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(111,'1302553','Manaquiri','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(112,'1302603','Manaus','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(113,'1302702','Manicoré','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(114,'1302801','Maraã','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(115,'1302900','Maués','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(116,'1303007','Nhamundá','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(117,'1303106','Nova Olinda do Norte','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(118,'1303205','Novo Airão','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(119,'1303304','Novo Aripuanã','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(120,'1303403','Parintins','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(121,'1303502','Pauini','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(122,'1303536','Presidente Figueiredo','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(123,'1303569','Rio Preto da Eva','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(124,'1303601','Santa Isabel do Rio Negro','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(125,'1303700','Santo Antônio do Içá','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(126,'1303809','São Gabriel da Cachoeira','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(127,'1303908','São Paulo de Olivença','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(128,'1303957','São Sebastião do Uatumã','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(129,'1304005','Silves','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(130,'1304062','Tabatinga','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(131,'1304104','Tapauá','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(132,'1304203','Tefé','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(133,'1304237','Tonantins','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(134,'1304260','Uarini','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(135,'1304302','Urucará','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(136,'1304401','Urucurituba','AM','2020-11-24 14:29:02','2020-11-24 14:29:02'),(137,'1400027','Amajari','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(138,'1400050','Alto Alegre','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(139,'1400100','Boa Vista','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(140,'1400159','Bonfim','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(141,'1400175','Cantá','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(142,'1400209','Caracaraí','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(143,'1400233','Caroebe','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(144,'1400282','Iracema','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(145,'1400308','Mucajaí','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(146,'1400407','Normandia','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(147,'1400456','Pacaraima','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(148,'1400472','Rorainópolis','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(149,'1400506','São João da Baliza','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(150,'1400605','São Luiz','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(151,'1400704','Uiramutã','RR','2020-11-24 14:29:02','2020-11-24 14:29:02'),(152,'1500107','Abaetetuba','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(153,'1500131','Abel Figueiredo','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(154,'1500206','Acará','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(155,'1500305','Afuá','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(156,'1500347','Água Azul do Norte','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(157,'1500404','Alenquer','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(158,'1500503','Almeirim','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(159,'1500602','Altamira','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(160,'1500701','Anajás','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(161,'1500800','Ananindeua','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(162,'1500859','Anapu','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(163,'1500909','Augusto Corrêa','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(164,'1500958','Aurora do Pará','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(165,'1501006','Aveiro','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(166,'1501105','Bagre','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(167,'1501204','Baião','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(168,'1501253','Bannach','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(169,'1501303','Barcarena','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(170,'1501402','Belém','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(171,'1501451','Belterra','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(172,'1501501','Benevides','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(173,'1501576','Bom Jesus do Tocantins','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(174,'1501600','Bonito','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(175,'1501709','Bragança','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(176,'1501725','Brasil Novo','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(177,'1501758','Brejo Grande do Araguaia','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(178,'1501782','Breu Branco','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(179,'1501808','Breves','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(180,'1501907','Bujaru','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(181,'1501956','Cachoeira do Piriá','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(182,'1502004','Cachoeira do Arari','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(183,'1502103','Cametá','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(184,'1502152','Canaã dos Carajás','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(185,'1502202','Capanema','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(186,'1502301','Capitão Poço','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(187,'1502400','Castanhal','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(188,'1502509','Chaves','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(189,'1502608','Colares','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(190,'1502707','Conceição do Araguaia','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(191,'1502756','Concórdia do Pará','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(192,'1502764','Cumaru do Norte','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(193,'1502772','Curionópolis','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(194,'1502806','Curralinho','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(195,'1502855','Curuá','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(196,'1502905','Curuçá','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(197,'1502939','Dom Eliseu','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(198,'1502954','Eldorado dos Carajás','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(199,'1503002','Faro','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(200,'1503044','Floresta do Araguaia','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(201,'1503077','Garrafão do Norte','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(202,'1503093','Goianésia do Pará','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(203,'1503101','Gurupá','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(204,'1503200','Igarapé-Açu','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(205,'1503309','Igarapé-Miri','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(206,'1503408','Inhangapi','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(207,'1503457','Ipixuna do Pará','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(208,'1503507','Irituia','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(209,'1503606','Itaituba','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(210,'1503705','Itupiranga','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(211,'1503754','Jacareacanga','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(212,'1503804','Jacundá','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(213,'1503903','Juruti','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(214,'1504000','Limoeiro do Ajuru','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(215,'1504059','Mãe do Rio','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(216,'1504109','Magalhães Barata','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(217,'1504208','Marabá','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(218,'1504307','Maracanã','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(219,'1504406','Marapanim','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(220,'1504422','Marituba','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(221,'1504455','Medicilândia','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(222,'1504505','Melgaço','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(223,'1504604','Mocajuba','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(224,'1504703','Moju','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(225,'1504752','Mojuí dos Campos','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(226,'1504802','Monte Alegre','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(227,'1504901','Muaná','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(228,'1504950','Nova Esperança do Piriá','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(229,'1504976','Nova Ipixuna','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(230,'1505007','Nova Timboteua','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(231,'1505031','Novo Progresso','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(232,'1505064','Novo Repartimento','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(233,'1505106','Óbidos','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(234,'1505205','Oeiras do Pará','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(235,'1505304','Oriximiná','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(236,'1505403','Ourém','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(237,'1505437','Ourilândia do Norte','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(238,'1505486','Pacajá','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(239,'1505494','Palestina do Pará','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(240,'1505502','Paragominas','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(241,'1505536','Parauapebas','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(242,'1505551','Pau D\'Arco','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(243,'1505601','Peixe-Boi','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(244,'1505635','Piçarra','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(245,'1505650','Placas','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(246,'1505700','Ponta de Pedras','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(247,'1505809','Portel','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(248,'1505908','Porto de Moz','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(249,'1506005','Prainha','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(250,'1506104','Primavera','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(251,'1506112','Quatipuru','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(252,'1506138','Redenção','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(253,'1506161','Rio Maria','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(254,'1506187','Rondon do Pará','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(255,'1506195','Rurópolis','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(256,'1506203','Salinópolis','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(257,'1506302','Salvaterra','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(258,'1506351','Santa Bárbara do Pará','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(259,'1506401','Santa Cruz do Arari','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(260,'1506500','Santa Isabel do Pará','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(261,'1506559','Santa Luzia do Pará','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(262,'1506583','Santa Maria das Barreiras','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(263,'1506609','Santa Maria do Pará','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(264,'1506708','Santana do Araguaia','PA','2020-11-24 14:29:02','2020-11-24 14:29:02'),(265,'1506807','Santarém','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(266,'1506906','Santarém Novo','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(267,'1507003','Santo Antônio do Tauá','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(268,'1507102','São Caetano de Odivelas','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(269,'1507151','São Domingos do Araguaia','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(270,'1507201','São Domingos do Capim','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(271,'1507300','São Félix do Xingu','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(272,'1507409','São Francisco do Pará','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(273,'1507458','São Geraldo do Araguaia','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(274,'1507466','São João da Ponta','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(275,'1507474','São João de Pirabas','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(276,'1507508','São João do Araguaia','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(277,'1507607','São Miguel do Guamá','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(278,'1507706','São Sebastião da Boa Vista','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(279,'1507755','Sapucaia','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(280,'1507805','Senador José Porfírio','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(281,'1507904','Soure','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(282,'1507953','Tailândia','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(283,'1507961','Terra Alta','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(284,'1507979','Terra Santa','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(285,'1508001','Tomé-Açu','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(286,'1508035','Tracuateua','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(287,'1508050','Trairão','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(288,'1508084','Tucumã','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(289,'1508100','Tucuruí','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(290,'1508126','Ulianópolis','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(291,'1508159','Uruará','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(292,'1508209','Vigia','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(293,'1508308','Viseu','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(294,'1508357','Vitória do Xingu','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(295,'1508407','Xinguara','PA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(296,'1600055','Serra do Navio','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(297,'1600105','Amapá','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(298,'1600154','Pedra Branca do Amapari','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(299,'1600204','Calçoene','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(300,'1600212','Cutias','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(301,'1600238','Ferreira Gomes','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(302,'1600253','Itaubal','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(303,'1600279','Laranjal do Jari','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(304,'1600303','Macapá','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(305,'1600402','Mazagão','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(306,'1600501','Oiapoque','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(307,'1600535','Porto Grande','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(308,'1600550','Pracuúba','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(309,'1600600','Santana','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(310,'1600709','Tartarugalzinho','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(311,'1600808','Vitória do Jari','AP','2020-11-24 14:29:03','2020-11-24 14:29:03'),(312,'1700251','Abreulândia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(313,'1700301','Aguiarnópolis','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(314,'1700350','Aliança do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(315,'1700400','Almas','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(316,'1700707','Alvorada','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(317,'1701002','Ananás','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(318,'1701051','Angico','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(319,'1701101','Aparecida do Rio Negro','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(320,'1701309','Aragominas','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(321,'1701903','Araguacema','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(322,'1702000','Araguaçu','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(323,'1702109','Araguaína','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(324,'1702158','Araguanã','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(325,'1702208','Araguatins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(326,'1702307','Arapoema','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(327,'1702406','Arraias','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(328,'1702554','Augustinópolis','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(329,'1702703','Aurora do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(330,'1702901','Axixá do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(331,'1703008','Babaçulândia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(332,'1703057','Bandeirantes do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(333,'1703073','Barra do Ouro','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(334,'1703107','Barrolândia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(335,'1703206','Bernardo Sayão','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(336,'1703305','Bom Jesus do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(337,'1703602','Brasilândia do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(338,'1703701','Brejinho de Nazaré','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(339,'1703800','Buriti do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(340,'1703826','Cachoeirinha','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(341,'1703842','Campos Lindos','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(342,'1703867','Cariri do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(343,'1703883','Carmolândia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(344,'1703891','Carrasco Bonito','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(345,'1703909','Caseara','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(346,'1704105','Centenário','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(347,'1704600','Chapada de Areia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(348,'1705102','Chapada da Natividade','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(349,'1705508','Colinas do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(350,'1705557','Combinado','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(351,'1705607','Conceição do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(352,'1706001','Couto Magalhães','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(353,'1706100','Cristalândia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(354,'1706258','Crixás do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(355,'1706506','Darcinópolis','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(356,'1707009','Dianópolis','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(357,'1707108','Divinópolis do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(358,'1707207','Dois Irmãos do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(359,'1707306','Dueré','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(360,'1707405','Esperantina','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(361,'1707553','Fátima','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(362,'1707652','Figueirópolis','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(363,'1707702','Filadélfia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(364,'1708205','Formoso do Araguaia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(365,'1708254','Fortaleza do Tabocão','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(366,'1708304','Goianorte','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(367,'1709005','Goiatins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(368,'1709302','Guaraí','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(369,'1709500','Gurupi','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(370,'1709807','Ipueiras','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(371,'1710508','Itacajá','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(372,'1710706','Itaguatins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(373,'1710904','Itapiratins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(374,'1711100','Itaporã do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(375,'1711506','Jaú do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(376,'1711803','Juarina','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(377,'1711902','Lagoa da Confusão','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(378,'1711951','Lagoa do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(379,'1712009','Lajeado','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(380,'1712157','Lavandeira','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(381,'1712405','Lizarda','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(382,'1712454','Luzinópolis','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(383,'1712504','Marianópolis do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(384,'1712702','Mateiros','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(385,'1712801','Maurilândia do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(386,'1713205','Miracema do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(387,'1713304','Miranorte','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(388,'1713601','Monte do Carmo','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(389,'1713700','Monte Santo do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(390,'1713809','Palmeiras do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(391,'1713957','Muricilândia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(392,'1714203','Natividade','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(393,'1714302','Nazaré','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(394,'1714880','Nova Olinda','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(395,'1715002','Nova Rosalândia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(396,'1715101','Novo Acordo','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(397,'1715150','Novo Alegre','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(398,'1715259','Novo Jardim','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(399,'1715507','Oliveira de Fátima','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(400,'1715705','Palmeirante','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(401,'1715754','Palmeirópolis','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(402,'1716109','Paraíso do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(403,'1716208','Paranã','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(404,'1716307','Pau D\'Arco','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(405,'1716505','Pedro Afonso','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(406,'1716604','Peixe','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(407,'1716653','Pequizeiro','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(408,'1716703','Colméia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(409,'1717008','Pindorama do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(410,'1717206','Piraquê','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(411,'1717503','Pium','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(412,'1717800','Ponte Alta do Bom Jesus','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(413,'1717909','Ponte Alta do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(414,'1718006','Porto Alegre do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(415,'1718204','Porto Nacional','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(416,'1718303','Praia Norte','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(417,'1718402','Presidente Kennedy','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(418,'1718451','Pugmil','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(419,'1718501','Recursolândia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(420,'1718550','Riachinho','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(421,'1718659','Rio da Conceição','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(422,'1718709','Rio dos Bois','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(423,'1718758','Rio Sono','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(424,'1718808','Sampaio','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(425,'1718840','Sandolândia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(426,'1718865','Santa Fé do Araguaia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(427,'1718881','Santa Maria do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(428,'1718899','Santa Rita do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(429,'1718907','Santa Rosa do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(430,'1719004','Santa Tereza do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(431,'1720002','Santa Terezinha do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(432,'1720101','São Bento do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(433,'1720150','São Félix do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(434,'1720200','São Miguel do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(435,'1720259','São Salvador do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(436,'1720309','São Sebastião do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(437,'1720499','São Valério','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(438,'1720655','Silvanópolis','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(439,'1720804','Sítio Novo do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(440,'1720853','Sucupira','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(441,'1720903','Taguatinga','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(442,'1720937','Taipas do Tocantins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(443,'1720978','Talismã','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(444,'1721000','Palmas','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(445,'1721109','Tocantínia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(446,'1721208','Tocantinópolis','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(447,'1721257','Tupirama','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(448,'1721307','Tupiratins','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(449,'1722081','Wanderlândia','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(450,'1722107','Xambioá','TO','2020-11-24 14:29:03','2020-11-24 14:29:03'),(451,'2100055','Açailândia','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(452,'2100105','Afonso Cunha','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(453,'2100154','Água Doce do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(454,'2100204','Alcântara','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(455,'2100303','Aldeias Altas','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(456,'2100402','Altamira do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(457,'2100436','Alto Alegre do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(458,'2100477','Alto Alegre do Pindaré','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(459,'2100501','Alto Parnaíba','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(460,'2100550','Amapá do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(461,'2100600','Amarante do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(462,'2100709','Anajatuba','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(463,'2100808','Anapurus','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(464,'2100832','Apicum-Açu','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(465,'2100873','Araguanã','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(466,'2100907','Araioses','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(467,'2100956','Arame','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(468,'2101004','Arari','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(469,'2101103','Axixá','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(470,'2101202','Bacabal','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(471,'2101251','Bacabeira','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(472,'2101301','Bacuri','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(473,'2101350','Bacurituba','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(474,'2101400','Balsas','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(475,'2101509','Barão de Grajaú','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(476,'2101608','Barra do Corda','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(477,'2101707','Barreirinhas','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(478,'2101731','Belágua','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(479,'2101772','Bela Vista do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(480,'2101806','Benedito Leite','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(481,'2101905','Bequimão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(482,'2101939','Bernardo do Mearim','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(483,'2101970','Boa Vista do Gurupi','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(484,'2102002','Bom Jardim','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(485,'2102036','Bom Jesus das Selvas','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(486,'2102077','Bom Lugar','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(487,'2102101','Brejo','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(488,'2102150','Brejo de Areia','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(489,'2102200','Buriti','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(490,'2102309','Buriti Bravo','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(491,'2102325','Buriticupu','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(492,'2102358','Buritirana','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(493,'2102374','Cachoeira Grande','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(494,'2102408','Cajapió','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(495,'2102507','Cajari','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(496,'2102556','Campestre do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(497,'2102606','Cândido Mendes','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(498,'2102705','Cantanhede','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(499,'2102754','Capinzal do Norte','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(500,'2102804','Carolina','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(501,'2102903','Carutapera','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(502,'2103000','Caxias','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(503,'2103109','Cedral','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(504,'2103125','Central do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(505,'2103158','Centro do Guilherme','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(506,'2103174','Centro Novo do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(507,'2103208','Chapadinha','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(508,'2103257','Cidelândia','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(509,'2103307','Codó','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(510,'2103406','Coelho Neto','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(511,'2103505','Colinas','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(512,'2103554','Conceição do Lago-Açu','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(513,'2103604','Coroatá','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(514,'2103703','Cururupu','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(515,'2103752','Davinópolis','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(516,'2103802','Dom Pedro','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(517,'2103901','Duque Bacelar','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(518,'2104008','Esperantinópolis','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(519,'2104057','Estreito','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(520,'2104073','Feira Nova do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(521,'2104081','Fernando Falcão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(522,'2104099','Formosa da Serra Negra','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(523,'2104107','Fortaleza dos Nogueiras','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(524,'2104206','Fortuna','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(525,'2104305','Godofredo Viana','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(526,'2104404','Gonçalves Dias','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(527,'2104503','Governador Archer','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(528,'2104552','Governador Edison Lobão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(529,'2104602','Governador Eugênio Barros','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(530,'2104628','Governador Luiz Rocha','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(531,'2104651','Governador Newton Bello','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(532,'2104677','Governador Nunes Freire','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(533,'2104701','Graça Aranha','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(534,'2104800','Grajaú','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(535,'2104909','Guimarães','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(536,'2105005','Humberto de Campos','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(537,'2105104','Icatu','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(538,'2105153','Igarapé do Meio','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(539,'2105203','Igarapé Grande','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(540,'2105302','Imperatriz','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(541,'2105351','Itaipava do Grajaú','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(542,'2105401','Itapecuru Mirim','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(543,'2105427','Itinga do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(544,'2105450','Jatobá','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(545,'2105476','Jenipapo dos Vieiras','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(546,'2105500','João Lisboa','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(547,'2105609','Joselândia','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(548,'2105658','Junco do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(549,'2105708','Lago da Pedra','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(550,'2105807','Lago do Junco','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(551,'2105906','Lago Verde','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(552,'2105922','Lagoa do Mato','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(553,'2105948','Lago dos Rodrigues','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(554,'2105963','Lagoa Grande do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(555,'2105989','Lajeado Novo','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(556,'2106003','Lima Campos','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(557,'2106102','Loreto','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(558,'2106201','Luís Domingues','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(559,'2106300','Magalhães de Almeida','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(560,'2106326','Maracaçumé','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(561,'2106359','Marajá do Sena','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(562,'2106375','Maranhãozinho','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(563,'2106409','Mata Roma','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(564,'2106508','Matinha','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(565,'2106607','Matões','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(566,'2106631','Matões do Norte','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(567,'2106672','Milagres do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(568,'2106706','Mirador','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(569,'2106755','Miranda do Norte','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(570,'2106805','Mirinzal','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(571,'2106904','Monção','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(572,'2107001','Montes Altos','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(573,'2107100','Morros','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(574,'2107209','Nina Rodrigues','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(575,'2107258','Nova Colinas','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(576,'2107308','Nova Iorque','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(577,'2107357','Nova Olinda do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(578,'2107407','Olho D\'Água das Cunhãs','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(579,'2107456','Olinda Nova do Maranhão','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(580,'2107506','Paço do Lumiar','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(581,'2107605','Palmeirândia','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(582,'2107704','Paraibano','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(583,'2107803','Parnarama','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(584,'2107902','Passagem Franca','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(585,'2108009','Pastos Bons','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(586,'2108058','Paulino Neves','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(587,'2108108','Paulo Ramos','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(588,'2108207','Pedreiras','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(589,'2108256','Pedro do Rosário','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(590,'2108306','Penalva','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(591,'2108405','Peri Mirim','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(592,'2108454','Peritoró','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(593,'2108504','Pindaré-Mirim','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(594,'2108603','Pinheiro','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(595,'2108702','Pio XII','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(596,'2108801','Pirapemas','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(597,'2108900','Poção de Pedras','MA','2020-11-24 14:29:03','2020-11-24 14:29:03'),(598,'2109007','Porto Franco','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(599,'2109056','Porto Rico do Maranhão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(600,'2109106','Presidente Dutra','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(601,'2109205','Presidente Juscelino','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(602,'2109239','Presidente Médici','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(603,'2109270','Presidente Sarney','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(604,'2109304','Presidente Vargas','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(605,'2109403','Primeira Cruz','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(606,'2109452','Raposa','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(607,'2109502','Riachão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(608,'2109551','Ribamar Fiquene','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(609,'2109601','Rosário','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(610,'2109700','Sambaíba','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(611,'2109759','Santa Filomena do Maranhão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(612,'2109809','Santa Helena','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(613,'2109908','Santa Inês','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(614,'2110005','Santa Luzia','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(615,'2110039','Santa Luzia do Paruá','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(616,'2110104','Santa Quitéria do Maranhão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(617,'2110203','Santa Rita','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(618,'2110237','Santana do Maranhão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(619,'2110278','Santo Amaro do Maranhão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(620,'2110302','Santo Antônio dos Lopes','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(621,'2110401','São Benedito do Rio Preto','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(622,'2110500','São Bento','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(623,'2110609','São Bernardo','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(624,'2110658','São Domingos do Azeitão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(625,'2110708','São Domingos do Maranhão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(626,'2110807','São Félix de Balsas','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(627,'2110856','São Francisco do Brejão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(628,'2110906','São Francisco do Maranhão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(629,'2111003','São João Batista','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(630,'2111029','São João do Carú','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(631,'2111052','São João do Paraíso','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(632,'2111078','São João do Soter','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(633,'2111102','São João dos Patos','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(634,'2111201','São José de Ribamar','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(635,'2111250','São José dos Basílios','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(636,'2111300','São Luís','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(637,'2111409','São Luís Gonzaga do Maranhão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(638,'2111508','São Mateus do Maranhão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(639,'2111532','São Pedro da Água Branca','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(640,'2111573','São Pedro dos Crentes','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(641,'2111607','São Raimundo das Mangabeiras','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(642,'2111631','São Raimundo do Doca Bezerra','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(643,'2111672','São Roberto','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(644,'2111706','São Vicente Ferrer','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(645,'2111722','Satubinha','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(646,'2111748','Senador Alexandre Costa','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(647,'2111763','Senador La Rocque','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(648,'2111789','Serrano do Maranhão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(649,'2111805','Sítio Novo','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(650,'2111904','Sucupira do Norte','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(651,'2111953','Sucupira do Riachão','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(652,'2112001','Tasso Fragoso','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(653,'2112100','Timbiras','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(654,'2112209','Timon','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(655,'2112233','Trizidela do Vale','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(656,'2112274','Tufilândia','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(657,'2112308','Tuntum','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(658,'2112407','Turiaçu','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(659,'2112456','Turilândia','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(660,'2112506','Tutóia','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(661,'2112605','Urbano Santos','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(662,'2112704','Vargem Grande','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(663,'2112803','Viana','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(664,'2112852','Vila Nova dos Martírios','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(665,'2112902','Vitória do Mearim','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(666,'2113009','Vitorino Freire','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(667,'2114007','Zé Doca','MA','2020-11-24 14:29:04','2020-11-24 14:29:04'),(668,'2200053','Acauã','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(669,'2200103','Agricolândia','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(670,'2200202','Água Branca','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(671,'2200251','Alagoinha do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(672,'2200277','Alegrete do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(673,'2200301','Alto Longá','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(674,'2200400','Altos','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(675,'2200459','Alvorada do Gurguéia','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(676,'2200509','Amarante','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(677,'2200608','Angical do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(678,'2200707','Anísio de Abreu','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(679,'2200806','Antônio Almeida','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(680,'2200905','Aroazes','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(681,'2200954','Aroeiras do Itaim','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(682,'2201002','Arraial','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(683,'2201051','Assunção do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(684,'2201101','Avelino Lopes','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(685,'2201150','Baixa Grande do Ribeiro','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(686,'2201176','Barra D\'Alcântara','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(687,'2201200','Barras','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(688,'2201309','Barreiras do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(689,'2201408','Barro Duro','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(690,'2201507','Batalha','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(691,'2201556','Bela Vista do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(692,'2201572','Belém do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(693,'2201606','Beneditinos','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(694,'2201705','Bertolínia','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(695,'2201739','Betânia do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(696,'2201770','Boa Hora','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(697,'2201804','Bocaina','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(698,'2201903','Bom Jesus','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(699,'2201919','Bom Princípio do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(700,'2201929','Bonfim do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(701,'2201945','Boqueirão do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(702,'2201960','Brasileira','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(703,'2201988','Brejo do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(704,'2202000','Buriti dos Lopes','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(705,'2202026','Buriti dos Montes','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(706,'2202059','Cabeceiras do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(707,'2202075','Cajazeiras do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(708,'2202083','Cajueiro da Praia','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(709,'2202091','Caldeirão Grande do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(710,'2202109','Campinas do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(711,'2202117','Campo Alegre do Fidalgo','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(712,'2202133','Campo Grande do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(713,'2202174','Campo Largo do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(714,'2202208','Campo Maior','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(715,'2202251','Canavieira','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(716,'2202307','Canto do Buriti','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(717,'2202406','Capitão de Campos','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(718,'2202455','Capitão Gervásio Oliveira','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(719,'2202505','Caracol','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(720,'2202539','Caraúbas do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(721,'2202554','Caridade do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(722,'2202604','Castelo do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(723,'2202653','Caxingó','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(724,'2202703','Cocal','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(725,'2202711','Cocal de Telha','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(726,'2202729','Cocal dos Alves','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(727,'2202737','Coivaras','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(728,'2202752','Colônia do Gurguéia','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(729,'2202778','Colônia do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(730,'2202802','Conceição do Canindé','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(731,'2202851','Coronel José Dias','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(732,'2202901','Corrente','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(733,'2203008','Cristalândia do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(734,'2203107','Cristino Castro','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(735,'2203206','Curimatá','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(736,'2203230','Currais','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(737,'2203255','Curralinhos','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(738,'2203271','Curral Novo do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(739,'2203305','Demerval Lobão','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(740,'2203354','Dirceu Arcoverde','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(741,'2203404','Dom Expedito Lopes','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(742,'2203420','Domingos Mourão','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(743,'2203453','Dom Inocêncio','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(744,'2203503','Elesbão Veloso','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(745,'2203602','Eliseu Martins','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(746,'2203701','Esperantina','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(747,'2203750','Fartura do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(748,'2203800','Flores do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(749,'2203859','Floresta do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(750,'2203909','Floriano','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(751,'2204006','Francinópolis','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(752,'2204105','Francisco Ayres','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(753,'2204154','Francisco Macedo','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(754,'2204204','Francisco Santos','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(755,'2204303','Fronteiras','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(756,'2204352','Geminiano','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(757,'2204402','Gilbués','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(758,'2204501','Guadalupe','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(759,'2204550','Guaribas','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(760,'2204600','Hugo Napoleão','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(761,'2204659','Ilha Grande','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(762,'2204709','Inhuma','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(763,'2204808','Ipiranga do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(764,'2204907','Isaías Coelho','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(765,'2205003','Itainópolis','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(766,'2205102','Itaueira','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(767,'2205151','Jacobina do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(768,'2205201','Jaicós','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(769,'2205250','Jardim do Mulato','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(770,'2205276','Jatobá do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(771,'2205300','Jerumenha','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(772,'2205359','João Costa','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(773,'2205409','Joaquim Pires','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(774,'2205458','Joca Marques','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(775,'2205508','José de Freitas','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(776,'2205516','Juazeiro do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(777,'2205524','Júlio Borges','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(778,'2205532','Jurema','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(779,'2205540','Lagoinha do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(780,'2205557','Lagoa Alegre','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(781,'2205565','Lagoa do Barro do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(782,'2205573','Lagoa de São Francisco','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(783,'2205581','Lagoa do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(784,'2205599','Lagoa do Sítio','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(785,'2205607','Landri Sales','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(786,'2205706','Luís Correia','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(787,'2205805','Luzilândia','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(788,'2205854','Madeiro','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(789,'2205904','Manoel Emídio','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(790,'2205953','Marcolândia','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(791,'2206001','Marcos Parente','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(792,'2206050','Massapê do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(793,'2206100','Matias Olímpio','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(794,'2206209','Miguel Alves','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(795,'2206308','Miguel Leão','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(796,'2206357','Milton Brandão','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(797,'2206407','Monsenhor Gil','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(798,'2206506','Monsenhor Hipólito','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(799,'2206605','Monte Alegre do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(800,'2206654','Morro Cabeça no Tempo','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(801,'2206670','Morro do Chapéu do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(802,'2206696','Murici dos Portelas','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(803,'2206704','Nazaré do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(804,'2206720','Nazária','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(805,'2206753','Nossa Senhora de Nazaré','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(806,'2206803','Nossa Senhora dos Remédios','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(807,'2206902','Novo Oriente do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(808,'2206951','Novo Santo Antônio','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(809,'2207009','Oeiras','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(810,'2207108','Olho D\'Água do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(811,'2207207','Padre Marcos','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(812,'2207306','Paes Landim','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(813,'2207355','Pajeú do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(814,'2207405','Palmeira do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(815,'2207504','Palmeirais','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(816,'2207553','Paquetá','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(817,'2207603','Parnaguá','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(818,'2207702','Parnaíba','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(819,'2207751','Passagem Franca do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(820,'2207777','Patos do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(821,'2207793','Pau D\'Arco do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(822,'2207801','Paulistana','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(823,'2207850','Pavussu','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(824,'2207900','Pedro II','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(825,'2207934','Pedro Laurentino','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(826,'2207959','Nova Santa Rita','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(827,'2208007','Picos','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(828,'2208106','Pimenteiras','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(829,'2208205','Pio IX','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(830,'2208304','Piracuruca','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(831,'2208403','Piripiri','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(832,'2208502','Porto','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(833,'2208551','Porto Alegre do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(834,'2208601','Prata do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(835,'2208650','Queimada Nova','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(836,'2208700','Redenção do Gurguéia','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(837,'2208809','Regeneração','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(838,'2208858','Riacho Frio','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(839,'2208874','Ribeira do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(840,'2208908','Ribeiro Gonçalves','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(841,'2209005','Rio Grande do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(842,'2209104','Santa Cruz do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(843,'2209153','Santa Cruz dos Milagres','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(844,'2209203','Santa Filomena','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(845,'2209302','Santa Luz','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(846,'2209351','Santana do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(847,'2209377','Santa Rosa do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(848,'2209401','Santo Antônio de Lisboa','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(849,'2209450','Santo Antônio dos Milagres','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(850,'2209500','Santo Inácio do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(851,'2209559','São Braz do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(852,'2209609','São Félix do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(853,'2209658','São Francisco de Assis do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(854,'2209708','São Francisco do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(855,'2209757','São Gonçalo do Gurguéia','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(856,'2209807','São Gonçalo do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(857,'2209856','São João da Canabrava','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(858,'2209872','São João da Fronteira','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(859,'2209906','São João da Serra','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(860,'2209955','São João da Varjota','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(861,'2209971','São João do Arraial','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(862,'2210003','São João do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(863,'2210052','São José do Divino','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(864,'2210102','São José do Peixe','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(865,'2210201','São José do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(866,'2210300','São Julião','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(867,'2210359','São Lourenço do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(868,'2210375','São Luis do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(869,'2210383','São Miguel da Baixa Grande','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(870,'2210391','São Miguel do Fidalgo','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(871,'2210409','São Miguel do Tapuio','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(872,'2210508','São Pedro do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(873,'2210607','São Raimundo Nonato','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(874,'2210623','Sebastião Barros','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(875,'2210631','Sebastião Leal','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(876,'2210656','Sigefredo Pacheco','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(877,'2210706','Simões','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(878,'2210805','Simplício Mendes','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(879,'2210904','Socorro do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(880,'2210938','Sussuapara','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(881,'2210953','Tamboril do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(882,'2210979','Tanque do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(883,'2211001','Teresina','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(884,'2211100','União','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(885,'2211209','Uruçuí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(886,'2211308','Valença do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(887,'2211357','Várzea Branca','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(888,'2211407','Várzea Grande','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(889,'2211506','Vera Mendes','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(890,'2211605','Vila Nova do Piauí','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(891,'2211704','Wall Ferraz','PI','2020-11-24 14:29:04','2020-11-24 14:29:04'),(892,'2300101','Abaiara','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(893,'2300150','Acarape','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(894,'2300200','Acaraú','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(895,'2300309','Acopiara','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(896,'2300408','Aiuaba','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(897,'2300507','Alcântaras','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(898,'2300606','Altaneira','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(899,'2300705','Alto Santo','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(900,'2300754','Amontada','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(901,'2300804','Antonina do Norte','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(902,'2300903','Apuiarés','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(903,'2301000','Aquiraz','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(904,'2301109','Aracati','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(905,'2301208','Aracoiaba','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(906,'2301257','Ararendá','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(907,'2301307','Araripe','CE','2020-11-24 14:29:04','2020-11-24 14:29:04'),(908,'2301406','Aratuba','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(909,'2301505','Arneiroz','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(910,'2301604','Assaré','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(911,'2301703','Aurora','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(912,'2301802','Baixio','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(913,'2301851','Banabuiú','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(914,'2301901','Barbalha','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(915,'2301950','Barreira','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(916,'2302008','Barro','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(917,'2302057','Barroquinha','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(918,'2302107','Baturité','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(919,'2302206','Beberibe','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(920,'2302305','Bela Cruz','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(921,'2302404','Boa Viagem','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(922,'2302503','Brejo Santo','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(923,'2302602','Camocim','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(924,'2302701','Campos Sales','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(925,'2302800','Canindé','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(926,'2302909','Capistrano','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(927,'2303006','Caridade','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(928,'2303105','Cariré','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(929,'2303204','Caririaçu','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(930,'2303303','Cariús','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(931,'2303402','Carnaubal','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(932,'2303501','Cascavel','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(933,'2303600','Catarina','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(934,'2303659','Catunda','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(935,'2303709','Caucaia','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(936,'2303808','Cedro','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(937,'2303907','Chaval','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(938,'2303931','Choró','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(939,'2303956','Chorozinho','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(940,'2304004','Coreaú','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(941,'2304103','Crateús','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(942,'2304202','Crato','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(943,'2304236','Croatá','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(944,'2304251','Cruz','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(945,'2304269','Deputado Irapuan Pinheiro','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(946,'2304277','Ererê','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(947,'2304285','Eusébio','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(948,'2304301','Farias Brito','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(949,'2304350','Forquilha','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(950,'2304400','Fortaleza','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(951,'2304459','Fortim','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(952,'2304509','Frecheirinha','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(953,'2304608','General Sampaio','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(954,'2304657','Graça','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(955,'2304707','Granja','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(956,'2304806','Granjeiro','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(957,'2304905','Groaíras','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(958,'2304954','Guaiúba','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(959,'2305001','Guaraciaba do Norte','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(960,'2305100','Guaramiranga','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(961,'2305209','Hidrolândia','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(962,'2305233','Horizonte','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(963,'2305266','Ibaretama','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(964,'2305308','Ibiapina','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(965,'2305332','Ibicuitinga','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(966,'2305357','Icapuí','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(967,'2305407','Icó','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(968,'2305506','Iguatu','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(969,'2305605','Independência','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(970,'2305654','Ipaporanga','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(971,'2305704','Ipaumirim','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(972,'2305803','Ipu','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(973,'2305902','Ipueiras','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(974,'2306009','Iracema','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(975,'2306108','Irauçuba','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(976,'2306207','Itaiçaba','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(977,'2306256','Itaitinga','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(978,'2306306','Itapagé','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(979,'2306405','Itapipoca','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(980,'2306504','Itapiúna','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(981,'2306553','Itarema','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(982,'2306603','Itatira','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(983,'2306702','Jaguaretama','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(984,'2306801','Jaguaribara','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(985,'2306900','Jaguaribe','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(986,'2307007','Jaguaruana','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(987,'2307106','Jardim','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(988,'2307205','Jati','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(989,'2307254','Jijoca de Jericoacoara','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(990,'2307304','Juazeiro do Norte','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(991,'2307403','Jucás','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(992,'2307502','Lavras da Mangabeira','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(993,'2307601','Limoeiro do Norte','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(994,'2307635','Madalena','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(995,'2307650','Maracanaú','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(996,'2307700','Maranguape','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(997,'2307809','Marco','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(998,'2307908','Martinópole','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(999,'2308005','Massapê','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1000,'2308104','Mauriti','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1001,'2308203','Meruoca','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1002,'2308302','Milagres','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1003,'2308351','Milhã','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1004,'2308377','Miraíma','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1005,'2308401','Missão Velha','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1006,'2308500','Mombaça','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1007,'2308609','Monsenhor Tabosa','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1008,'2308708','Morada Nova','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1009,'2308807','Moraújo','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1010,'2308906','Morrinhos','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1011,'2309003','Mucambo','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1012,'2309102','Mulungu','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1013,'2309201','Nova Olinda','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1014,'2309300','Nova Russas','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1015,'2309409','Novo Oriente','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1016,'2309458','Ocara','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1017,'2309508','Orós','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1018,'2309607','Pacajus','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1019,'2309706','Pacatuba','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1020,'2309805','Pacoti','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1021,'2309904','Pacujá','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1022,'2310001','Palhano','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1023,'2310100','Palmácia','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1024,'2310209','Paracuru','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1025,'2310258','Paraipaba','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1026,'2310308','Parambu','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1027,'2310407','Paramoti','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1028,'2310506','Pedra Branca','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1029,'2310605','Penaforte','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1030,'2310704','Pentecoste','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1031,'2310803','Pereiro','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1032,'2310852','Pindoretama','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1033,'2310902','Piquet Carneiro','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1034,'2310951','Pires Ferreira','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1035,'2311009','Poranga','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1036,'2311108','Porteiras','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1037,'2311207','Potengi','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1038,'2311231','Potiretama','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1039,'2311264','Quiterianópolis','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1040,'2311306','Quixadá','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1041,'2311355','Quixelô','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1042,'2311405','Quixeramobim','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1043,'2311504','Quixeré','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1044,'2311603','Redenção','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1045,'2311702','Reriutaba','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1046,'2311801','Russas','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1047,'2311900','Saboeiro','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1048,'2311959','Salitre','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1049,'2312007','Santana do Acaraú','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1050,'2312106','Santana do Cariri','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1051,'2312205','Santa Quitéria','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1052,'2312304','São Benedito','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1053,'2312403','São Gonçalo do Amarante','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1054,'2312502','São João do Jaguaribe','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1055,'2312601','São Luís do Curu','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1056,'2312700','Senador Pompeu','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1057,'2312809','Senador Sá','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1058,'2312908','Sobral','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1059,'2313005','Solonópole','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1060,'2313104','Tabuleiro do Norte','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1061,'2313203','Tamboril','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1062,'2313252','Tarrafas','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1063,'2313302','Tauá','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1064,'2313351','Tejuçuoca','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1065,'2313401','Tianguá','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1066,'2313500','Trairi','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1067,'2313559','Tururu','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1068,'2313609','Ubajara','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1069,'2313708','Umari','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1070,'2313757','Umirim','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1071,'2313807','Uruburetama','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1072,'2313906','Uruoca','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1073,'2313955','Varjota','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1074,'2314003','Várzea Alegre','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1075,'2314102','Viçosa do Ceará','CE','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1076,'2400109','Acari','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1077,'2400208','Açu','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1078,'2400307','Afonso Bezerra','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1079,'2400406','Água Nova','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1080,'2400505','Alexandria','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1081,'2400604','Almino Afonso','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1082,'2400703','Alto do Rodrigues','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1083,'2400802','Angicos','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1084,'2400901','Antônio Martins','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1085,'2401008','Apodi','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1086,'2401107','Areia Branca','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1087,'2401206','Arês','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1088,'2401305','Augusto Severo','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1089,'2401404','Baía Formosa','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1090,'2401453','Baraúna','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1091,'2401503','Barcelona','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1092,'2401602','Bento Fernandes','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1093,'2401651','Bodó','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1094,'2401701','Bom Jesus','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1095,'2401800','Brejinho','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1096,'2401859','Caiçara do Norte','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1097,'2401909','Caiçara do Rio do Vento','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1098,'2402006','Caicó','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1099,'2402105','Campo Redondo','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1100,'2402204','Canguaretama','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1101,'2402303','Caraúbas','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1102,'2402402','Carnaúba dos Dantas','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1103,'2402501','Carnaubais','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1104,'2402600','Ceará-Mirim','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1105,'2402709','Cerro Corá','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1106,'2402808','Coronel Ezequiel','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1107,'2402907','Coronel João Pessoa','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1108,'2403004','Cruzeta','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1109,'2403103','Currais Novos','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1110,'2403202','Doutor Severiano','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1111,'2403251','Parnamirim','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1112,'2403301','Encanto','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1113,'2403400','Equador','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1114,'2403509','Espírito Santo','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1115,'2403608','Extremoz','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1116,'2403707','Felipe Guerra','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1117,'2403756','Fernando Pedroza','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1118,'2403806','Florânia','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1119,'2403905','Francisco Dantas','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1120,'2404002','Frutuoso Gomes','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1121,'2404101','Galinhos','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1122,'2404200','Goianinha','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1123,'2404309','Governador Dix-Sept Rosado','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1124,'2404408','Grossos','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1125,'2404507','Guamaré','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1126,'2404606','Ielmo Marinho','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1127,'2404705','Ipanguaçu','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1128,'2404804','Ipueira','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1129,'2404853','Itajá','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1130,'2404903','Itaú','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1131,'2405009','Jaçanã','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1132,'2405108','Jandaíra','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1133,'2405207','Janduís','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1134,'2405306','Januário Cicco','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1135,'2405405','Japi','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1136,'2405504','Jardim de Angicos','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1137,'2405603','Jardim de Piranhas','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1138,'2405702','Jardim do Seridó','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1139,'2405801','João Câmara','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1140,'2405900','João Dias','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1141,'2406007','José da Penha','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1142,'2406106','Jucurutu','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1143,'2406155','Jundiá','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1144,'2406205','Lagoa D\'Anta','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1145,'2406304','Lagoa de Pedras','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1146,'2406403','Lagoa de Velhos','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1147,'2406502','Lagoa Nova','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1148,'2406601','Lagoa Salgada','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1149,'2406700','Lajes','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1150,'2406809','Lajes Pintadas','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1151,'2406908','Lucrécia','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1152,'2407005','Luís Gomes','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1153,'2407104','Macaíba','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1154,'2407203','Macau','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1155,'2407252','Major Sales','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1156,'2407302','Marcelino Vieira','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1157,'2407401','Martins','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1158,'2407500','Maxaranguape','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1159,'2407609','Messias Targino','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1160,'2407708','Montanhas','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1161,'2407807','Monte Alegre','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1162,'2407906','Monte das Gameleiras','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1163,'2408003','Mossoró','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1164,'2408102','Natal','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1165,'2408201','Nísia Floresta','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1166,'2408300','Nova Cruz','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1167,'2408409','Olho-D\'Água do Borges','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1168,'2408508','Ouro Branco','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1169,'2408607','Paraná','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1170,'2408706','Paraú','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1171,'2408805','Parazinho','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1172,'2408904','Parelhas','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1173,'2408953','Rio do Fogo','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1174,'2409100','Passa e Fica','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1175,'2409209','Passagem','RN','2020-11-24 14:29:05','2020-11-24 14:29:05'),(1176,'2409308','Patu','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1177,'2409332','Santa Maria','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1178,'2409407','Pau dos Ferros','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1179,'2409506','Pedra Grande','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1180,'2409605','Pedra Preta','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1181,'2409704','Pedro Avelino','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1182,'2409803','Pedro Velho','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1183,'2409902','Pendências','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1184,'2410009','Pilões','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1185,'2410108','Poço Branco','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1186,'2410207','Portalegre','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1187,'2410256','Porto do Mangue','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1188,'2410306','Presidente Juscelino','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1189,'2410405','Pureza','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1190,'2410504','Rafael Fernandes','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1191,'2410603','Rafael Godeiro','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1192,'2410702','Riacho da Cruz','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1193,'2410801','Riacho de Santana','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1194,'2410900','Riachuelo','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1195,'2411007','Rodolfo Fernandes','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1196,'2411056','Tibau','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1197,'2411106','Ruy Barbosa','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1198,'2411205','Santa Cruz','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1199,'2411403','Santana do Matos','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1200,'2411429','Santana do Seridó','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1201,'2411502','Santo Antônio','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1202,'2411601','São Bento do Norte','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1203,'2411700','São Bento do Trairí','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1204,'2411809','São Fernando','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1205,'2411908','São Francisco do Oeste','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1206,'2412005','São Gonçalo do Amarante','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1207,'2412104','São João do Sabugi','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1208,'2412203','São José de Mipibu','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1209,'2412302','São José do Campestre','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1210,'2412401','São José do Seridó','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1211,'2412500','São Miguel','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1212,'2412559','São Miguel do Gostoso','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1213,'2412609','São Paulo do Potengi','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1214,'2412708','São Pedro','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1215,'2412807','São Rafael','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1216,'2412906','São Tomé','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1217,'2413003','São Vicente','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1218,'2413102','Senador Elói de Souza','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1219,'2413201','Senador Georgino Avelino','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1220,'2413300','Serra de São Bento','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1221,'2413359','Serra do Mel','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1222,'2413409','Serra Negra do Norte','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1223,'2413508','Serrinha','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1224,'2413557','Serrinha dos Pintos','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1225,'2413607','Severiano Melo','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1226,'2413706','Sítio Novo','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1227,'2413805','Taboleiro Grande','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1228,'2413904','Taipu','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1229,'2414001','Tangará','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1230,'2414100','Tenente Ananias','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1231,'2414159','Tenente Laurentino Cruz','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1232,'2414209','Tibau do Sul','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1233,'2414308','Timbaúba dos Batistas','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1234,'2414407','Touros','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1235,'2414456','Triunfo Potiguar','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1236,'2414506','Umarizal','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1237,'2414605','Upanema','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1238,'2414704','Várzea','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1239,'2414753','Venha-Ver','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1240,'2414803','Vera Cruz','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1241,'2414902','Viçosa','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1242,'2415008','Vila Flor','RN','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1243,'2500106','Água Branca','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1244,'2500205','Aguiar','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1245,'2500304','Alagoa Grande','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1246,'2500403','Alagoa Nova','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1247,'2500502','Alagoinha','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1248,'2500536','Alcantil','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1249,'2500577','Algodão de Jandaíra','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1250,'2500601','Alhandra','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1251,'2500700','São João do Rio do Peixe','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1252,'2500734','Amparo','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1253,'2500775','Aparecida','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1254,'2500809','Araçagi','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1255,'2500908','Arara','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1256,'2501005','Araruna','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1257,'2501104','Areia','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1258,'2501153','Areia de Baraúnas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1259,'2501203','Areial','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1260,'2501302','Aroeiras','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1261,'2501351','Assunção','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1262,'2501401','Baía da Traição','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1263,'2501500','Bananeiras','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1264,'2501534','Baraúna','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1265,'2501575','Barra de Santana','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1266,'2501609','Barra de Santa Rosa','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1267,'2501708','Barra de São Miguel','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1268,'2501807','Bayeux','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1269,'2501906','Belém','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1270,'2502003','Belém do Brejo do Cruz','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1271,'2502052','Bernardino Batista','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1272,'2502102','Boa Ventura','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1273,'2502151','Boa Vista','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1274,'2502201','Bom Jesus','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1275,'2502300','Bom Sucesso','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1276,'2502409','Bonito de Santa Fé','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1277,'2502508','Boqueirão','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1278,'2502607','Igaracy','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1279,'2502706','Borborema','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1280,'2502805','Brejo do Cruz','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1281,'2502904','Brejo dos Santos','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1282,'2503001','Caaporã','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1283,'2503100','Cabaceiras','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1284,'2503209','Cabedelo','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1285,'2503308','Cachoeira dos Índios','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1286,'2503407','Cacimba de Areia','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1287,'2503506','Cacimba de Dentro','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1288,'2503555','Cacimbas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1289,'2503605','Caiçara','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1290,'2503704','Cajazeiras','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1291,'2503753','Cajazeirinhas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1292,'2503803','Caldas Brandão','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1293,'2503902','Camalaú','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1294,'2504009','Campina Grande','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1295,'2504033','Capim','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1296,'2504074','Caraúbas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1297,'2504108','Carrapateira','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1298,'2504157','Casserengue','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1299,'2504207','Catingueira','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1300,'2504306','Catolé do Rocha','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1301,'2504355','Caturité','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1302,'2504405','Conceição','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1303,'2504504','Condado','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1304,'2504603','Conde','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1305,'2504702','Congo','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1306,'2504801','Coremas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1307,'2504850','Coxixola','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1308,'2504900','Cruz do Espírito Santo','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1309,'2505006','Cubati','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1310,'2505105','Cuité','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1311,'2505204','Cuitegi','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1312,'2505238','Cuité de Mamanguape','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1313,'2505279','Curral de Cima','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1314,'2505303','Curral Velho','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1315,'2505352','Damião','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1316,'2505402','Desterro','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1317,'2505501','Vista Serrana','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1318,'2505600','Diamante','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1319,'2505709','Dona Inês','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1320,'2505808','Duas Estradas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1321,'2505907','Emas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1322,'2506004','Esperança','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1323,'2506103','Fagundes','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1324,'2506202','Frei Martinho','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1325,'2506251','Gado Bravo','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1326,'2506301','Guarabira','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1327,'2506400','Gurinhém','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1328,'2506509','Gurjão','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1329,'2506608','Ibiara','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1330,'2506707','Imaculada','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1331,'2506806','Ingá','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1332,'2506905','Itabaiana','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1333,'2507002','Itaporanga','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1334,'2507101','Itapororoca','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1335,'2507200','Itatuba','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1336,'2507309','Jacaraú','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1337,'2507408','Jericó','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1338,'2507507','João Pessoa','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1339,'2507606','Juarez Távora','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1340,'2507705','Juazeirinho','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1341,'2507804','Junco do Seridó','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1342,'2507903','Juripiranga','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1343,'2508000','Juru','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1344,'2508109','Lagoa','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1345,'2508208','Lagoa de Dentro','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1346,'2508307','Lagoa Seca','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1347,'2508406','Lastro','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1348,'2508505','Livramento','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1349,'2508554','Logradouro','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1350,'2508604','Lucena','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1351,'2508703','Mãe D\'Água','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1352,'2508802','Malta','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1353,'2508901','Mamanguape','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1354,'2509008','Manaíra','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1355,'2509057','Marcação','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1356,'2509107','Mari','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1357,'2509156','Marizópolis','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1358,'2509206','Massaranduba','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1359,'2509305','Mataraca','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1360,'2509339','Matinhas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1361,'2509370','Mato Grosso','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1362,'2509396','Maturéia','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1363,'2509404','Mogeiro','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1364,'2509503','Montadas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1365,'2509602','Monte Horebe','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1366,'2509701','Monteiro','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1367,'2509800','Mulungu','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1368,'2509909','Natuba','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1369,'2510006','Nazarezinho','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1370,'2510105','Nova Floresta','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1371,'2510204','Nova Olinda','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1372,'2510303','Nova Palmeira','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1373,'2510402','Olho D\'Água','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1374,'2510501','Olivedos','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1375,'2510600','Ouro Velho','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1376,'2510659','Parari','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1377,'2510709','Passagem','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1378,'2510808','Patos','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1379,'2510907','Paulista','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1380,'2511004','Pedra Branca','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1381,'2511103','Pedra Lavrada','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1382,'2511202','Pedras de Fogo','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1383,'2511301','Piancó','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1384,'2511400','Picuí','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1385,'2511509','Pilar','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1386,'2511608','Pilões','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1387,'2511707','Pilõezinhos','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1388,'2511806','Pirpirituba','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1389,'2511905','Pitimbu','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1390,'2512002','Pocinhos','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1391,'2512036','Poço Dantas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1392,'2512077','Poço de José de Moura','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1393,'2512101','Pombal','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1394,'2512200','Prata','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1395,'2512309','Princesa Isabel','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1396,'2512408','Puxinanã','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1397,'2512507','Queimadas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1398,'2512606','Quixabá','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1399,'2512705','Remígio','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1400,'2512721','Pedro Régis','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1401,'2512747','Riachão','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1402,'2512754','Riachão do Bacamarte','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1403,'2512762','Riachão do Poço','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1404,'2512788','Riacho de Santo Antônio','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1405,'2512804','Riacho dos Cavalos','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1406,'2512903','Rio Tinto','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1407,'2513000','Salgadinho','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1408,'2513109','Salgado de São Félix','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1409,'2513158','Santa Cecília','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1410,'2513208','Santa Cruz','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1411,'2513307','Santa Helena','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1412,'2513356','Santa Inês','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1413,'2513406','Santa Luzia','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1414,'2513505','Santana de Mangueira','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1415,'2513604','Santana dos Garrotes','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1416,'2513653','Joca Claudino','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1417,'2513703','Santa Rita','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1418,'2513802','Santa Teresinha','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1419,'2513851','Santo André','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1420,'2513901','São Bento','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1421,'2513927','São Bentinho','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1422,'2513943','São Domingos do Cariri','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1423,'2513968','São Domingos','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1424,'2513984','São Francisco','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1425,'2514008','São João do Cariri','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1426,'2514107','São João do Tigre','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1427,'2514206','São José da Lagoa Tapada','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1428,'2514305','São José de Caiana','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1429,'2514404','São José de Espinharas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1430,'2514453','São José dos Ramos','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1431,'2514503','São José de Piranhas','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1432,'2514552','São José de Princesa','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1433,'2514602','São José do Bonfim','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1434,'2514651','São José do Brejo do Cruz','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1435,'2514701','São José do Sabugi','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1436,'2514800','São José dos Cordeiros','PB','2020-11-24 14:29:06','2020-11-24 14:29:06'),(1437,'2514909','São Mamede','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1438,'2515005','São Miguel de Taipu','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1439,'2515104','São Sebastião de Lagoa de Roça','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1440,'2515203','São Sebastião do Umbuzeiro','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1441,'2515302','Sapé','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1442,'2515401','São Vicente do Seridó','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1443,'2515500','Serra Branca','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1444,'2515609','Serra da Raiz','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1445,'2515708','Serra Grande','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1446,'2515807','Serra Redonda','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1447,'2515906','Serraria','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1448,'2515930','Sertãozinho','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1449,'2515971','Sobrado','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1450,'2516003','Solânea','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1451,'2516102','Soledade','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1452,'2516151','Sossêgo','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1453,'2516201','Sousa','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1454,'2516300','Sumé','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1455,'2516409','Tacima','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1456,'2516508','Taperoá','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1457,'2516607','Tavares','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1458,'2516706','Teixeira','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1459,'2516755','Tenório','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1460,'2516805','Triunfo','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1461,'2516904','Uiraúna','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1462,'2517001','Umbuzeiro','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1463,'2517100','Várzea','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1464,'2517209','Vieirópolis','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1465,'2517407','Zabelê','PB','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1466,'2600054','Abreu e Lima','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1467,'2600104','Afogados da Ingazeira','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1468,'2600203','Afrânio','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1469,'2600302','Agrestina','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1470,'2600401','Água Preta','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1471,'2600500','Águas Belas','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1472,'2600609','Alagoinha','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1473,'2600708','Aliança','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1474,'2600807','Altinho','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1475,'2600906','Amaraji','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1476,'2601003','Angelim','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1477,'2601052','Araçoiaba','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1478,'2601102','Araripina','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1479,'2601201','Arcoverde','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1480,'2601300','Barra de Guabiraba','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1481,'2601409','Barreiros','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1482,'2601508','Belém de Maria','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1483,'2601607','Belém do São Francisco','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1484,'2601706','Belo Jardim','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1485,'2601805','Betânia','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1486,'2601904','Bezerros','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1487,'2602001','Bodocó','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1488,'2602100','Bom Conselho','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1489,'2602209','Bom Jardim','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1490,'2602308','Bonito','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1491,'2602407','Brejão','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1492,'2602506','Brejinho','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1493,'2602605','Brejo da Madre de Deus','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1494,'2602704','Buenos Aires','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1495,'2602803','Buíque','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1496,'2602902','Cabo de Santo Agostinho','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1497,'2603009','Cabrobó','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1498,'2603108','Cachoeirinha','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1499,'2603207','Caetés','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1500,'2603306','Calçado','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1501,'2603405','Calumbi','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1502,'2603454','Camaragibe','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1503,'2603504','Camocim de São Félix','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1504,'2603603','Camutanga','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1505,'2603702','Canhotinho','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1506,'2603801','Capoeiras','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1507,'2603900','Carnaíba','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1508,'2603926','Carnaubeira da Penha','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1509,'2604007','Carpina','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1510,'2604106','Caruaru','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1511,'2604155','Casinhas','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1512,'2604205','Catende','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1513,'2604304','Cedro','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1514,'2604403','Chã de Alegria','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1515,'2604502','Chã Grande','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1516,'2604601','Condado','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1517,'2604700','Correntes','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1518,'2604809','Cortês','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1519,'2604908','Cumaru','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1520,'2605004','Cupira','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1521,'2605103','Custódia','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1522,'2605152','Dormentes','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1523,'2605202','Escada','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1524,'2605301','Exu','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1525,'2605400','Feira Nova','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1526,'2605459','Fernando de Noronha','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1527,'2605509','Ferreiros','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1528,'2605608','Flores','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1529,'2605707','Floresta','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1530,'2605806','Frei Miguelinho','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1531,'2605905','Gameleira','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1532,'2606002','Garanhuns','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1533,'2606101','Glória do Goitá','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1534,'2606200','Goiana','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1535,'2606309','Granito','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1536,'2606408','Gravatá','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1537,'2606507','Iati','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1538,'2606606','Ibimirim','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1539,'2606705','Ibirajuba','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1540,'2606804','Igarassu','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1541,'2606903','Iguaraci','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1542,'2607000','Inajá','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1543,'2607109','Ingazeira','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1544,'2607208','Ipojuca','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1545,'2607307','Ipubi','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1546,'2607406','Itacuruba','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1547,'2607505','Itaíba','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1548,'2607604','Ilha de Itamaracá','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1549,'2607653','Itambé','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1550,'2607703','Itapetim','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1551,'2607752','Itapissuma','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1552,'2607802','Itaquitinga','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1553,'2607901','Jaboatão dos Guararapes','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1554,'2607950','Jaqueira','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1555,'2608008','Jataúba','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1556,'2608057','Jatobá','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1557,'2608107','João Alfredo','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1558,'2608206','Joaquim Nabuco','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1559,'2608255','Jucati','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1560,'2608305','Jupi','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1561,'2608404','Jurema','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1562,'2608453','Lagoa do Carro','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1563,'2608503','Lagoa de Itaenga','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1564,'2608602','Lagoa do Ouro','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1565,'2608701','Lagoa dos Gatos','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1566,'2608750','Lagoa Grande','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1567,'2608800','Lajedo','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1568,'2608909','Limoeiro','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1569,'2609006','Macaparana','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1570,'2609105','Machados','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1571,'2609154','Manari','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1572,'2609204','Maraial','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1573,'2609303','Mirandiba','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1574,'2609402','Moreno','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1575,'2609501','Nazaré da Mata','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1576,'2609600','Olinda','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1577,'2609709','Orobó','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1578,'2609808','Orocó','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1579,'2609907','Ouricuri','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1580,'2610004','Palmares','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1581,'2610103','Palmeirina','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1582,'2610202','Panelas','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1583,'2610301','Paranatama','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1584,'2610400','Parnamirim','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1585,'2610509','Passira','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1586,'2610608','Paudalho','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1587,'2610707','Paulista','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1588,'2610806','Pedra','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1589,'2610905','Pesqueira','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1590,'2611002','Petrolândia','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1591,'2611101','Petrolina','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1592,'2611200','Poção','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1593,'2611309','Pombos','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1594,'2611408','Primavera','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1595,'2611507','Quipapá','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1596,'2611533','Quixaba','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1597,'2611606','Recife','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1598,'2611705','Riacho das Almas','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1599,'2611804','Ribeirão','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1600,'2611903','Rio Formoso','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1601,'2612000','Sairé','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1602,'2612109','Salgadinho','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1603,'2612208','Salgueiro','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1604,'2612307','Saloá','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1605,'2612406','Sanharó','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1606,'2612455','Santa Cruz','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1607,'2612471','Santa Cruz da Baixa Verde','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1608,'2612505','Santa Cruz do Capibaribe','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1609,'2612554','Santa Filomena','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1610,'2612604','Santa Maria da Boa Vista','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1611,'2612703','Santa Maria do Cambucá','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1612,'2612802','Santa Terezinha','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1613,'2612901','São Benedito do Sul','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1614,'2613008','São Bento do Una','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1615,'2613107','São Caitano','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1616,'2613206','São João','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1617,'2613305','São Joaquim do Monte','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1618,'2613404','São José da Coroa Grande','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1619,'2613503','São José do Belmonte','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1620,'2613602','São José do Egito','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1621,'2613701','São Lourenço da Mata','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1622,'2613800','São Vicente Ferrer','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1623,'2613909','Serra Talhada','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1624,'2614006','Serrita','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1625,'2614105','Sertânia','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1626,'2614204','Sirinhaém','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1627,'2614303','Moreilândia','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1628,'2614402','Solidão','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1629,'2614501','Surubim','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1630,'2614600','Tabira','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1631,'2614709','Tacaimbó','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1632,'2614808','Tacaratu','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1633,'2614857','Tamandaré','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1634,'2615003','Taquaritinga do Norte','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1635,'2615102','Terezinha','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1636,'2615201','Terra Nova','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1637,'2615300','Timbaúba','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1638,'2615409','Toritama','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1639,'2615508','Tracunhaém','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1640,'2615607','Trindade','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1641,'2615706','Triunfo','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1642,'2615805','Tupanatinga','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1643,'2615904','Tuparetama','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1644,'2616001','Venturosa','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1645,'2616100','Verdejante','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1646,'2616183','Vertente do Lério','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1647,'2616209','Vertentes','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1648,'2616308','Vicência','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1649,'2616407','Vitória de Santo Antão','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1650,'2616506','Xexéu','PE','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1651,'2700102','Água Branca','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1652,'2700201','Anadia','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1653,'2700300','Arapiraca','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1654,'2700409','Atalaia','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1655,'2700508','Barra de Santo Antônio','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1656,'2700607','Barra de São Miguel','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1657,'2700706','Batalha','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1658,'2700805','Belém','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1659,'2700904','Belo Monte','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1660,'2701001','Boca da Mata','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1661,'2701100','Branquinha','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1662,'2701209','Cacimbinhas','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1663,'2701308','Cajueiro','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1664,'2701357','Campestre','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1665,'2701407','Campo Alegre','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1666,'2701506','Campo Grande','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1667,'2701605','Canapi','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1668,'2701704','Capela','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1669,'2701803','Carneiros','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1670,'2701902','Chã Preta','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1671,'2702009','Coité do Nóia','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1672,'2702108','Colônia Leopoldina','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1673,'2702207','Coqueiro Seco','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1674,'2702306','Coruripe','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1675,'2702355','Craíbas','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1676,'2702405','Delmiro Gouveia','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1677,'2702504','Dois Riachos','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1678,'2702553','Estrela de Alagoas','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1679,'2702603','Feira Grande','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1680,'2702702','Feliz Deserto','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1681,'2702801','Flexeiras','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1682,'2702900','Girau do Ponciano','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1683,'2703007','Ibateguara','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1684,'2703106','Igaci','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1685,'2703205','Igreja Nova','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1686,'2703304','Inhapi','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1687,'2703403','Jacaré dos Homens','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1688,'2703502','Jacuípe','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1689,'2703601','Japaratinga','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1690,'2703700','Jaramataia','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1691,'2703759','Jequiá da Praia','AL','2020-11-24 14:29:07','2020-11-24 14:29:07'),(1692,'2703809','Joaquim Gomes','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1693,'2703908','Jundiá','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1694,'2704005','Junqueiro','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1695,'2704104','Lagoa da Canoa','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1696,'2704203','Limoeiro de Anadia','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1697,'2704302','Maceió','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1698,'2704401','Major Isidoro','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1699,'2704500','Maragogi','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1700,'2704609','Maravilha','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1701,'2704708','Marechal Deodoro','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1702,'2704807','Maribondo','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1703,'2704906','Mar Vermelho','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1704,'2705002','Mata Grande','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1705,'2705101','Matriz de Camaragibe','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1706,'2705200','Messias','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1707,'2705309','Minador do Negrão','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1708,'2705408','Monteirópolis','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1709,'2705507','Murici','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1710,'2705606','Novo Lino','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1711,'2705705','Olho D\'Água das Flores','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1712,'2705804','Olho D\'Água do Casado','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1713,'2705903','Olho D\'Água Grande','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1714,'2706000','Olivença','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1715,'2706109','Ouro Branco','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1716,'2706208','Palestina','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1717,'2706307','Palmeira dos Índios','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1718,'2706406','Pão de Açúcar','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1719,'2706422','Pariconha','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1720,'2706448','Paripueira','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1721,'2706505','Passo de Camaragibe','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1722,'2706604','Paulo Jacinto','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1723,'2706703','Penedo','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1724,'2706802','Piaçabuçu','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1725,'2706901','Pilar','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1726,'2707008','Pindoba','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1727,'2707107','Piranhas','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1728,'2707206','Poço das Trincheiras','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1729,'2707305','Porto Calvo','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1730,'2707404','Porto de Pedras','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1731,'2707503','Porto Real do Colégio','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1732,'2707602','Quebrangulo','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1733,'2707701','Rio Largo','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1734,'2707800','Roteiro','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1735,'2707909','Santa Luzia do Norte','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1736,'2708006','Santana do Ipanema','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1737,'2708105','Santana do Mundaú','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1738,'2708204','São Brás','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1739,'2708303','São José da Laje','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1740,'2708402','São José da Tapera','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1741,'2708501','São Luís do Quitunde','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1742,'2708600','São Miguel dos Campos','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1743,'2708709','São Miguel dos Milagres','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1744,'2708808','São Sebastião','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1745,'2708907','Satuba','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1746,'2708956','Senador Rui Palmeira','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1747,'2709004','Tanque D\'Arca','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1748,'2709103','Taquarana','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1749,'2709152','Teotônio Vilela','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1750,'2709202','Traipu','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1751,'2709301','União dos Palmares','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1752,'2709400','Viçosa','AL','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1753,'2800100','Amparo de São Francisco','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1754,'2800209','Aquidabã','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1755,'2800308','Aracaju','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1756,'2800407','Arauá','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1757,'2800506','Areia Branca','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1758,'2800605','Barra dos Coqueiros','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1759,'2800670','Boquim','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1760,'2800704','Brejo Grande','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1761,'2801009','Campo do Brito','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1762,'2801108','Canhoba','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1763,'2801207','Canindé de São Francisco','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1764,'2801306','Capela','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1765,'2801405','Carira','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1766,'2801504','Carmópolis','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1767,'2801603','Cedro de São João','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1768,'2801702','Cristinápolis','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1769,'2801900','Cumbe','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1770,'2802007','Divina Pastora','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1771,'2802106','Estância','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1772,'2802205','Feira Nova','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1773,'2802304','Frei Paulo','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1774,'2802403','Gararu','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1775,'2802502','General Maynard','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1776,'2802601','Gracho Cardoso','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1777,'2802700','Ilha das Flores','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1778,'2802809','Indiaroba','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1779,'2802908','Itabaiana','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1780,'2803005','Itabaianinha','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1781,'2803104','Itabi','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1782,'2803203','Itaporanga D\'Ajuda','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1783,'2803302','Japaratuba','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1784,'2803401','Japoatã','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1785,'2803500','Lagarto','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1786,'2803609','Laranjeiras','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1787,'2803708','Macambira','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1788,'2803807','Malhada dos Bois','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1789,'2803906','Malhador','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1790,'2804003','Maruim','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1791,'2804102','Moita Bonita','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1792,'2804201','Monte Alegre de Sergipe','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1793,'2804300','Muribeca','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1794,'2804409','Neópolis','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1795,'2804458','Nossa Senhora Aparecida','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1796,'2804508','Nossa Senhora da Glória','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1797,'2804607','Nossa Senhora das Dores','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1798,'2804706','Nossa Senhora de Lourdes','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1799,'2804805','Nossa Senhora do Socorro','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1800,'2804904','Pacatuba','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1801,'2805000','Pedra Mole','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1802,'2805109','Pedrinhas','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1803,'2805208','Pinhão','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1804,'2805307','Pirambu','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1805,'2805406','Poço Redondo','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1806,'2805505','Poço Verde','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1807,'2805604','Porto da Folha','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1808,'2805703','Propriá','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1809,'2805802','Riachão do Dantas','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1810,'2805901','Riachuelo','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1811,'2806008','Ribeirópolis','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1812,'2806107','Rosário do Catete','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1813,'2806206','Salgado','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1814,'2806305','Santa Luzia do Itanhy','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1815,'2806404','Santana do São Francisco','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1816,'2806503','Santa Rosa de Lima','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1817,'2806602','Santo Amaro das Brotas','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1818,'2806701','São Cristóvão','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1819,'2806800','São Domingos','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1820,'2806909','São Francisco','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1821,'2807006','São Miguel do Aleixo','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1822,'2807105','Simão Dias','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1823,'2807204','Siriri','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1824,'2807303','Telha','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1825,'2807402','Tobias Barreto','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1826,'2807501','Tomar do Geru','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1827,'2807600','Umbaúba','SE','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1828,'2900108','Abaíra','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1829,'2900207','Abaré','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1830,'2900306','Acajutiba','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1831,'2900355','Adustina','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1832,'2900405','Água Fria','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1833,'2900504','Érico Cardoso','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1834,'2900603','Aiquara','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1835,'2900702','Alagoinhas','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1836,'2900801','Alcobaça','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1837,'2900900','Almadina','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1838,'2901007','Amargosa','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1839,'2901106','Amélia Rodrigues','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1840,'2901155','América Dourada','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1841,'2901205','Anagé','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1842,'2901304','Andaraí','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1843,'2901353','Andorinha','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1844,'2901403','Angical','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1845,'2901502','Anguera','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1846,'2901601','Antas','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1847,'2901700','Antônio Cardoso','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1848,'2901809','Antônio Gonçalves','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1849,'2901908','Aporá','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1850,'2901957','Apuarema','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1851,'2902005','Aracatu','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1852,'2902054','Araças','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1853,'2902104','Araci','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1854,'2902203','Aramari','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1855,'2902252','Arataca','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1856,'2902302','Aratuípe','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1857,'2902401','Aurelino Leal','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1858,'2902500','Baianópolis','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1859,'2902609','Baixa Grande','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1860,'2902658','Banzaê','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1861,'2902708','Barra','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1862,'2902807','Barra da Estiva','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1863,'2902906','Barra do Choça','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1864,'2903003','Barra do Mendes','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1865,'2903102','Barra do Rocha','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1866,'2903201','Barreiras','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1867,'2903235','Barro Alto','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1868,'2903276','Barrocas','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1869,'2903300','Barro Preto','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1870,'2903409','Belmonte','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1871,'2903508','Belo Campo','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1872,'2903607','Biritinga','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1873,'2903706','Boa Nova','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1874,'2903805','Boa Vista do Tupim','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1875,'2903904','Bom Jesus da Lapa','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1876,'2903953','Bom Jesus da Serra','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1877,'2904001','Boninal','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1878,'2904050','Bonito','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1879,'2904100','Boquira','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1880,'2904209','Botuporã','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1881,'2904308','Brejões','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1882,'2904407','Brejolândia','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1883,'2904506','Brotas de Macaúbas','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1884,'2904605','Brumado','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1885,'2904704','Buerarema','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1886,'2904753','Buritirama','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1887,'2904803','Caatiba','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1888,'2904852','Cabaceiras do Paraguaçu','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1889,'2904902','Cachoeira','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1890,'2905008','Caculé','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1891,'2905107','Caém','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1892,'2905156','Caetanos','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1893,'2905206','Caetité','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1894,'2905305','Cafarnaum','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1895,'2905404','Cairu','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1896,'2905503','Caldeirão Grande','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1897,'2905602','Camacan','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1898,'2905701','Camaçari','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1899,'2905800','Camamu','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1900,'2905909','Campo Alegre de Lourdes','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1901,'2906006','Campo Formoso','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1902,'2906105','Canápolis','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1903,'2906204','Canarana','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1904,'2906303','Canavieiras','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1905,'2906402','Candeal','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1906,'2906501','Candeias','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1907,'2906600','Candiba','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1908,'2906709','Cândido Sales','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1909,'2906808','Cansanção','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1910,'2906824','Canudos','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1911,'2906857','Capela do Alto Alegre','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1912,'2906873','Capim Grosso','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1913,'2906899','Caraíbas','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1914,'2906907','Caravelas','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1915,'2907004','Cardeal da Silva','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1916,'2907103','Carinhanha','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1917,'2907202','Casa Nova','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1918,'2907301','Castro Alves','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1919,'2907400','Catolândia','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1920,'2907509','Catu','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1921,'2907558','Caturama','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1922,'2907608','Central','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1923,'2907707','Chorrochó','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1924,'2907806','Cícero Dantas','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1925,'2907905','Cipó','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1926,'2908002','Coaraci','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1927,'2908101','Cocos','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1928,'2908200','Conceição da Feira','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1929,'2908309','Conceição do Almeida','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1930,'2908408','Conceição do Coité','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1931,'2908507','Conceição do Jacuípe','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1932,'2908606','Conde','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1933,'2908705','Condeúba','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1934,'2908804','Contendas do Sincorá','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1935,'2908903','Coração de Maria','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1936,'2909000','Cordeiros','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1937,'2909109','Coribe','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1938,'2909208','Coronel João Sá','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1939,'2909307','Correntina','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1940,'2909406','Cotegipe','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1941,'2909505','Cravolândia','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1942,'2909604','Crisópolis','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1943,'2909703','Cristópolis','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1944,'2909802','Cruz das Almas','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1945,'2909901','Curaçá','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1946,'2910008','Dário Meira','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1947,'2910057','Dias D\'Ávila','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1948,'2910107','Dom Basílio','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1949,'2910206','Dom Macedo Costa','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1950,'2910305','Elísio Medrado','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1951,'2910404','Encruzilhada','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1952,'2910503','Entre Rios','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1953,'2910602','Esplanada','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1954,'2910701','Euclides da Cunha','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1955,'2910727','Eunápolis','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1956,'2910750','Fátima','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1957,'2910776','Feira da Mata','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1958,'2910800','Feira de Santana','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1959,'2910859','Filadélfia','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1960,'2910909','Firmino Alves','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1961,'2911006','Floresta Azul','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1962,'2911105','Formosa do Rio Preto','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1963,'2911204','Gandu','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1964,'2911253','Gavião','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1965,'2911303','Gentio do Ouro','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1966,'2911402','Glória','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1967,'2911501','Gongogi','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1968,'2911600','Governador Mangabeira','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1969,'2911659','Guajeru','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1970,'2911709','Guanambi','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1971,'2911808','Guaratinga','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1972,'2911857','Heliópolis','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1973,'2911907','Iaçu','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1974,'2912004','Ibiassucê','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1975,'2912103','Ibicaraí','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1976,'2912202','Ibicoara','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1977,'2912301','Ibicuí','BA','2020-11-24 14:29:08','2020-11-24 14:29:08'),(1978,'2912400','Ibipeba','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1979,'2912509','Ibipitanga','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1980,'2912608','Ibiquera','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1981,'2912707','Ibirapitanga','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1982,'2912806','Ibirapuã','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1983,'2912905','Ibirataia','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1984,'2913002','Ibitiara','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1985,'2913101','Ibititá','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1986,'2913200','Ibotirama','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1987,'2913309','Ichu','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1988,'2913408','Igaporã','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1989,'2913457','Igrapiúna','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1990,'2913507','Iguaí','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1991,'2913606','Ilhéus','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1992,'2913705','Inhambupe','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1993,'2913804','Ipecaetá','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1994,'2913903','Ipiaú','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1995,'2914000','Ipirá','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1996,'2914109','Ipupiara','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1997,'2914208','Irajuba','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1998,'2914307','Iramaia','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(1999,'2914406','Iraquara','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2000,'2914505','Irará','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2001,'2914604','Irecê','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2002,'2914653','Itabela','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2003,'2914703','Itaberaba','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2004,'2914802','Itabuna','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2005,'2914901','Itacaré','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2006,'2915007','Itaeté','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2007,'2915106','Itagi','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2008,'2915205','Itagibá','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2009,'2915304','Itagimirim','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2010,'2915353','Itaguaçu da Bahia','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2011,'2915403','Itaju do Colônia','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2012,'2915502','Itajuípe','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2013,'2915601','Itamaraju','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2014,'2915700','Itamari','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2015,'2915809','Itambé','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2016,'2915908','Itanagra','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2017,'2916005','Itanhém','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2018,'2916104','Itaparica','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2019,'2916203','Itapé','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2020,'2916302','Itapebi','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2021,'2916401','Itapetinga','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2022,'2916500','Itapicuru','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2023,'2916609','Itapitanga','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2024,'2916708','Itaquara','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2025,'2916807','Itarantim','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2026,'2916856','Itatim','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2027,'2916906','Itiruçu','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2028,'2917003','Itiúba','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2029,'2917102','Itororó','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2030,'2917201','Ituaçu','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2031,'2917300','Ituberá','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2032,'2917334','Iuiú','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2033,'2917359','Jaborandi','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2034,'2917409','Jacaraci','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2035,'2917508','Jacobina','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2036,'2917607','Jaguaquara','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2037,'2917706','Jaguarari','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2038,'2917805','Jaguaripe','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2039,'2917904','Jandaíra','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2040,'2918001','Jequié','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2041,'2918100','Jeremoabo','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2042,'2918209','Jiquiriçá','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2043,'2918308','Jitaúna','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2044,'2918357','João Dourado','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2045,'2918407','Juazeiro','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2046,'2918456','Jucuruçu','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2047,'2918506','Jussara','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2048,'2918555','Jussari','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2049,'2918605','Jussiape','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2050,'2918704','Lafaiete Coutinho','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2051,'2918753','Lagoa Real','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2052,'2918803','Laje','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2053,'2918902','Lajedão','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2054,'2919009','Lajedinho','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2055,'2919058','Lajedo do Tabocal','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2056,'2919108','Lamarão','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2057,'2919157','Lapão','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2058,'2919207','Lauro de Freitas','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2059,'2919306','Lençóis','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2060,'2919405','Licínio de Almeida','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2061,'2919504','Livramento de Nossa Senhora','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2062,'2919553','Luís Eduardo Magalhães','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2063,'2919603','Macajuba','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2064,'2919702','Macarani','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2065,'2919801','Macaúbas','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2066,'2919900','Macururé','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2067,'2919926','Madre de Deus','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2068,'2919959','Maetinga','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2069,'2920007','Maiquinique','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2070,'2920106','Mairi','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2071,'2920205','Malhada','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2072,'2920304','Malhada de Pedras','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2073,'2920403','Manoel Vitorino','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2074,'2920452','Mansidão','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2075,'2920502','Maracás','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2076,'2920601','Maragogipe','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2077,'2920700','Maraú','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2078,'2920809','Marcionílio Souza','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2079,'2920908','Mascote','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2080,'2921005','Mata de São João','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2081,'2921054','Matina','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2082,'2921104','Medeiros Neto','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2083,'2921203','Miguel Calmon','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2084,'2921302','Milagres','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2085,'2921401','Mirangaba','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2086,'2921450','Mirante','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2087,'2921500','Monte Santo','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2088,'2921609','Morpará','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2089,'2921708','Morro do Chapéu','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2090,'2921807','Mortugaba','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2091,'2921906','Mucugê','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2092,'2922003','Mucuri','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2093,'2922052','Mulungu do Morro','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2094,'2922102','Mundo Novo','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2095,'2922201','Muniz Ferreira','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2096,'2922250','Muquém de São Francisco','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2097,'2922300','Muritiba','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2098,'2922409','Mutuípe','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2099,'2922508','Nazaré','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2100,'2922607','Nilo Peçanha','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2101,'2922656','Nordestina','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2102,'2922706','Nova Canaã','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2103,'2922730','Nova Fátima','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2104,'2922755','Nova Ibiá','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2105,'2922805','Nova Itarana','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2106,'2922854','Nova Redenção','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2107,'2922904','Nova Soure','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2108,'2923001','Nova Viçosa','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2109,'2923035','Novo Horizonte','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2110,'2923050','Novo Triunfo','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2111,'2923100','Olindina','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2112,'2923209','Oliveira dos Brejinhos','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2113,'2923308','Ouriçangas','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2114,'2923357','Ourolândia','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2115,'2923407','Palmas de Monte Alto','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2116,'2923506','Palmeiras','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2117,'2923605','Paramirim','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2118,'2923704','Paratinga','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2119,'2923803','Paripiranga','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2120,'2923902','Pau Brasil','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2121,'2924009','Paulo Afonso','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2122,'2924058','Pé de Serra','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2123,'2924108','Pedrão','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2124,'2924207','Pedro Alexandre','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2125,'2924306','Piatã','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2126,'2924405','Pilão Arcado','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2127,'2924504','Pindaí','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2128,'2924603','Pindobaçu','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2129,'2924652','Pintadas','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2130,'2924678','Piraí do Norte','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2131,'2924702','Piripá','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2132,'2924801','Piritiba','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2133,'2924900','Planaltino','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2134,'2925006','Planalto','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2135,'2925105','Poções','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2136,'2925204','Pojuca','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2137,'2925253','Ponto Novo','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2138,'2925303','Porto Seguro','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2139,'2925402','Potiraguá','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2140,'2925501','Prado','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2141,'2925600','Presidente Dutra','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2142,'2925709','Presidente Jânio Quadros','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2143,'2925758','Presidente Tancredo Neves','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2144,'2925808','Queimadas','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2145,'2925907','Quijingue','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2146,'2925931','Quixabeira','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2147,'2925956','Rafael Jambeiro','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2148,'2926004','Remanso','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2149,'2926103','Retirolândia','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2150,'2926202','Riachão das Neves','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2151,'2926301','Riachão do Jacuípe','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2152,'2926400','Riacho de Santana','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2153,'2926509','Ribeira do Amparo','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2154,'2926608','Ribeira do Pombal','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2155,'2926657','Ribeirão do Largo','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2156,'2926707','Rio de Contas','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2157,'2926806','Rio do Antônio','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2158,'2926905','Rio do Pires','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2159,'2927002','Rio Real','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2160,'2927101','Rodelas','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2161,'2927200','Ruy Barbosa','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2162,'2927309','Salinas da Margarida','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2163,'2927408','Salvador','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2164,'2927507','Santa Bárbara','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2165,'2927606','Santa Brígida','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2166,'2927705','Santa Cruz Cabrália','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2167,'2927804','Santa Cruz da Vitória','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2168,'2927903','Santa Inês','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2169,'2928000','Santaluz','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2170,'2928059','Santa Luzia','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2171,'2928109','Santa Maria da Vitória','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2172,'2928208','Santana','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2173,'2928307','Santanópolis','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2174,'2928406','Santa Rita de Cássia','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2175,'2928505','Santa Teresinha','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2176,'2928604','Santo Amaro','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2177,'2928703','Santo Antônio de Jesus','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2178,'2928802','Santo Estêvão','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2179,'2928901','São Desidério','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2180,'2928950','São Domingos','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2181,'2929008','São Félix','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2182,'2929057','São Félix do Coribe','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2183,'2929107','São Felipe','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2184,'2929206','São Francisco do Conde','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2185,'2929255','São Gabriel','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2186,'2929305','São Gonçalo dos Campos','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2187,'2929354','São José da Vitória','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2188,'2929370','São José do Jacuípe','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2189,'2929404','São Miguel das Matas','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2190,'2929503','São Sebastião do Passé','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2191,'2929602','Sapeaçu','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2192,'2929701','Sátiro Dias','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2193,'2929750','Saubara','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2194,'2929800','Saúde','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2195,'2929909','Seabra','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2196,'2930006','Sebastião Laranjeiras','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2197,'2930105','Senhor do Bonfim','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2198,'2930154','Serra do Ramalho','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2199,'2930204','Sento Sé','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2200,'2930303','Serra Dourada','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2201,'2930402','Serra Preta','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2202,'2930501','Serrinha','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2203,'2930600','Serrolândia','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2204,'2930709','Simões Filho','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2205,'2930758','Sítio do Mato','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2206,'2930766','Sítio do Quinto','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2207,'2930774','Sobradinho','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2208,'2930808','Souto Soares','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2209,'2930907','Tabocas do Brejo Velho','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2210,'2931004','Tanhaçu','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2211,'2931053','Tanque Novo','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2212,'2931103','Tanquinho','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2213,'2931202','Taperoá','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2214,'2931301','Tapiramutá','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2215,'2931350','Teixeira de Freitas','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2216,'2931400','Teodoro Sampaio','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2217,'2931509','Teofilândia','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2218,'2931608','Teolândia','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2219,'2931707','Terra Nova','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2220,'2931806','Tremedal','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2221,'2931905','Tucano','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2222,'2932002','Uauá','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2223,'2932101','Ubaíra','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2224,'2932200','Ubaitaba','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2225,'2932309','Ubatã','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2226,'2932408','Uibaí','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2227,'2932457','Umburanas','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2228,'2932507','Una','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2229,'2932606','Urandi','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2230,'2932705','Uruçuca','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2231,'2932804','Utinga','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2232,'2932903','Valença','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2233,'2933000','Valente','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2234,'2933059','Várzea da Roça','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2235,'2933109','Várzea do Poço','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2236,'2933158','Várzea Nova','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2237,'2933174','Varzedo','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2238,'2933208','Vera Cruz','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2239,'2933257','Vereda','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2240,'2933307','Vitória da Conquista','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2241,'2933406','Wagner','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2242,'2933455','Wanderley','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2243,'2933505','Wenceslau Guimarães','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2244,'2933604','Xique-Xique','BA','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2245,'3100104','Abadia dos Dourados','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2246,'3100203','Abaeté','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2247,'3100302','Abre Campo','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2248,'3100401','Acaiaca','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2249,'3100500','Açucena','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2250,'3100609','Água Boa','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2251,'3100708','Água Comprida','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2252,'3100807','Aguanil','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2253,'3100906','Águas Formosas','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2254,'3101003','Águas Vermelhas','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2255,'3101102','Aimorés','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2256,'3101201','Aiuruoca','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2257,'3101300','Alagoa','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2258,'3101409','Albertina','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2259,'3101508','Além Paraíba','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2260,'3101607','Alfenas','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2261,'3101631','Alfredo Vasconcelos','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2262,'3101706','Almenara','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2263,'3101805','Alpercata','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2264,'3101904','Alpinópolis','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2265,'3102001','Alterosa','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2266,'3102050','Alto Caparaó','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2267,'3102100','Alto Rio Doce','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2268,'3102209','Alvarenga','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2269,'3102308','Alvinópolis','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2270,'3102407','Alvorada de Minas','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2271,'3102506','Amparo do Serra','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2272,'3102605','Andradas','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2273,'3102704','Cachoeira de Pajeú','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2274,'3102803','Andrelândia','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2275,'3102852','Angelândia','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2276,'3102902','Antônio Carlos','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2277,'3103009','Antônio Dias','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2278,'3103108','Antônio Prado de Minas','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2279,'3103207','Araçaí','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2280,'3103306','Aracitaba','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2281,'3103405','Araçuaí','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2282,'3103504','Araguari','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2283,'3103603','Arantina','MG','2020-11-24 14:29:09','2020-11-24 14:29:09'),(2284,'3103702','Araponga','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2285,'3103751','Araporã','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2286,'3103801','Arapuá','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2287,'3103900','Araújos','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2288,'3104007','Araxá','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2289,'3104106','Arceburgo','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2290,'3104205','Arcos','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2291,'3104304','Areado','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2292,'3104403','Argirita','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2293,'3104452','Aricanduva','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2294,'3104502','Arinos','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2295,'3104601','Astolfo Dutra','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2296,'3104700','Ataléia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2297,'3104809','Augusto de Lima','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2298,'3104908','Baependi','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2299,'3105004','Baldim','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2300,'3105103','Bambuí','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2301,'3105202','Bandeira','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2302,'3105301','Bandeira do Sul','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2303,'3105400','Barão de Cocais','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2304,'3105509','Barão de Monte Alto','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2305,'3105608','Barbacena','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2306,'3105707','Barra Longa','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2307,'3105905','Barroso','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2308,'3106002','Bela Vista de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2309,'3106101','Belmiro Braga','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2310,'3106200','Belo Horizonte','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2311,'3106309','Belo Oriente','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2312,'3106408','Belo Vale','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2313,'3106507','Berilo','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2314,'3106606','Bertópolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2315,'3106655','Berizal','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2316,'3106705','Betim','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2317,'3106804','Bias Fortes','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2318,'3106903','Bicas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2319,'3107000','Biquinhas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2320,'3107109','Boa Esperança','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2321,'3107208','Bocaina de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2322,'3107307','Bocaiúva','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2323,'3107406','Bom Despacho','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2324,'3107505','Bom Jardim de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2325,'3107604','Bom Jesus da Penha','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2326,'3107703','Bom Jesus do Amparo','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2327,'3107802','Bom Jesus do Galho','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2328,'3107901','Bom Repouso','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2329,'3108008','Bom Sucesso','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2330,'3108107','Bonfim','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2331,'3108206','Bonfinópolis de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2332,'3108255','Bonito de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2333,'3108305','Borda da Mata','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2334,'3108404','Botelhos','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2335,'3108503','Botumirim','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2336,'3108552','Brasilândia de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2337,'3108602','Brasília de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2338,'3108701','Brás Pires','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2339,'3108800','Braúnas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2340,'3108909','Brazópolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2341,'3109006','Brumadinho','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2342,'3109105','Bueno Brandão','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2343,'3109204','Buenópolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2344,'3109253','Bugre','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2345,'3109303','Buritis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2346,'3109402','Buritizeiro','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2347,'3109451','Cabeceira Grande','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2348,'3109501','Cabo Verde','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2349,'3109600','Cachoeira da Prata','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2350,'3109709','Cachoeira de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2351,'3109808','Cachoeira Dourada','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2352,'3109907','Caetanópolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2353,'3110004','Caeté','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2354,'3110103','Caiana','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2355,'3110202','Cajuri','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2356,'3110301','Caldas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2357,'3110400','Camacho','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2358,'3110509','Camanducaia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2359,'3110608','Cambuí','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2360,'3110707','Cambuquira','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2361,'3110806','Campanário','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2362,'3110905','Campanha','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2363,'3111002','Campestre','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2364,'3111101','Campina Verde','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2365,'3111150','Campo Azul','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2366,'3111200','Campo Belo','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2367,'3111309','Campo do Meio','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2368,'3111408','Campo Florido','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2369,'3111507','Campos Altos','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2370,'3111606','Campos Gerais','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2371,'3111705','Canaã','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2372,'3111804','Canápolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2373,'3111903','Cana Verde','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2374,'3112000','Candeias','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2375,'3112059','Cantagalo','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2376,'3112109','Caparaó','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2377,'3112208','Capela Nova','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2378,'3112307','Capelinha','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2379,'3112406','Capetinga','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2380,'3112505','Capim Branco','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2381,'3112604','Capinópolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2382,'3112653','Capitão Andrade','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2383,'3112703','Capitão Enéas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2384,'3112802','Capitólio','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2385,'3112901','Caputira','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2386,'3113008','Caraí','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2387,'3113107','Caranaíba','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2388,'3113206','Carandaí','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2389,'3113305','Carangola','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2390,'3113404','Caratinga','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2391,'3113503','Carbonita','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2392,'3113602','Careaçu','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2393,'3113701','Carlos Chagas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2394,'3113800','Carmésia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2395,'3113909','Carmo da Cachoeira','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2396,'3114006','Carmo da Mata','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2397,'3114105','Carmo de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2398,'3114204','Carmo do Cajuru','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2399,'3114303','Carmo do Paranaíba','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2400,'3114402','Carmo do Rio Claro','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2401,'3114501','Carmópolis de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2402,'3114550','Carneirinho','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2403,'3114600','Carrancas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2404,'3114709','Carvalhópolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2405,'3114808','Carvalhos','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2406,'3114907','Casa Grande','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2407,'3115003','Cascalho Rico','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2408,'3115102','Cássia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2409,'3115201','Conceição da Barra de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2410,'3115300','Cataguases','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2411,'3115359','Catas Altas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2412,'3115409','Catas Altas da Noruega','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2413,'3115458','Catuji','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2414,'3115474','Catuti','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2415,'3115508','Caxambu','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2416,'3115607','Cedro do Abaeté','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2417,'3115706','Central de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2418,'3115805','Centralina','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2419,'3115904','Chácara','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2420,'3116001','Chalé','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2421,'3116100','Chapada do Norte','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2422,'3116159','Chapada Gaúcha','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2423,'3116209','Chiador','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2424,'3116308','Cipotânea','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2425,'3116407','Claraval','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2426,'3116506','Claro dos Poções','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2427,'3116605','Cláudio','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2428,'3116704','Coimbra','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2429,'3116803','Coluna','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2430,'3116902','Comendador Gomes','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2431,'3117009','Comercinho','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2432,'3117108','Conceição da Aparecida','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2433,'3117207','Conceição das Pedras','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2434,'3117306','Conceição das Alagoas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2435,'3117405','Conceição de Ipanema','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2436,'3117504','Conceição do Mato Dentro','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2437,'3117603','Conceição do Pará','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2438,'3117702','Conceição do Rio Verde','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2439,'3117801','Conceição dos Ouros','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2440,'3117836','Cônego Marinho','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2441,'3117876','Confins','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2442,'3117900','Congonhal','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2443,'3118007','Congonhas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2444,'3118106','Congonhas do Norte','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2445,'3118205','Conquista','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2446,'3118304','Conselheiro Lafaiete','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2447,'3118403','Conselheiro Pena','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2448,'3118502','Consolação','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2449,'3118601','Contagem','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2450,'3118700','Coqueiral','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2451,'3118809','Coração de Jesus','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2452,'3118908','Cordisburgo','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2453,'3119005','Cordislândia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2454,'3119104','Corinto','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2455,'3119203','Coroaci','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2456,'3119302','Coromandel','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2457,'3119401','Coronel Fabriciano','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2458,'3119500','Coronel Murta','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2459,'3119609','Coronel Pacheco','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2460,'3119708','Coronel Xavier Chaves','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2461,'3119807','Córrego Danta','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2462,'3119906','Córrego do Bom Jesus','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2463,'3119955','Córrego Fundo','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2464,'3120003','Córrego Novo','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2465,'3120102','Couto de Magalhães de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2466,'3120151','Crisólita','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2467,'3120201','Cristais','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2468,'3120300','Cristália','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2469,'3120409','Cristiano Otoni','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2470,'3120508','Cristina','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2471,'3120607','Crucilândia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2472,'3120706','Cruzeiro da Fortaleza','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2473,'3120805','Cruzília','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2474,'3120839','Cuparaque','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2475,'3120870','Curral de Dentro','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2476,'3120904','Curvelo','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2477,'3121001','Datas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2478,'3121100','Delfim Moreira','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2479,'3121209','Delfinópolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2480,'3121258','Delta','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2481,'3121308','Descoberto','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2482,'3121407','Desterro de Entre Rios','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2483,'3121506','Desterro do Melo','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2484,'3121605','Diamantina','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2485,'3121704','Diogo de Vasconcelos','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2486,'3121803','Dionísio','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2487,'3121902','Divinésia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2488,'3122009','Divino','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2489,'3122108','Divino das Laranjeiras','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2490,'3122207','Divinolândia de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2491,'3122306','Divinópolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2492,'3122355','Divisa Alegre','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2493,'3122405','Divisa Nova','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2494,'3122454','Divisópolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2495,'3122470','Dom Bosco','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2496,'3122504','Dom Cavati','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2497,'3122603','Dom Joaquim','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2498,'3122702','Dom Silvério','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2499,'3122801','Dom Viçoso','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2500,'3122900','Dona Eusébia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2501,'3123007','Dores de Campos','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2502,'3123106','Dores de Guanhães','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2503,'3123205','Dores do Indaiá','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2504,'3123304','Dores do Turvo','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2505,'3123403','Doresópolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2506,'3123502','Douradoquara','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2507,'3123528','Durandé','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2508,'3123601','Elói Mendes','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2509,'3123700','Engenheiro Caldas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2510,'3123809','Engenheiro Navarro','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2511,'3123858','Entre Folhas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2512,'3123908','Entre Rios de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2513,'3124005','Ervália','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2514,'3124104','Esmeraldas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2515,'3124203','Espera Feliz','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2516,'3124302','Espinosa','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2517,'3124401','Espírito Santo do Dourado','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2518,'3124500','Estiva','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2519,'3124609','Estrela Dalva','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2520,'3124708','Estrela do Indaiá','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2521,'3124807','Estrela do Sul','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2522,'3124906','Eugenópolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2523,'3125002','Ewbank da Câmara','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2524,'3125101','Extrema','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2525,'3125200','Fama','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2526,'3125309','Faria Lemos','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2527,'3125408','Felício dos Santos','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2528,'3125507','São Gonçalo do Rio Preto','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2529,'3125606','Felisburgo','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2530,'3125705','Felixlândia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2531,'3125804','Fernandes Tourinho','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2532,'3125903','Ferros','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2533,'3125952','Fervedouro','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2534,'3126000','Florestal','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2535,'3126109','Formiga','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2536,'3126208','Formoso','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2537,'3126307','Fortaleza de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2538,'3126406','Fortuna de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2539,'3126505','Francisco Badaró','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2540,'3126604','Francisco Dumont','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2541,'3126703','Francisco Sá','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2542,'3126752','Franciscópolis','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2543,'3126802','Frei Gaspar','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2544,'3126901','Frei Inocêncio','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2545,'3126950','Frei Lagonegro','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2546,'3127008','Fronteira','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2547,'3127057','Fronteira dos Vales','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2548,'3127073','Fruta de Leite','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2549,'3127107','Frutal','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2550,'3127206','Funilândia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2551,'3127305','Galiléia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2552,'3127339','Gameleiras','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2553,'3127354','Glaucilândia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2554,'3127370','Goiabeira','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2555,'3127388','Goianá','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2556,'3127404','Gonçalves','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2557,'3127503','Gonzaga','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2558,'3127602','Gouveia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2559,'3127701','Governador Valadares','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2560,'3127800','Grão Mogol','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2561,'3127909','Grupiara','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2562,'3128006','Guanhães','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2563,'3128105','Guapé','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2564,'3128204','Guaraciaba','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2565,'3128253','Guaraciama','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2566,'3128303','Guaranésia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2567,'3128402','Guarani','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2568,'3128501','Guarará','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2569,'3128600','Guarda-Mor','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2570,'3128709','Guaxupé','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2571,'3128808','Guidoval','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2572,'3128907','Guimarânia','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2573,'3129004','Guiricema','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2574,'3129103','Gurinhatã','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2575,'3129202','Heliodora','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2576,'3129301','Iapu','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2577,'3129400','Ibertioga','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2578,'3129509','Ibiá','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2579,'3129608','Ibiaí','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2580,'3129657','Ibiracatu','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2581,'3129707','Ibiraci','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2582,'3129806','Ibirité','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2583,'3129905','Ibitiúra de Minas','MG','2020-11-24 14:29:10','2020-11-24 14:29:10'),(2584,'3130002','Ibituruna','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2585,'3130051','Icaraí de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2586,'3130101','Igarapé','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2587,'3130200','Igaratinga','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2588,'3130309','Iguatama','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2589,'3130408','Ijaci','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2590,'3130507','Ilicínea','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2591,'3130556','Imbé de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2592,'3130606','Inconfidentes','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2593,'3130655','Indaiabira','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2594,'3130705','Indianópolis','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2595,'3130804','Ingaí','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2596,'3130903','Inhapim','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2597,'3131000','Inhaúma','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2598,'3131109','Inimutaba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2599,'3131158','Ipaba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2600,'3131208','Ipanema','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2601,'3131307','Ipatinga','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2602,'3131406','Ipiaçu','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2603,'3131505','Ipuiúna','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2604,'3131604','Iraí de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2605,'3131703','Itabira','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2606,'3131802','Itabirinha','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2607,'3131901','Itabirito','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2608,'3132008','Itacambira','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2609,'3132107','Itacarambi','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2610,'3132206','Itaguara','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2611,'3132305','Itaipé','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2612,'3132404','Itajubá','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2613,'3132503','Itamarandiba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2614,'3132602','Itamarati de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2615,'3132701','Itambacuri','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2616,'3132800','Itambé do Mato Dentro','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2617,'3132909','Itamogi','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2618,'3133006','Itamonte','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2619,'3133105','Itanhandu','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2620,'3133204','Itanhomi','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2621,'3133303','Itaobim','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2622,'3133402','Itapagipe','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2623,'3133501','Itapecerica','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2624,'3133600','Itapeva','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2625,'3133709','Itatiaiuçu','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2626,'3133758','Itaú de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2627,'3133808','Itaúna','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2628,'3133907','Itaverava','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2629,'3134004','Itinga','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2630,'3134103','Itueta','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2631,'3134202','Ituiutaba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2632,'3134301','Itumirim','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2633,'3134400','Iturama','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2634,'3134509','Itutinga','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2635,'3134608','Jaboticatubas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2636,'3134707','Jacinto','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2637,'3134806','Jacuí','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2638,'3134905','Jacutinga','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2639,'3135001','Jaguaraçu','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2640,'3135050','Jaíba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2641,'3135076','Jampruca','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2642,'3135100','Janaúba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2643,'3135209','Januária','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2644,'3135308','Japaraíba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2645,'3135357','Japonvar','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2646,'3135407','Jeceaba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2647,'3135456','Jenipapo de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2648,'3135506','Jequeri','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2649,'3135605','Jequitaí','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2650,'3135704','Jequitibá','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2651,'3135803','Jequitinhonha','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2652,'3135902','Jesuânia','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2653,'3136009','Joaíma','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2654,'3136108','Joanésia','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2655,'3136207','João Monlevade','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2656,'3136306','João Pinheiro','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2657,'3136405','Joaquim Felício','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2658,'3136504','Jordânia','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2659,'3136520','José Gonçalves de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2660,'3136553','José Raydan','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2661,'3136579','Josenópolis','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2662,'3136603','Nova União','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2663,'3136652','Juatuba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2664,'3136702','Juiz de Fora','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2665,'3136801','Juramento','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2666,'3136900','Juruaia','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2667,'3136959','Juvenília','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2668,'3137007','Ladainha','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2669,'3137106','Lagamar','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2670,'3137205','Lagoa da Prata','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2671,'3137304','Lagoa dos Patos','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2672,'3137403','Lagoa Dourada','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2673,'3137502','Lagoa Formosa','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2674,'3137536','Lagoa Grande','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2675,'3137601','Lagoa Santa','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2676,'3137700','Lajinha','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2677,'3137809','Lambari','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2678,'3137908','Lamim','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2679,'3138005','Laranjal','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2680,'3138104','Lassance','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2681,'3138203','Lavras','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2682,'3138302','Leandro Ferreira','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2683,'3138351','Leme do Prado','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2684,'3138401','Leopoldina','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2685,'3138500','Liberdade','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2686,'3138609','Lima Duarte','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2687,'3138625','Limeira do Oeste','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2688,'3138658','Lontra','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2689,'3138674','Luisburgo','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2690,'3138682','Luislândia','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2691,'3138708','Luminárias','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2692,'3138807','Luz','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2693,'3138906','Machacalis','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2694,'3139003','Machado','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2695,'3139102','Madre de Deus de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2696,'3139201','Malacacheta','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2697,'3139250','Mamonas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2698,'3139300','Manga','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2699,'3139409','Manhuaçu','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2700,'3139508','Manhumirim','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2701,'3139607','Mantena','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2702,'3139706','Maravilhas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2703,'3139805','Mar de Espanha','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2704,'3139904','Maria da Fé','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2705,'3140001','Mariana','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2706,'3140100','Marilac','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2707,'3140159','Mário Campos','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2708,'3140209','Maripá de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2709,'3140308','Marliéria','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2710,'3140407','Marmelópolis','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2711,'3140506','Martinho Campos','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2712,'3140530','Martins Soares','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2713,'3140555','Mata Verde','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2714,'3140605','Materlândia','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2715,'3140704','Mateus Leme','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2716,'3140803','Matias Barbosa','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2717,'3140852','Matias Cardoso','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2718,'3140902','Matipó','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2719,'3141009','Mato Verde','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2720,'3141108','Matozinhos','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2721,'3141207','Matutina','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2722,'3141306','Medeiros','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2723,'3141405','Medina','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2724,'3141504','Mendes Pimentel','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2725,'3141603','Mercês','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2726,'3141702','Mesquita','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2727,'3141801','Minas Novas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2728,'3141900','Minduri','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2729,'3142007','Mirabela','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2730,'3142106','Miradouro','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2731,'3142205','Miraí','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2732,'3142254','Miravânia','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2733,'3142304','Moeda','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2734,'3142403','Moema','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2735,'3142502','Monjolos','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2736,'3142601','Monsenhor Paulo','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2737,'3142700','Montalvânia','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2738,'3142809','Monte Alegre de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2739,'3142908','Monte Azul','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2740,'3143005','Monte Belo','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2741,'3143104','Monte Carmelo','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2742,'3143153','Monte Formoso','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2743,'3143203','Monte Santo de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2744,'3143302','Montes Claros','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2745,'3143401','Monte Sião','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2746,'3143450','Montezuma','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2747,'3143500','Morada Nova de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2748,'3143609','Morro da Garça','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2749,'3143708','Morro do Pilar','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2750,'3143807','Munhoz','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2751,'3143906','Muriaé','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2752,'3144003','Mutum','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2753,'3144102','Muzambinho','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2754,'3144201','Nacip Raydan','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2755,'3144300','Nanuque','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2756,'3144359','Naque','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2757,'3144375','Natalândia','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2758,'3144409','Natércia','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2759,'3144508','Nazareno','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2760,'3144607','Nepomuceno','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2761,'3144656','Ninheira','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2762,'3144672','Nova Belém','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2763,'3144706','Nova Era','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2764,'3144805','Nova Lima','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2765,'3144904','Nova Módica','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2766,'3145000','Nova Ponte','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2767,'3145059','Nova Porteirinha','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2768,'3145109','Nova Resende','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2769,'3145208','Nova Serrana','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2770,'3145307','Novo Cruzeiro','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2771,'3145356','Novo Oriente de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2772,'3145372','Novorizonte','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2773,'3145406','Olaria','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2774,'3145455','Olhos-D\'Água','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2775,'3145505','Olímpio Noronha','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2776,'3145604','Oliveira','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2777,'3145703','Oliveira Fortes','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2778,'3145802','Onça de Pitangui','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2779,'3145851','Oratórios','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2780,'3145877','Orizânia','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2781,'3145901','Ouro Branco','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2782,'3146008','Ouro Fino','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2783,'3146107','Ouro Preto','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2784,'3146206','Ouro Verde de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2785,'3146255','Padre Carvalho','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2786,'3146305','Padre Paraíso','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2787,'3146404','Paineiras','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2788,'3146503','Pains','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2789,'3146552','Pai Pedro','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2790,'3146602','Paiva','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2791,'3146701','Palma','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2792,'3146750','Palmópolis','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2793,'3146909','Papagaios','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2794,'3147006','Paracatu','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2795,'3147105','Pará de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2796,'3147204','Paraguaçu','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2797,'3147303','Paraisópolis','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2798,'3147402','Paraopeba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2799,'3147501','Passabém','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2800,'3147600','Passa Quatro','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2801,'3147709','Passa Tempo','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2802,'3147808','Passa-Vinte','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2803,'3147907','Passos','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2804,'3147956','Patis','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2805,'3148004','Patos de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2806,'3148103','Patrocínio','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2807,'3148202','Patrocínio do Muriaé','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2808,'3148301','Paula Cândido','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2809,'3148400','Paulistas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2810,'3148509','Pavão','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2811,'3148608','Peçanha','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2812,'3148707','Pedra Azul','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2813,'3148756','Pedra Bonita','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2814,'3148806','Pedra do Anta','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2815,'3148905','Pedra do Indaiá','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2816,'3149002','Pedra Dourada','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2817,'3149101','Pedralva','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2818,'3149150','Pedras de Maria da Cruz','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2819,'3149200','Pedrinópolis','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2820,'3149309','Pedro Leopoldo','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2821,'3149408','Pedro Teixeira','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2822,'3149507','Pequeri','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2823,'3149606','Pequi','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2824,'3149705','Perdigão','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2825,'3149804','Perdizes','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2826,'3149903','Perdões','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2827,'3149952','Periquito','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2828,'3150000','Pescador','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2829,'3150109','Piau','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2830,'3150158','Piedade de Caratinga','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2831,'3150208','Piedade de Ponte Nova','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2832,'3150307','Piedade do Rio Grande','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2833,'3150406','Piedade dos Gerais','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2834,'3150505','Pimenta','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2835,'3150539','Pingo-D\'Água','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2836,'3150570','Pintópolis','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2837,'3150604','Piracema','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2838,'3150703','Pirajuba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2839,'3150802','Piranga','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2840,'3150901','Piranguçu','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2841,'3151008','Piranguinho','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2842,'3151107','Pirapetinga','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2843,'3151206','Pirapora','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2844,'3151305','Piraúba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2845,'3151404','Pitangui','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2846,'3151503','Piumhi','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2847,'3151602','Planura','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2848,'3151701','Poço Fundo','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2849,'3151800','Poços de Caldas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2850,'3151909','Pocrane','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2851,'3152006','Pompéu','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2852,'3152105','Ponte Nova','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2853,'3152131','Ponto Chique','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2854,'3152170','Ponto dos Volantes','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2855,'3152204','Porteirinha','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2856,'3152303','Porto Firme','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2857,'3152402','Poté','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2858,'3152501','Pouso Alegre','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2859,'3152600','Pouso Alto','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2860,'3152709','Prados','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2861,'3152808','Prata','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2862,'3152907','Pratápolis','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2863,'3153004','Pratinha','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2864,'3153103','Presidente Bernardes','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2865,'3153202','Presidente Juscelino','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2866,'3153301','Presidente Kubitschek','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2867,'3153400','Presidente Olegário','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2868,'3153509','Alto Jequitibá','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2869,'3153608','Prudente de Morais','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2870,'3153707','Quartel Geral','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2871,'3153806','Queluzito','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2872,'3153905','Raposos','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2873,'3154002','Raul Soares','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2874,'3154101','Recreio','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2875,'3154150','Reduto','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2876,'3154200','Resende Costa','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2877,'3154309','Resplendor','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2878,'3154408','Ressaquinha','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2879,'3154457','Riachinho','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2880,'3154507','Riacho dos Machados','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2881,'3154606','Ribeirão das Neves','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2882,'3154705','Ribeirão Vermelho','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2883,'3154804','Rio Acima','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2884,'3154903','Rio Casca','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2885,'3155009','Rio Doce','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2886,'3155108','Rio do Prado','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2887,'3155207','Rio Espera','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2888,'3155306','Rio Manso','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2889,'3155405','Rio Novo','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2890,'3155504','Rio Paranaíba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2891,'3155603','Rio Pardo de Minas','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2892,'3155702','Rio Piracicaba','MG','2020-11-24 14:29:11','2020-11-24 14:29:11'),(2893,'3155801','Rio Pomba','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2894,'3155900','Rio Preto','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2895,'3156007','Rio Vermelho','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2896,'3156106','Ritápolis','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2897,'3156205','Rochedo de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2898,'3156304','Rodeiro','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2899,'3156403','Romaria','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2900,'3156452','Rosário da Limeira','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2901,'3156502','Rubelita','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2902,'3156601','Rubim','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2903,'3156700','Sabará','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2904,'3156809','Sabinópolis','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2905,'3156908','Sacramento','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2906,'3157005','Salinas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2907,'3157104','Salto da Divisa','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2908,'3157203','Santa Bárbara','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2909,'3157252','Santa Bárbara do Leste','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2910,'3157278','Santa Bárbara do Monte Verde','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2911,'3157302','Santa Bárbara do Tugúrio','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2912,'3157336','Santa Cruz de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2913,'3157377','Santa Cruz de Salinas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2914,'3157401','Santa Cruz do Escalvado','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2915,'3157500','Santa Efigênia de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2916,'3157609','Santa Fé de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2917,'3157658','Santa Helena de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2918,'3157708','Santa Juliana','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2919,'3157807','Santa Luzia','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2920,'3157906','Santa Margarida','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2921,'3158003','Santa Maria de Itabira','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2922,'3158102','Santa Maria do Salto','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2923,'3158201','Santa Maria do Suaçuí','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2924,'3158300','Santana da Vargem','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2925,'3158409','Santana de Cataguases','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2926,'3158508','Santana de Pirapama','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2927,'3158607','Santana do Deserto','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2928,'3158706','Santana do Garambéu','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2929,'3158805','Santana do Jacaré','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2930,'3158904','Santana do Manhuaçu','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2931,'3158953','Santana do Paraíso','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2932,'3159001','Santana do Riacho','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2933,'3159100','Santana dos Montes','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2934,'3159209','Santa Rita de Caldas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2935,'3159308','Santa Rita de Jacutinga','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2936,'3159357','Santa Rita de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2937,'3159407','Santa Rita de Ibitipoca','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2938,'3159506','Santa Rita do Itueto','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2939,'3159605','Santa Rita do Sapucaí','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2940,'3159704','Santa Rosa da Serra','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2941,'3159803','Santa Vitória','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2942,'3159902','Santo Antônio do Amparo','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2943,'3160009','Santo Antônio do Aventureiro','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2944,'3160108','Santo Antônio do Grama','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2945,'3160207','Santo Antônio do Itambé','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2946,'3160306','Santo Antônio do Jacinto','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2947,'3160405','Santo Antônio do Monte','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2948,'3160454','Santo Antônio do Retiro','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2949,'3160504','Santo Antônio do Rio Abaixo','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2950,'3160603','Santo Hipólito','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2951,'3160702','Santos Dumont','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2952,'3160801','São Bento Abade','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2953,'3160900','São Brás do Suaçuí','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2954,'3160959','São Domingos das Dores','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2955,'3161007','São Domingos do Prata','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2956,'3161056','São Félix de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2957,'3161106','São Francisco','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2958,'3161205','São Francisco de Paula','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2959,'3161304','São Francisco de Sales','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2960,'3161403','São Francisco do Glória','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2961,'3161502','São Geraldo','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2962,'3161601','São Geraldo da Piedade','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2963,'3161650','São Geraldo do Baixio','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2964,'3161700','São Gonçalo do Abaeté','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2965,'3161809','São Gonçalo do Pará','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2966,'3161908','São Gonçalo do Rio Abaixo','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2967,'3162005','São Gonçalo do Sapucaí','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2968,'3162104','São Gotardo','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2969,'3162203','São João Batista do Glória','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2970,'3162252','São João da Lagoa','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2971,'3162302','São João da Mata','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2972,'3162401','São João da Ponte','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2973,'3162450','São João das Missões','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2974,'3162500','São João del Rei','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2975,'3162559','São João do Manhuaçu','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2976,'3162575','São João do Manteninha','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2977,'3162609','São João do Oriente','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2978,'3162658','São João do Pacuí','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2979,'3162708','São João do Paraíso','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2980,'3162807','São João Evangelista','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2981,'3162906','São João Nepomuceno','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2982,'3162922','São Joaquim de Bicas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2983,'3162948','São José da Barra','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2984,'3162955','São José da Lapa','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2985,'3163003','São José da Safira','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2986,'3163102','São José da Varginha','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2987,'3163201','São José do Alegre','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2988,'3163300','São José do Divino','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2989,'3163409','São José do Goiabal','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2990,'3163508','São José do Jacuri','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2991,'3163607','São José do Mantimento','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2992,'3163706','São Lourenço','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2993,'3163805','São Miguel do Anta','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2994,'3163904','São Pedro da União','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2995,'3164001','São Pedro dos Ferros','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2996,'3164100','São Pedro do Suaçuí','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2997,'3164209','São Romão','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2998,'3164308','São Roque de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(2999,'3164407','São Sebastião da Bela Vista','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3000,'3164431','São Sebastião da Vargem Alegre','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3001,'3164472','São Sebastião do Anta','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3002,'3164506','São Sebastião do Maranhão','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3003,'3164605','São Sebastião do Oeste','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3004,'3164704','São Sebastião do Paraíso','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3005,'3164803','São Sebastião do Rio Preto','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3006,'3164902','São Sebastião do Rio Verde','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3007,'3165008','São Tiago','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3008,'3165107','São Tomás de Aquino','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3009,'3165206','São Thomé das Letras','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3010,'3165305','São Vicente de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3011,'3165404','Sapucaí-Mirim','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3012,'3165503','Sardoá','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3013,'3165537','Sarzedo','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3014,'3165552','Setubinha','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3015,'3165560','Sem-Peixe','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3016,'3165578','Senador Amaral','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3017,'3165602','Senador Cortes','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3018,'3165701','Senador Firmino','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3019,'3165800','Senador José Bento','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3020,'3165909','Senador Modestino Gonçalves','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3021,'3166006','Senhora de Oliveira','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3022,'3166105','Senhora do Porto','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3023,'3166204','Senhora dos Remédios','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3024,'3166303','Sericita','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3025,'3166402','Seritinga','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3026,'3166501','Serra Azul de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3027,'3166600','Serra da Saudade','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3028,'3166709','Serra dos Aimorés','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3029,'3166808','Serra do Salitre','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3030,'3166907','Serrania','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3031,'3166956','Serranópolis de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3032,'3167004','Serranos','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3033,'3167103','Serro','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3034,'3167202','Sete Lagoas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3035,'3167301','Silveirânia','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3036,'3167400','Silvianópolis','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3037,'3167509','Simão Pereira','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3038,'3167608','Simonésia','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3039,'3167707','Sobrália','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3040,'3167806','Soledade de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3041,'3167905','Tabuleiro','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3042,'3168002','Taiobeiras','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3043,'3168051','Taparuba','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3044,'3168101','Tapira','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3045,'3168200','Tapiraí','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3046,'3168309','Taquaraçu de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3047,'3168408','Tarumirim','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3048,'3168507','Teixeiras','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3049,'3168606','Teófilo Otoni','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3050,'3168705','Timóteo','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3051,'3168804','Tiradentes','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3052,'3168903','Tiros','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3053,'3169000','Tocantins','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3054,'3169059','Tocos do Moji','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3055,'3169109','Toledo','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3056,'3169208','Tombos','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3057,'3169307','Três Corações','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3058,'3169356','Três Marias','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3059,'3169406','Três Pontas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3060,'3169505','Tumiritinga','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3061,'3169604','Tupaciguara','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3062,'3169703','Turmalina','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3063,'3169802','Turvolândia','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3064,'3169901','Ubá','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3065,'3170008','Ubaí','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3066,'3170057','Ubaporanga','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3067,'3170107','Uberaba','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3068,'3170206','Uberlândia','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3069,'3170305','Umburatiba','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3070,'3170404','Unaí','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3071,'3170438','União de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3072,'3170479','Uruana de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3073,'3170503','Urucânia','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3074,'3170529','Urucuia','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3075,'3170578','Vargem Alegre','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3076,'3170602','Vargem Bonita','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3077,'3170651','Vargem Grande do Rio Pardo','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3078,'3170701','Varginha','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3079,'3170750','Varjão de Minas','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3080,'3170800','Várzea da Palma','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3081,'3170909','Varzelândia','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3082,'3171006','Vazante','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3083,'3171030','Verdelândia','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3084,'3171071','Veredinha','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3085,'3171105','Veríssimo','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3086,'3171154','Vermelho Novo','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3087,'3171204','Vespasiano','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3088,'3171303','Viçosa','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3089,'3171402','Vieiras','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3090,'3171501','Mathias Lobato','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3091,'3171600','Virgem da Lapa','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3092,'3171709','Virgínia','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3093,'3171808','Virginópolis','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3094,'3171907','Virgolândia','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3095,'3172004','Visconde do Rio Branco','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3096,'3172103','Volta Grande','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3097,'3172202','Wenceslau Braz','MG','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3098,'3200102','Afonso Cláudio','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3099,'3200136','Águia Branca','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3100,'3200169','Água Doce do Norte','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3101,'3200201','Alegre','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3102,'3200300','Alfredo Chaves','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3103,'3200359','Alto Rio Novo','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3104,'3200409','Anchieta','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3105,'3200508','Apiacá','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3106,'3200607','Aracruz','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3107,'3200706','Atilio Vivacqua','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3108,'3200805','Baixo Guandu','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3109,'3200904','Barra de São Francisco','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3110,'3201001','Boa Esperança','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3111,'3201100','Bom Jesus do Norte','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3112,'3201159','Brejetuba','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3113,'3201209','Cachoeiro de Itapemirim','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3114,'3201308','Cariacica','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3115,'3201407','Castelo','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3116,'3201506','Colatina','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3117,'3201605','Conceição da Barra','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3118,'3201704','Conceição do Castelo','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3119,'3201803','Divino de São Lourenço','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3120,'3201902','Domingos Martins','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3121,'3202009','Dores do Rio Preto','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3122,'3202108','Ecoporanga','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3123,'3202207','Fundão','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3124,'3202256','Governador Lindenberg','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3125,'3202306','Guaçuí','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3126,'3202405','Guarapari','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3127,'3202454','Ibatiba','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3128,'3202504','Ibiraçu','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3129,'3202553','Ibitirama','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3130,'3202603','Iconha','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3131,'3202652','Irupi','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3132,'3202702','Itaguaçu','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3133,'3202801','Itapemirim','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3134,'3202900','Itarana','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3135,'3203007','Iúna','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3136,'3203056','Jaguaré','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3137,'3203106','Jerônimo Monteiro','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3138,'3203130','João Neiva','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3139,'3203163','Laranja da Terra','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3140,'3203205','Linhares','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3141,'3203304','Mantenópolis','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3142,'3203320','Marataízes','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3143,'3203346','Marechal Floriano','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3144,'3203353','Marilândia','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3145,'3203403','Mimoso do Sul','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3146,'3203502','Montanha','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3147,'3203601','Mucurici','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3148,'3203700','Muniz Freire','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3149,'3203809','Muqui','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3150,'3203908','Nova Venécia','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3151,'3204005','Pancas','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3152,'3204054','Pedro Canário','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3153,'3204104','Pinheiros','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3154,'3204203','Piúma','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3155,'3204252','Ponto Belo','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3156,'3204302','Presidente Kennedy','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3157,'3204351','Rio Bananal','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3158,'3204401','Rio Novo do Sul','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3159,'3204500','Santa Leopoldina','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3160,'3204559','Santa Maria de Jetibá','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3161,'3204609','Santa Teresa','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3162,'3204658','São Domingos do Norte','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3163,'3204708','São Gabriel da Palha','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3164,'3204807','São José do Calçado','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3165,'3204906','São Mateus','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3166,'3204955','São Roque do Canaã','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3167,'3205002','Serra','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3168,'3205010','Sooretama','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3169,'3205036','Vargem Alta','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3170,'3205069','Venda Nova do Imigrante','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3171,'3205101','Viana','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3172,'3205150','Vila Pavão','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3173,'3205176','Vila Valério','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3174,'3205200','Vila Velha','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3175,'3205309','Vitória','ES','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3176,'3300100','Angra dos Reis','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3177,'3300159','Aperibé','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3178,'3300209','Araruama','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3179,'3300225','Areal','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3180,'3300233','Armação dos Búzios','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3181,'3300258','Arraial do Cabo','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3182,'3300308','Barra do Piraí','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3183,'3300407','Barra Mansa','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3184,'3300456','Belford Roxo','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3185,'3300506','Bom Jardim','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3186,'3300605','Bom Jesus do Itabapoana','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3187,'3300704','Cabo Frio','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3188,'3300803','Cachoeiras de Macacu','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3189,'3300902','Cambuci','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3190,'3300936','Carapebus','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3191,'3300951','Comendador Levy Gasparian','RJ','2020-11-24 14:29:12','2020-11-24 14:29:12'),(3192,'3301009','Campos dos Goytacazes','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3193,'3301108','Cantagalo','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3194,'3301157','Cardoso Moreira','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3195,'3301207','Carmo','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3196,'3301306','Casimiro de Abreu','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3197,'3301405','Conceição de Macabu','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3198,'3301504','Cordeiro','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3199,'3301603','Duas Barras','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3200,'3301702','Duque de Caxias','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3201,'3301801','Engenheiro Paulo de Frontin','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3202,'3301850','Guapimirim','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3203,'3301876','Iguaba Grande','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3204,'3301900','Itaboraí','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3205,'3302007','Itaguaí','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3206,'3302056','Italva','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3207,'3302106','Itaocara','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3208,'3302205','Itaperuna','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3209,'3302254','Itatiaia','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3210,'3302270','Japeri','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3211,'3302304','Laje do Muriaé','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3212,'3302403','Macaé','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3213,'3302452','Macuco','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3214,'3302502','Magé','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3215,'3302601','Mangaratiba','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3216,'3302700','Maricá','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3217,'3302809','Mendes','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3218,'3302858','Mesquita','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3219,'3302908','Miguel Pereira','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3220,'3303005','Miracema','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3221,'3303104','Natividade','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3222,'3303203','Nilópolis','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3223,'3303302','Niterói','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3224,'3303401','Nova Friburgo','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3225,'3303500','Nova Iguaçu','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3226,'3303609','Paracambi','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3227,'3303708','Paraíba do Sul','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3228,'3303807','Paraty','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3229,'3303856','Paty do Alferes','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3230,'3303906','Petrópolis','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3231,'3303955','Pinheiral','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3232,'3304003','Piraí','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3233,'3304102','Porciúncula','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3234,'3304110','Porto Real','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3235,'3304128','Quatis','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3236,'3304144','Queimados','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3237,'3304151','Quissamã','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3238,'3304201','Resende','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3239,'3304300','Rio Bonito','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3240,'3304409','Rio Claro','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3241,'3304508','Rio das Flores','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3242,'3304524','Rio das Ostras','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3243,'3304557','Rio de Janeiro','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3244,'3304607','Santa Maria Madalena','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3245,'3304706','Santo Antônio de Pádua','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3246,'3304755','São Francisco de Itabapoana','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3247,'3304805','São Fidélis','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3248,'3304904','São Gonçalo','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3249,'3305000','São João da Barra','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3250,'3305109','São João de Meriti','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3251,'3305133','São José de Ubá','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3252,'3305158','São José do Vale do Rio Preto','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3253,'3305208','São Pedro da Aldeia','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3254,'3305307','São Sebastião do Alto','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3255,'3305406','Sapucaia','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3256,'3305505','Saquarema','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3257,'3305554','Seropédica','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3258,'3305604','Silva Jardim','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3259,'3305703','Sumidouro','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3260,'3305752','Tanguá','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3261,'3305802','Teresópolis','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3262,'3305901','Trajano de Moraes','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3263,'3306008','Três Rios','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3264,'3306107','Valença','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3265,'3306156','Varre-Sai','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3266,'3306206','Vassouras','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3267,'3306305','Volta Redonda','RJ','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3268,'3500105','Adamantina','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3269,'3500204','Adolfo','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3270,'3500303','Aguaí','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3271,'3500402','Águas da Prata','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3272,'3500501','Águas de Lindóia','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3273,'3500550','Águas de Santa Bárbara','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3274,'3500600','Águas de São Pedro','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3275,'3500709','Agudos','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3276,'3500758','Alambari','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3277,'3500808','Alfredo Marcondes','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3278,'3500907','Altair','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3279,'3501004','Altinópolis','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3280,'3501103','Alto Alegre','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3281,'3501152','Alumínio','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3282,'3501202','Álvares Florence','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3283,'3501301','Álvares Machado','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3284,'3501400','Álvaro de Carvalho','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3285,'3501509','Alvinlândia','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3286,'3501608','Americana','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3287,'3501707','Américo Brasiliense','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3288,'3501806','Américo de Campos','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3289,'3501905','Amparo','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3290,'3502002','Analândia','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3291,'3502101','Andradina','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3292,'3502200','Angatuba','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3293,'3502309','Anhembi','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3294,'3502408','Anhumas','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3295,'3502507','Aparecida','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3296,'3502606','Aparecida D\'Oeste','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3297,'3502705','Apiaí','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3298,'3502754','Araçariguama','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3299,'3502804','Araçatuba','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3300,'3502903','Araçoiaba da Serra','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3301,'3503000','Aramina','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3302,'3503109','Arandu','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3303,'3503158','Arapeí','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3304,'3503208','Araraquara','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3305,'3503307','Araras','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3306,'3503356','Arco-Íris','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3307,'3503406','Arealva','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3308,'3503505','Areias','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3309,'3503604','Areiópolis','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3310,'3503703','Ariranha','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3311,'3503802','Artur Nogueira','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3312,'3503901','Arujá','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3313,'3503950','Aspásia','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3314,'3504008','Assis','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3315,'3504107','Atibaia','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3316,'3504206','Auriflama','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3317,'3504305','Avaí','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3318,'3504404','Avanhandava','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3319,'3504503','Avaré','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3320,'3504602','Bady Bassitt','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3321,'3504701','Balbinos','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3322,'3504800','Bálsamo','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3323,'3504909','Bananal','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3324,'3505005','Barão de Antonina','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3325,'3505104','Barbosa','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3326,'3505203','Bariri','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3327,'3505302','Barra Bonita','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3328,'3505351','Barra do Chapéu','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3329,'3505401','Barra do Turvo','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3330,'3505500','Barretos','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3331,'3505609','Barrinha','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3332,'3505708','Barueri','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3333,'3505807','Bastos','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3334,'3505906','Batatais','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3335,'3506003','Bauru','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3336,'3506102','Bebedouro','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3337,'3506201','Bento de Abreu','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3338,'3506300','Bernardino de Campos','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3339,'3506359','Bertioga','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3340,'3506409','Bilac','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3341,'3506508','Birigui','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3342,'3506607','Biritiba-Mirim','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3343,'3506706','Boa Esperança do Sul','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3344,'3506805','Bocaina','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3345,'3506904','Bofete','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3346,'3507001','Boituva','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3347,'3507100','Bom Jesus dos Perdões','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3348,'3507159','Bom Sucesso de Itararé','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3349,'3507209','Borá','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3350,'3507308','Boracéia','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3351,'3507407','Borborema','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3352,'3507456','Borebi','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3353,'3507506','Botucatu','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3354,'3507605','Bragança Paulista','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3355,'3507704','Braúna','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3356,'3507753','Brejo Alegre','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3357,'3507803','Brodowski','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3358,'3507902','Brotas','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3359,'3508009','Buri','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3360,'3508108','Buritama','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3361,'3508207','Buritizal','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3362,'3508306','Cabrália Paulista','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3363,'3508405','Cabreúva','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3364,'3508504','Caçapava','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3365,'3508603','Cachoeira Paulista','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3366,'3508702','Caconde','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3367,'3508801','Cafelândia','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3368,'3508900','Caiabu','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3369,'3509007','Caieiras','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3370,'3509106','Caiuá','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3371,'3509205','Cajamar','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3372,'3509254','Cajati','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3373,'3509304','Cajobi','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3374,'3509403','Cajuru','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3375,'3509452','Campina do Monte Alegre','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3376,'3509502','Campinas','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3377,'3509601','Campo Limpo Paulista','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3378,'3509700','Campos do Jordão','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3379,'3509809','Campos Novos Paulista','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3380,'3509908','Cananéia','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3381,'3509957','Canas','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3382,'3510005','Cândido Mota','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3383,'3510104','Cândido Rodrigues','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3384,'3510153','Canitar','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3385,'3510203','Capão Bonito','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3386,'3510302','Capela do Alto','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3387,'3510401','Capivari','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3388,'3510500','Caraguatatuba','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3389,'3510609','Carapicuíba','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3390,'3510708','Cardoso','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3391,'3510807','Casa Branca','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3392,'3510906','Cássia dos Coqueiros','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3393,'3511003','Castilho','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3394,'3511102','Catanduva','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3395,'3511201','Catiguá','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3396,'3511300','Cedral','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3397,'3511409','Cerqueira César','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3398,'3511508','Cerquilho','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3399,'3511607','Cesário Lange','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3400,'3511706','Charqueada','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3401,'3511904','Clementina','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3402,'3512001','Colina','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3403,'3512100','Colômbia','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3404,'3512209','Conchal','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3405,'3512308','Conchas','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3406,'3512407','Cordeirópolis','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3407,'3512506','Coroados','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3408,'3512605','Coronel Macedo','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3409,'3512704','Corumbataí','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3410,'3512803','Cosmópolis','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3411,'3512902','Cosmorama','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3412,'3513009','Cotia','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3413,'3513108','Cravinhos','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3414,'3513207','Cristais Paulista','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3415,'3513306','Cruzália','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3416,'3513405','Cruzeiro','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3417,'3513504','Cubatão','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3418,'3513603','Cunha','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3419,'3513702','Descalvado','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3420,'3513801','Diadema','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3421,'3513850','Dirce Reis','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3422,'3513900','Divinolândia','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3423,'3514007','Dobrada','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3424,'3514106','Dois Córregos','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3425,'3514205','Dolcinópolis','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3426,'3514304','Dourado','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3427,'3514403','Dracena','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3428,'3514502','Duartina','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3429,'3514601','Dumont','SP','2020-11-24 14:29:13','2020-11-24 14:29:13'),(3430,'3514700','Echaporã','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3431,'3514809','Eldorado','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3432,'3514908','Elias Fausto','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3433,'3514924','Elisiário','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3434,'3514957','Embaúba','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3435,'3515004','Embu das Artes','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3436,'3515103','Embu-Guaçu','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3437,'3515129','Emilianópolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3438,'3515152','Engenheiro Coelho','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3439,'3515186','Espírito Santo do Pinhal','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3440,'3515194','Espírito Santo do Turvo','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3441,'3515202','Estrela D\'Oeste','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3442,'3515301','Estrela do Norte','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3443,'3515350','Euclides da Cunha Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3444,'3515400','Fartura','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3445,'3515509','Fernandópolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3446,'3515608','Fernando Prestes','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3447,'3515657','Fernão','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3448,'3515707','Ferraz de Vasconcelos','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3449,'3515806','Flora Rica','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3450,'3515905','Floreal','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3451,'3516002','Flórida Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3452,'3516101','Florínia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3453,'3516200','Franca','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3454,'3516309','Francisco Morato','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3455,'3516408','Franco da Rocha','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3456,'3516507','Gabriel Monteiro','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3457,'3516606','Gália','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3458,'3516705','Garça','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3459,'3516804','Gastão Vidigal','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3460,'3516853','Gavião Peixoto','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3461,'3516903','General Salgado','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3462,'3517000','Getulina','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3463,'3517109','Glicério','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3464,'3517208','Guaiçara','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3465,'3517307','Guaimbê','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3466,'3517406','Guaíra','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3467,'3517505','Guapiaçu','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3468,'3517604','Guapiara','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3469,'3517703','Guará','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3470,'3517802','Guaraçaí','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3471,'3517901','Guaraci','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3472,'3518008','Guarani D\'Oeste','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3473,'3518107','Guarantã','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3474,'3518206','Guararapes','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3475,'3518305','Guararema','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3476,'3518404','Guaratinguetá','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3477,'3518503','Guareí','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3478,'3518602','Guariba','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3479,'3518701','Guarujá','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3480,'3518800','Guarulhos','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3481,'3518859','Guatapará','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3482,'3518909','Guzolândia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3483,'3519006','Herculândia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3484,'3519055','Holambra','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3485,'3519071','Hortolândia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3486,'3519105','Iacanga','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3487,'3519204','Iacri','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3488,'3519253','Iaras','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3489,'3519303','Ibaté','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3490,'3519402','Ibirá','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3491,'3519501','Ibirarema','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3492,'3519600','Ibitinga','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3493,'3519709','Ibiúna','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3494,'3519808','Icém','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3495,'3519907','Iepê','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3496,'3520004','Igaraçu do Tietê','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3497,'3520103','Igarapava','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3498,'3520202','Igaratá','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3499,'3520301','Iguape','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3500,'3520400','Ilhabela','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3501,'3520426','Ilha Comprida','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3502,'3520442','Ilha Solteira','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3503,'3520509','Indaiatuba','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3504,'3520608','Indiana','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3505,'3520707','Indiaporã','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3506,'3520806','Inúbia Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3507,'3520905','Ipaussu','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3508,'3521002','Iperó','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3509,'3521101','Ipeúna','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3510,'3521150','Ipiguá','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3511,'3521200','Iporanga','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3512,'3521309','Ipuã','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3513,'3521408','Iracemápolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3514,'3521507','Irapuã','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3515,'3521606','Irapuru','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3516,'3521705','Itaberá','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3517,'3521804','Itaí','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3518,'3521903','Itajobi','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3519,'3522000','Itaju','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3520,'3522109','Itanhaém','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3521,'3522158','Itaóca','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3522,'3522208','Itapecerica da Serra','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3523,'3522307','Itapetininga','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3524,'3522406','Itapeva','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3525,'3522505','Itapevi','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3526,'3522604','Itapira','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3527,'3522653','Itapirapuã Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3528,'3522703','Itápolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3529,'3522802','Itaporanga','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3530,'3522901','Itapuí','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3531,'3523008','Itapura','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3532,'3523107','Itaquaquecetuba','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3533,'3523206','Itararé','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3534,'3523305','Itariri','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3535,'3523404','Itatiba','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3536,'3523503','Itatinga','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3537,'3523602','Itirapina','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3538,'3523701','Itirapuã','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3539,'3523800','Itobi','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3540,'3523909','Itu','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3541,'3524006','Itupeva','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3542,'3524105','Ituverava','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3543,'3524204','Jaborandi','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3544,'3524303','Jaboticabal','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3545,'3524402','Jacareí','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3546,'3524501','Jaci','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3547,'3524600','Jacupiranga','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3548,'3524709','Jaguariúna','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3549,'3524808','Jales','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3550,'3524907','Jambeiro','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3551,'3525003','Jandira','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3552,'3525102','Jardinópolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3553,'3525201','Jarinu','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3554,'3525300','Jaú','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3555,'3525409','Jeriquara','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3556,'3525508','Joanópolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3557,'3525607','João Ramalho','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3558,'3525706','José Bonifácio','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3559,'3525805','Júlio Mesquita','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3560,'3525854','Jumirim','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3561,'3525904','Jundiaí','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3562,'3526001','Junqueirópolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3563,'3526100','Juquiá','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3564,'3526209','Juquitiba','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3565,'3526308','Lagoinha','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3566,'3526407','Laranjal Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3567,'3526506','Lavínia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3568,'3526605','Lavrinhas','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3569,'3526704','Leme','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3570,'3526803','Lençóis Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3571,'3526902','Limeira','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3572,'3527009','Lindóia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3573,'3527108','Lins','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3574,'3527207','Lorena','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3575,'3527256','Lourdes','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3576,'3527306','Louveira','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3577,'3527405','Lucélia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3578,'3527504','Lucianópolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3579,'3527603','Luís Antônio','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3580,'3527702','Luiziânia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3581,'3527801','Lupércio','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3582,'3527900','Lutécia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3583,'3528007','Macatuba','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3584,'3528106','Macaubal','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3585,'3528205','Macedônia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3586,'3528304','Magda','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3587,'3528403','Mairinque','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3588,'3528502','Mairiporã','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3589,'3528601','Manduri','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3590,'3528700','Marabá Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3591,'3528809','Maracaí','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3592,'3528858','Marapoama','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3593,'3528908','Mariápolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3594,'3529005','Marília','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3595,'3529104','Marinópolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3596,'3529203','Martinópolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3597,'3529302','Matão','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3598,'3529401','Mauá','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3599,'3529500','Mendonça','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3600,'3529609','Meridiano','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3601,'3529658','Mesópolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3602,'3529708','Miguelópolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3603,'3529807','Mineiros do Tietê','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3604,'3529906','Miracatu','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3605,'3530003','Mira Estrela','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3606,'3530102','Mirandópolis','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3607,'3530201','Mirante do Paranapanema','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3608,'3530300','Mirassol','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3609,'3530409','Mirassolândia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3610,'3530508','Mococa','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3611,'3530607','Mogi das Cruzes','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3612,'3530706','Mogi Guaçu','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3613,'3530805','Moji Mirim','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3614,'3530904','Mombuca','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3615,'3531001','Monções','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3616,'3531100','Mongaguá','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3617,'3531209','Monte Alegre do Sul','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3618,'3531308','Monte Alto','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3619,'3531407','Monte Aprazível','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3620,'3531506','Monte Azul Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3621,'3531605','Monte Castelo','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3622,'3531704','Monteiro Lobato','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3623,'3531803','Monte Mor','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3624,'3531902','Morro Agudo','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3625,'3532009','Morungaba','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3626,'3532058','Motuca','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3627,'3532108','Murutinga do Sul','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3628,'3532157','Nantes','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3629,'3532207','Narandiba','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3630,'3532306','Natividade da Serra','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3631,'3532405','Nazaré Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3632,'3532504','Neves Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3633,'3532603','Nhandeara','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3634,'3532702','Nipoã','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3635,'3532801','Nova Aliança','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3636,'3532827','Nova Campina','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3637,'3532843','Nova Canaã Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3638,'3532868','Nova Castilho','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3639,'3532900','Nova Europa','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3640,'3533007','Nova Granada','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3641,'3533106','Nova Guataporanga','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3642,'3533205','Nova Independência','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3643,'3533254','Novais','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3644,'3533304','Nova Luzitânia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3645,'3533403','Nova Odessa','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3646,'3533502','Novo Horizonte','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3647,'3533601','Nuporanga','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3648,'3533700','Ocauçu','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3649,'3533809','Óleo','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3650,'3533908','Olímpia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3651,'3534005','Onda Verde','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3652,'3534104','Oriente','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3653,'3534203','Orindiúva','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3654,'3534302','Orlândia','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3655,'3534401','Osasco','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3656,'3534500','Oscar Bressane','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3657,'3534609','Osvaldo Cruz','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3658,'3534708','Ourinhos','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3659,'3534757','Ouroeste','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3660,'3534807','Ouro Verde','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3661,'3534906','Pacaembu','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3662,'3535002','Palestina','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3663,'3535101','Palmares Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3664,'3535200','Palmeira D\'Oeste','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3665,'3535309','Palmital','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3666,'3535408','Panorama','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3667,'3535507','Paraguaçu Paulista','SP','2020-11-24 14:29:14','2020-11-24 14:29:14'),(3668,'3535606','Paraibuna','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3669,'3535705','Paraíso','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3670,'3535804','Paranapanema','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3671,'3535903','Paranapuã','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3672,'3536000','Parapuã','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3673,'3536109','Pardinho','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3674,'3536208','Pariquera-Açu','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3675,'3536257','Parisi','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3676,'3536307','Patrocínio Paulista','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3677,'3536406','Paulicéia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3678,'3536505','Paulínia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3679,'3536570','Paulistânia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3680,'3536604','Paulo de Faria','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3681,'3536703','Pederneiras','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3682,'3536802','Pedra Bela','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3683,'3536901','Pedranópolis','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3684,'3537008','Pedregulho','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3685,'3537107','Pedreira','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3686,'3537156','Pedrinhas Paulista','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3687,'3537206','Pedro de Toledo','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3688,'3537305','Penápolis','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3689,'3537404','Pereira Barreto','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3690,'3537503','Pereiras','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3691,'3537602','Peruíbe','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3692,'3537701','Piacatu','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3693,'3537800','Piedade','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3694,'3537909','Pilar do Sul','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3695,'3538006','Pindamonhangaba','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3696,'3538105','Pindorama','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3697,'3538204','Pinhalzinho','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3698,'3538303','Piquerobi','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3699,'3538501','Piquete','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3700,'3538600','Piracaia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3701,'3538709','Piracicaba','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3702,'3538808','Piraju','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3703,'3538907','Pirajuí','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3704,'3539004','Pirangi','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3705,'3539103','Pirapora do Bom Jesus','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3706,'3539202','Pirapozinho','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3707,'3539301','Pirassununga','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3708,'3539400','Piratininga','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3709,'3539509','Pitangueiras','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3710,'3539608','Planalto','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3711,'3539707','Platina','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3712,'3539806','Poá','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3713,'3539905','Poloni','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3714,'3540002','Pompéia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3715,'3540101','Pongaí','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3716,'3540200','Pontal','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3717,'3540259','Pontalinda','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3718,'3540309','Pontes Gestal','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3719,'3540408','Populina','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3720,'3540507','Porangaba','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3721,'3540606','Porto Feliz','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3722,'3540705','Porto Ferreira','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3723,'3540754','Potim','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3724,'3540804','Potirendaba','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3725,'3540853','Pracinha','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3726,'3540903','Pradópolis','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3727,'3541000','Praia Grande','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3728,'3541059','Pratânia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3729,'3541109','Presidente Alves','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3730,'3541208','Presidente Bernardes','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3731,'3541307','Presidente Epitácio','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3732,'3541406','Presidente Prudente','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3733,'3541505','Presidente Venceslau','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3734,'3541604','Promissão','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3735,'3541653','Quadra','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3736,'3541703','Quatá','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3737,'3541802','Queiroz','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3738,'3541901','Queluz','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3739,'3542008','Quintana','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3740,'3542107','Rafard','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3741,'3542206','Rancharia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3742,'3542305','Redenção da Serra','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3743,'3542404','Regente Feijó','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3744,'3542503','Reginópolis','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3745,'3542602','Registro','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3746,'3542701','Restinga','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3747,'3542800','Ribeira','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3748,'3542909','Ribeirão Bonito','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3749,'3543006','Ribeirão Branco','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3750,'3543105','Ribeirão Corrente','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3751,'3543204','Ribeirão do Sul','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3752,'3543238','Ribeirão dos Índios','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3753,'3543253','Ribeirão Grande','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3754,'3543303','Ribeirão Pires','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3755,'3543402','Ribeirão Preto','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3756,'3543501','Riversul','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3757,'3543600','Rifaina','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3758,'3543709','Rincão','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3759,'3543808','Rinópolis','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3760,'3543907','Rio Claro','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3761,'3544004','Rio das Pedras','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3762,'3544103','Rio Grande da Serra','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3763,'3544202','Riolândia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3764,'3544251','Rosana','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3765,'3544301','Roseira','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3766,'3544400','Rubiácea','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3767,'3544509','Rubinéia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3768,'3544608','Sabino','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3769,'3544707','Sagres','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3770,'3544806','Sales','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3771,'3544905','Sales Oliveira','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3772,'3545001','Salesópolis','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3773,'3545100','Salmourão','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3774,'3545159','Saltinho','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3775,'3545209','Salto','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3776,'3545308','Salto de Pirapora','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3777,'3545407','Salto Grande','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3778,'3545506','Sandovalina','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3779,'3545605','Santa Adélia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3780,'3545704','Santa Albertina','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3781,'3545803','Santa Bárbara D\'Oeste','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3782,'3546009','Santa Branca','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3783,'3546108','Santa Clara D\'Oeste','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3784,'3546207','Santa Cruz da Conceição','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3785,'3546256','Santa Cruz da Esperança','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3786,'3546306','Santa Cruz das Palmeiras','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3787,'3546405','Santa Cruz do Rio Pardo','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3788,'3546504','Santa Ernestina','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3789,'3546603','Santa Fé do Sul','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3790,'3546702','Santa Gertrudes','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3791,'3546801','Santa Isabel','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3792,'3546900','Santa Lúcia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3793,'3547007','Santa Maria da Serra','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3794,'3547106','Santa Mercedes','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3795,'3547205','Santana da Ponte Pensa','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3796,'3547304','Santana de Parnaíba','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3797,'3547403','Santa Rita D\'Oeste','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3798,'3547502','Santa Rita do Passa Quatro','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3799,'3547601','Santa Rosa de Viterbo','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3800,'3547650','Santa Salete','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3801,'3547700','Santo Anastácio','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3802,'3547809','Santo André','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3803,'3547908','Santo Antônio da Alegria','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3804,'3548005','Santo Antônio de Posse','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3805,'3548054','Santo Antônio do Aracanguá','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3806,'3548104','Santo Antônio do Jardim','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3807,'3548203','Santo Antônio do Pinhal','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3808,'3548302','Santo Expedito','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3809,'3548401','Santópolis do Aguapeí','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3810,'3548500','Santos','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3811,'3548609','São Bento do Sapucaí','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3812,'3548708','São Bernardo do Campo','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3813,'3548807','São Caetano do Sul','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3814,'3548906','São Carlos','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3815,'3549003','São Francisco','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3816,'3549102','São João da Boa Vista','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3817,'3549201','São João das Duas Pontes','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3818,'3549250','São João de Iracema','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3819,'3549300','São João do Pau D\'Alho','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3820,'3549409','São Joaquim da Barra','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3821,'3549508','São José da Bela Vista','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3822,'3549607','São José do Barreiro','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3823,'3549706','São José do Rio Pardo','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3824,'3549805','São José do Rio Preto','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3825,'3549904','São José dos Campos','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3826,'3549953','São Lourenço da Serra','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3827,'3550001','São Luís do Paraitinga','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3828,'3550100','São Manuel','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3829,'3550209','São Miguel Arcanjo','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3830,'3550308','São Paulo','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3831,'3550407','São Pedro','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3832,'3550506','São Pedro do Turvo','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3833,'3550605','São Roque','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3834,'3550704','São Sebastião','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3835,'3550803','São Sebastião da Grama','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3836,'3550902','São Simão','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3837,'3551009','São Vicente','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3838,'3551108','Sarapuí','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3839,'3551207','Sarutaiá','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3840,'3551306','Sebastianópolis do Sul','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3841,'3551405','Serra Azul','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3842,'3551504','Serrana','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3843,'3551603','Serra Negra','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3844,'3551702','Sertãozinho','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3845,'3551801','Sete Barras','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3846,'3551900','Severínia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3847,'3552007','Silveiras','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3848,'3552106','Socorro','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3849,'3552205','Sorocaba','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3850,'3552304','Sud Mennucci','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3851,'3552403','Sumaré','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3852,'3552502','Suzano','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3853,'3552551','Suzanápolis','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3854,'3552601','Tabapuã','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3855,'3552700','Tabatinga','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3856,'3552809','Taboão da Serra','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3857,'3552908','Taciba','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3858,'3553005','Taguaí','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3859,'3553104','Taiaçu','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3860,'3553203','Taiúva','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3861,'3553302','Tambaú','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3862,'3553401','Tanabi','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3863,'3553500','Tapiraí','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3864,'3553609','Tapiratiba','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3865,'3553658','Taquaral','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3866,'3553708','Taquaritinga','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3867,'3553807','Taquarituba','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3868,'3553856','Taquarivaí','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3869,'3553906','Tarabai','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3870,'3553955','Tarumã','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3871,'3554003','Tatuí','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3872,'3554102','Taubaté','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3873,'3554201','Tejupá','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3874,'3554300','Teodoro Sampaio','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3875,'3554409','Terra Roxa','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3876,'3554508','Tietê','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3877,'3554607','Timburi','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3878,'3554656','Torre de Pedra','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3879,'3554706','Torrinha','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3880,'3554755','Trabiju','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3881,'3554805','Tremembé','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3882,'3554904','Três Fronteiras','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3883,'3554953','Tuiuti','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3884,'3555000','Tupã','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3885,'3555109','Tupi Paulista','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3886,'3555208','Turiúba','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3887,'3555307','Turmalina','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3888,'3555356','Ubarana','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3889,'3555406','Ubatuba','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3890,'3555505','Ubirajara','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3891,'3555604','Uchoa','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3892,'3555703','União Paulista','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3893,'3555802','Urânia','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3894,'3555901','Uru','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3895,'3556008','Urupês','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3896,'3556107','Valentim Gentil','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3897,'3556206','Valinhos','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3898,'3556305','Valparaíso','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3899,'3556354','Vargem','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3900,'3556404','Vargem Grande do Sul','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3901,'3556453','Vargem Grande Paulista','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3902,'3556503','Várzea Paulista','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3903,'3556602','Vera Cruz','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3904,'3556701','Vinhedo','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3905,'3556800','Viradouro','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3906,'3556909','Vista Alegre do Alto','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3907,'3556958','Vitória Brasil','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3908,'3557006','Votorantim','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3909,'3557105','Votuporanga','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3910,'3557154','Zacarias','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3911,'3557204','Chavantes','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3912,'3557303','Estiva Gerbi','SP','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3913,'4100103','Abatiá','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3914,'4100202','Adrianópolis','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3915,'4100301','Agudos do Sul','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3916,'4100400','Almirante Tamandaré','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3917,'4100459','Altamira do Paraná','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3918,'4100509','Altônia','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3919,'4100608','Alto Paraná','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3920,'4100707','Alto Piquiri','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3921,'4100806','Alvorada do Sul','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3922,'4100905','Amaporã','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3923,'4101002','Ampére','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3924,'4101051','Anahy','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3925,'4101101','Andirá','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3926,'4101150','Ângulo','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3927,'4101200','Antonina','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3928,'4101309','Antônio Olinto','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3929,'4101408','Apucarana','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3930,'4101507','Arapongas','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3931,'4101606','Arapoti','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3932,'4101655','Arapuã','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3933,'4101705','Araruna','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3934,'4101804','Araucária','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3935,'4101853','Ariranha do Ivaí','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3936,'4101903','Assaí','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3937,'4102000','Assis Chateaubriand','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3938,'4102109','Astorga','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3939,'4102208','Atalaia','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3940,'4102307','Balsa Nova','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3941,'4102406','Bandeirantes','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3942,'4102505','Barbosa Ferraz','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3943,'4102604','Barracão','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3944,'4102703','Barra do Jacaré','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3945,'4102752','Bela Vista da Caroba','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3946,'4102802','Bela Vista do Paraíso','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3947,'4102901','Bituruna','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3948,'4103008','Boa Esperança','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3949,'4103024','Boa Esperança do Iguaçu','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3950,'4103040','Boa Ventura de São Roque','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3951,'4103057','Boa Vista da Aparecida','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3952,'4103107','Bocaiúva do Sul','PR','2020-11-24 14:29:15','2020-11-24 14:29:15'),(3953,'4103156','Bom Jesus do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3954,'4103206','Bom Sucesso','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3955,'4103222','Bom Sucesso do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3956,'4103305','Borrazópolis','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3957,'4103354','Braganey','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3958,'4103370','Brasilândia do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3959,'4103404','Cafeara','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3960,'4103453','Cafelândia','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3961,'4103479','Cafezal do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3962,'4103503','Califórnia','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3963,'4103602','Cambará','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3964,'4103701','Cambé','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3965,'4103800','Cambira','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3966,'4103909','Campina da Lagoa','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3967,'4103958','Campina do Simão','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3968,'4104006','Campina Grande do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3969,'4104055','Campo Bonito','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3970,'4104105','Campo do Tenente','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3971,'4104204','Campo Largo','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3972,'4104253','Campo Magro','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3973,'4104303','Campo Mourão','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3974,'4104402','Cândido de Abreu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3975,'4104428','Candói','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3976,'4104451','Cantagalo','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3977,'4104501','Capanema','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3978,'4104600','Capitão Leônidas Marques','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3979,'4104659','Carambeí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3980,'4104709','Carlópolis','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3981,'4104808','Cascavel','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3982,'4104907','Castro','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3983,'4105003','Catanduvas','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3984,'4105102','Centenário do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3985,'4105201','Cerro Azul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3986,'4105300','Céu Azul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3987,'4105409','Chopinzinho','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3988,'4105508','Cianorte','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3989,'4105607','cidades Gaúcha','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3990,'4105706','Clevelândia','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3991,'4105805','Colombo','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3992,'4105904','Colorado','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3993,'4106001','Congonhinhas','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3994,'4106100','Conselheiro Mairinck','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3995,'4106209','Contenda','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3996,'4106308','Corbélia','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3997,'4106407','Cornélio Procópio','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3998,'4106456','Coronel Domingos Soares','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(3999,'4106506','Coronel Vivida','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4000,'4106555','Corumbataí do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4001,'4106571','Cruzeiro do Iguaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4002,'4106605','Cruzeiro do Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4003,'4106704','Cruzeiro do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4004,'4106803','Cruz Machado','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4005,'4106852','Cruzmaltina','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4006,'4106902','Curitiba','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4007,'4107009','Curiúva','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4008,'4107108','Diamante do Norte','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4009,'4107124','Diamante do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4010,'4107157','Diamante D\'Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4011,'4107207','Dois Vizinhos','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4012,'4107256','Douradina','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4013,'4107306','Doutor Camargo','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4014,'4107405','Enéas Marques','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4015,'4107504','Engenheiro Beltrão','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4016,'4107520','Esperança Nova','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4017,'4107538','Entre Rios do Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4018,'4107546','Espigão Alto do Iguaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4019,'4107553','Farol','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4020,'4107603','Faxinal','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4021,'4107652','Fazenda Rio Grande','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4022,'4107702','Fênix','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4023,'4107736','Fernandes Pinheiro','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4024,'4107751','Figueira','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4025,'4107801','Floraí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4026,'4107850','Flor da Serra do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4027,'4107900','Floresta','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4028,'4108007','Florestópolis','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4029,'4108106','Flórida','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4030,'4108205','Formosa do Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4031,'4108304','Foz do Iguaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4032,'4108320','Francisco Alves','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4033,'4108403','Francisco Beltrão','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4034,'4108452','Foz do Jordão','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4035,'4108502','General Carneiro','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4036,'4108551','Godoy Moreira','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4037,'4108601','Goioerê','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4038,'4108650','Goioxim','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4039,'4108700','Grandes Rios','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4040,'4108809','Guaíra','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4041,'4108908','Guairaçá','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4042,'4108957','Guamiranga','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4043,'4109005','Guapirama','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4044,'4109104','Guaporema','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4045,'4109203','Guaraci','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4046,'4109302','Guaraniaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4047,'4109401','Guarapuava','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4048,'4109500','Guaraqueçaba','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4049,'4109609','Guaratuba','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4050,'4109658','Honório Serpa','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4051,'4109708','Ibaiti','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4052,'4109757','Ibema','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4053,'4109807','Ibiporã','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4054,'4109906','Icaraíma','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4055,'4110003','Iguaraçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4056,'4110052','Iguatu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4057,'4110078','Imbaú','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4058,'4110102','Imbituva','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4059,'4110201','Inácio Martins','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4060,'4110300','Inajá','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4061,'4110409','Indianópolis','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4062,'4110508','Ipiranga','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4063,'4110607','Iporã','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4064,'4110656','Iracema do Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4065,'4110706','Irati','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4066,'4110805','Iretama','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4067,'4110904','Itaguajé','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4068,'4110953','Itaipulândia','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4069,'4111001','Itambaracá','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4070,'4111100','Itambé','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4071,'4111209','Itapejara D\'Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4072,'4111258','Itaperuçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4073,'4111308','Itaúna do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4074,'4111407','Ivaí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4075,'4111506','Ivaiporã','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4076,'4111555','Ivaté','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4077,'4111605','Ivatuba','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4078,'4111704','Jaboti','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4079,'4111803','Jacarezinho','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4080,'4111902','Jaguapitã','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4081,'4112009','Jaguariaíva','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4082,'4112108','Jandaia do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4083,'4112207','Janiópolis','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4084,'4112306','Japira','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4085,'4112405','Japurá','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4086,'4112504','Jardim Alegre','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4087,'4112603','Jardim Olinda','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4088,'4112702','Jataizinho','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4089,'4112751','Jesuítas','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4090,'4112801','Joaquim Távora','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4091,'4112900','Jundiaí do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4092,'4112959','Juranda','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4093,'4113007','Jussara','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4094,'4113106','Kaloré','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4095,'4113205','Lapa','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4096,'4113254','Laranjal','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4097,'4113304','Laranjeiras do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4098,'4113403','Leópolis','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4099,'4113429','Lidianópolis','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4100,'4113452','Lindoeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4101,'4113502','Loanda','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4102,'4113601','Lobato','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4103,'4113700','Londrina','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4104,'4113734','Luiziana','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4105,'4113759','Lunardelli','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4106,'4113809','Lupionópolis','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4107,'4113908','Mallet','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4108,'4114005','Mamborê','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4109,'4114104','Mandaguaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4110,'4114203','Mandaguari','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4111,'4114302','Mandirituba','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4112,'4114351','Manfrinópolis','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4113,'4114401','Mangueirinha','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4114,'4114500','Manoel Ribas','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4115,'4114609','Marechal Cândido Rondon','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4116,'4114708','Maria Helena','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4117,'4114807','Marialva','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4118,'4114906','Marilândia do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4119,'4115002','Marilena','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4120,'4115101','Mariluz','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4121,'4115200','Maringá','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4122,'4115309','Mariópolis','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4123,'4115358','Maripá','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4124,'4115408','Marmeleiro','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4125,'4115457','Marquinho','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4126,'4115507','Marumbi','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4127,'4115606','Matelândia','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4128,'4115705','Matinhos','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4129,'4115739','Mato Rico','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4130,'4115754','Mauá da Serra','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4131,'4115804','Medianeira','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4132,'4115853','Mercedes','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4133,'4115903','Mirador','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4134,'4116000','Miraselva','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4135,'4116059','Missal','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4136,'4116109','Moreira Sales','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4137,'4116208','Morretes','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4138,'4116307','Munhoz de Melo','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4139,'4116406','Nossa Senhora das Graças','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4140,'4116505','Nova Aliança do Ivaí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4141,'4116604','Nova América da Colina','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4142,'4116703','Nova Aurora','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4143,'4116802','Nova Cantu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4144,'4116901','Nova Esperança','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4145,'4116950','Nova Esperança do Sudoeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4146,'4117008','Nova Fátima','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4147,'4117057','Nova Laranjeiras','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4148,'4117107','Nova Londrina','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4149,'4117206','Nova Olímpia','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4150,'4117214','Nova Santa Bárbara','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4151,'4117222','Nova Santa Rosa','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4152,'4117255','Nova Prata do Iguaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4153,'4117271','Nova Tebas','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4154,'4117297','Novo Itacolomi','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4155,'4117305','Ortigueira','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4156,'4117404','Ourizona','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4157,'4117453','Ouro Verde do Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4158,'4117503','Paiçandu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4159,'4117602','Palmas','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4160,'4117701','Palmeira','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4161,'4117800','Palmital','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4162,'4117909','Palotina','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4163,'4118006','Paraíso do Norte','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4164,'4118105','Paranacity','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4165,'4118204','Paranaguá','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4166,'4118303','Paranapoema','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4167,'4118402','Paranavaí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4168,'4118451','Pato Bragado','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4169,'4118501','Pato Branco','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4170,'4118600','Paula Freitas','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4171,'4118709','Paulo Frontin','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4172,'4118808','Peabiru','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4173,'4118857','Perobal','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4174,'4118907','Pérola','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4175,'4119004','Pérola D\'Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4176,'4119103','Piên','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4177,'4119152','Pinhais','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4178,'4119202','Pinhalão','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4179,'4119251','Pinhal de São Bento','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4180,'4119301','Pinhão','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4181,'4119400','Piraí do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4182,'4119509','Piraquara','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4183,'4119608','Pitanga','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4184,'4119657','Pitangueiras','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4185,'4119707','Planaltina do Paraná','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4186,'4119806','Planalto','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4187,'4119905','Ponta Grossa','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4188,'4119954','Pontal do Paraná','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4189,'4120002','Porecatu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4190,'4120101','Porto Amazonas','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4191,'4120150','Porto Barreiro','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4192,'4120200','Porto Rico','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4193,'4120309','Porto Vitória','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4194,'4120333','Prado Ferreira','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4195,'4120358','Pranchita','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4196,'4120408','Presidente Castelo Branco','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4197,'4120507','Primeiro de Maio','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4198,'4120606','Prudentópolis','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4199,'4120655','Quarto Centenário','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4200,'4120705','Quatiguá','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4201,'4120804','Quatro Barras','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4202,'4120853','Quatro Pontes','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4203,'4120903','Quedas do Iguaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4204,'4121000','Querência do Norte','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4205,'4121109','Quinta do Sol','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4206,'4121208','Quitandinha','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4207,'4121257','Ramilândia','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4208,'4121307','Rancho Alegre','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4209,'4121356','Rancho Alegre D\'Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4210,'4121406','Realeza','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4211,'4121505','Rebouças','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4212,'4121604','Renascença','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4213,'4121703','Reserva','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4214,'4121752','Reserva do Iguaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4215,'4121802','Ribeirão Claro','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4216,'4121901','Ribeirão do Pinhal','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4217,'4122008','Rio Azul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4218,'4122107','Rio Bom','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4219,'4122156','Rio Bonito do Iguaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4220,'4122172','Rio Branco do Ivaí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4221,'4122206','Rio Branco do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4222,'4122305','Rio Negro','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4223,'4122404','Rolândia','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4224,'4122503','Roncador','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4225,'4122602','Rondon','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4226,'4122651','Rosário do Ivaí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4227,'4122701','Sabáudia','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4228,'4122800','Salgado Filho','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4229,'4122909','Salto do Itararé','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4230,'4123006','Salto do Lontra','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4231,'4123105','Santa Amélia','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4232,'4123204','Santa Cecília do Pavão','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4233,'4123303','Santa Cruz de Monte Castelo','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4234,'4123402','Santa Fé','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4235,'4123501','Santa Helena','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4236,'4123600','Santa Inês','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4237,'4123709','Santa Isabel do Ivaí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4238,'4123808','Santa Izabel do Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4239,'4123824','Santa Lúcia','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4240,'4123857','Santa Maria do Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4241,'4123907','Santa Mariana','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4242,'4123956','Santa Mônica','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4243,'4124004','Santana do Itararé','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4244,'4124020','Santa Tereza do Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4245,'4124053','Santa Terezinha de Itaipu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4246,'4124103','Santo Antônio da Platina','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4247,'4124202','Santo Antônio do Caiuá','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4248,'4124301','Santo Antônio do Paraíso','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4249,'4124400','Santo Antônio do Sudoeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4250,'4124509','Santo Inácio','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4251,'4124608','São Carlos do Ivaí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4252,'4124707','São Jerônimo da Serra','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4253,'4124806','São João','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4254,'4124905','São João do Caiuá','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4255,'4125001','São João do Ivaí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4256,'4125100','São João do Triunfo','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4257,'4125209','São Jorge D\'Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4258,'4125308','São Jorge do Ivaí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4259,'4125357','São Jorge do Patrocínio','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4260,'4125407','São José da Boa Vista','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4261,'4125456','São José das Palmeiras','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4262,'4125506','São José dos Pinhais','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4263,'4125555','São Manoel do Paraná','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4264,'4125605','São Mateus do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4265,'4125704','São Miguel do Iguaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4266,'4125753','São Pedro do Iguaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4267,'4125803','São Pedro do Ivaí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4268,'4125902','São Pedro do Paraná','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4269,'4126009','São Sebastião da Amoreira','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4270,'4126108','São Tomé','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4271,'4126207','Sapopema','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4272,'4126256','Sarandi','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4273,'4126272','Saudade do Iguaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4274,'4126306','Sengés','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4275,'4126355','Serranópolis do Iguaçu','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4276,'4126405','Sertaneja','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4277,'4126504','Sertanópolis','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4278,'4126603','Siqueira Campos','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4279,'4126652','Sulina','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4280,'4126678','Tamarana','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4281,'4126702','Tamboara','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4282,'4126801','Tapejara','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4283,'4126900','Tapira','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4284,'4127007','Teixeira Soares','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4285,'4127106','Telêmaco Borba','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4286,'4127205','Terra Boa','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4287,'4127304','Terra Rica','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4288,'4127403','Terra Roxa','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4289,'4127502','Tibagi','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4290,'4127601','Tijucas do Sul','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4291,'4127700','Toledo','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4292,'4127809','Tomazina','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4293,'4127858','Três Barras do Paraná','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4294,'4127882','Tunas do Paraná','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4295,'4127908','Tuneiras do Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4296,'4127957','Tupãssi','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4297,'4127965','Turvo','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4298,'4128005','Ubiratã','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4299,'4128104','Umuarama','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4300,'4128203','União da Vitória','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4301,'4128302','Uniflor','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4302,'4128401','Uraí','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4303,'4128500','Wenceslau Braz','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4304,'4128534','Ventania','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4305,'4128559','Vera Cruz do Oeste','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4306,'4128609','Verê','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4307,'4128625','Alto Paraíso','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4308,'4128633','Doutor Ulysses','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4309,'4128658','Virmond','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4310,'4128708','Vitorino','PR','2020-11-24 14:29:16','2020-11-24 14:29:16'),(4311,'4128807','Xambrê','PR','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4312,'4200051','Abdon Batista','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4313,'4200101','Abelardo Luz','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4314,'4200200','Agrolândia','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4315,'4200309','Agronômica','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4316,'4200408','Água Doce','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4317,'4200507','Águas de Chapecó','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4318,'4200556','Águas Frias','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4319,'4200606','Águas Mornas','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4320,'4200705','Alfredo Wagner','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4321,'4200754','Alto Bela Vista','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4322,'4200804','Anchieta','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4323,'4200903','Angelina','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4324,'4201000','Anita Garibaldi','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4325,'4201109','Anitápolis','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4326,'4201208','Antônio Carlos','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4327,'4201257','Apiúna','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4328,'4201273','Arabutã','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4329,'4201307','Araquari','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4330,'4201406','Araranguá','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4331,'4201505','Armazém','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4332,'4201604','Arroio Trinta','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4333,'4201653','Arvoredo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4334,'4201703','Ascurra','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4335,'4201802','Atalanta','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4336,'4201901','Aurora','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4337,'4201950','Balneário Arroio do Silva','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4338,'4202008','Balneário Camboriú','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4339,'4202057','Balneário Barra do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4340,'4202073','Balneário Gaivota','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4341,'4202081','Bandeirante','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4342,'4202099','Barra Bonita','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4343,'4202107','Barra Velha','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4344,'4202131','Bela Vista do Toldo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4345,'4202156','Belmonte','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4346,'4202206','Benedito Novo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4347,'4202305','Biguaçu','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4348,'4202404','Blumenau','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4349,'4202438','Bocaina do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4350,'4202453','Bombinhas','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4351,'4202503','Bom Jardim da Serra','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4352,'4202537','Bom Jesus','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4353,'4202578','Bom Jesus do Oeste','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4354,'4202602','Bom Retiro','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4355,'4202701','Botuverá','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4356,'4202800','Braço do Norte','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4357,'4202859','Braço do Trombudo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4358,'4202875','Brunópolis','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4359,'4202909','Brusque','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4360,'4203006','Caçador','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4361,'4203105','Caibi','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4362,'4203154','Calmon','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4363,'4203204','Camboriú','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4364,'4203253','Capão Alto','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4365,'4203303','Campo Alegre','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4366,'4203402','Campo Belo do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4367,'4203501','Campo Erê','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4368,'4203600','Campos Novos','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4369,'4203709','Canelinha','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4370,'4203808','Canoinhas','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4371,'4203907','Capinzal','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4372,'4203956','Capivari de Baixo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4373,'4204004','Catanduvas','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4374,'4204103','Caxambu do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4375,'4204152','Celso Ramos','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4376,'4204178','Cerro Negro','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4377,'4204194','Chapadão do Lageado','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4378,'4204202','Chapecó','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4379,'4204251','Cocal do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4380,'4204301','Concórdia','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4381,'4204350','Cordilheira Alta','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4382,'4204400','Coronel Freitas','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4383,'4204459','Coronel Martins','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4384,'4204509','Corupá','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4385,'4204558','Correia Pinto','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4386,'4204608','Criciúma','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4387,'4204707','Cunha Porã','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4388,'4204756','Cunhataí','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4389,'4204806','Curitibanos','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4390,'4204905','Descanso','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4391,'4205001','Dionísio Cerqueira','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4392,'4205100','Dona Emma','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4393,'4205159','Doutor Pedrinho','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4394,'4205175','Entre Rios','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4395,'4205191','Ermo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4396,'4205209','Erval Velho','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4397,'4205308','Faxinal dos Guedes','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4398,'4205357','Flor do Sertão','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4399,'4205407','Florianópolis','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4400,'4205431','Formosa do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4401,'4205456','Forquilhinha','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4402,'4205506','Fraiburgo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4403,'4205555','Frei Rogério','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4404,'4205605','Galvão','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4405,'4205704','Garopaba','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4406,'4205803','Garuva','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4407,'4205902','Gaspar','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4408,'4206009','Governador Celso Ramos','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4409,'4206108','Grão Pará','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4410,'4206207','Gravatal','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4411,'4206306','Guabiruba','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4412,'4206405','Guaraciaba','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4413,'4206504','Guaramirim','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4414,'4206603','Guarujá do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4415,'4206652','Guatambú','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4416,'4206702','Herval D\'Oeste','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4417,'4206751','Ibiam','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4418,'4206801','Ibicaré','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4419,'4206900','Ibirama','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4420,'4207007','Içara','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4421,'4207106','Ilhota','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4422,'4207205','Imaruí','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4423,'4207304','Imbituba','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4424,'4207403','Imbuia','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4425,'4207502','Indaial','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4426,'4207577','Iomerê','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4427,'4207601','Ipira','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4428,'4207650','Iporã do Oeste','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4429,'4207684','Ipuaçu','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4430,'4207700','Ipumirim','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4431,'4207759','Iraceminha','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4432,'4207809','Irani','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4433,'4207858','Irati','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4434,'4207908','Irineópolis','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4435,'4208005','Itá','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4436,'4208104','Itaiópolis','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4437,'4208203','Itajaí','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4438,'4208302','Itapema','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4439,'4208401','Itapiranga','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4440,'4208450','Itapoá','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4441,'4208500','Ituporanga','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4442,'4208609','Jaborá','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4443,'4208708','Jacinto Machado','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4444,'4208807','Jaguaruna','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4445,'4208906','Jaraguá do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4446,'4208955','Jardinópolis','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4447,'4209003','Joaçaba','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4448,'4209102','Joinville','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4449,'4209151','José Boiteux','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4450,'4209177','Jupiá','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4451,'4209201','Lacerdópolis','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4452,'4209300','Lages','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4453,'4209409','Laguna','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4454,'4209458','Lajeado Grande','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4455,'4209508','Laurentino','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4456,'4209607','Lauro Muller','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4457,'4209706','Lebon Régis','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4458,'4209805','Leoberto Leal','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4459,'4209854','Lindóia do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4460,'4209904','Lontras','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4461,'4210001','Luiz Alves','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4462,'4210035','Luzerna','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4463,'4210050','Macieira','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4464,'4210100','Mafra','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4465,'4210209','Major Gercino','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4466,'4210308','Major Vieira','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4467,'4210407','Maracajá','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4468,'4210506','Maravilha','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4469,'4210555','Marema','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4470,'4210605','Massaranduba','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4471,'4210704','Matos Costa','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4472,'4210803','Meleiro','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4473,'4210852','Mirim Doce','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4474,'4210902','Modelo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4475,'4211009','Mondaí','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4476,'4211058','Monte Carlo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4477,'4211108','Monte Castelo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4478,'4211207','Morro da Fumaça','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4479,'4211256','Morro Grande','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4480,'4211306','Navegantes','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4481,'4211405','Nova Erechim','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4482,'4211454','Nova Itaberaba','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4483,'4211504','Nova Trento','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4484,'4211603','Nova Veneza','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4485,'4211652','Novo Horizonte','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4486,'4211702','Orleans','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4487,'4211751','Otacílio Costa','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4488,'4211801','Ouro','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4489,'4211850','Ouro Verde','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4490,'4211876','Paial','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4491,'4211892','Painel','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4492,'4211900','Palhoça','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4493,'4212007','Palma Sola','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4494,'4212056','Palmeira','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4495,'4212106','Palmitos','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4496,'4212205','Papanduva','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4497,'4212239','Paraíso','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4498,'4212254','Passo de Torres','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4499,'4212270','Passos Maia','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4500,'4212304','Paulo Lopes','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4501,'4212403','Pedras Grandes','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4502,'4212502','Penha','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4503,'4212601','Peritiba','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4504,'4212650','Pescaria Brava','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4505,'4212700','Petrolândia','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4506,'4212809','Balneário Piçarras','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4507,'4212908','Pinhalzinho','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4508,'4213005','Pinheiro Preto','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4509,'4213104','Piratuba','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4510,'4213153','Planalto Alegre','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4511,'4213203','Pomerode','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4512,'4213302','Ponte Alta','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4513,'4213351','Ponte Alta do Norte','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4514,'4213401','Ponte Serrada','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4515,'4213500','Porto Belo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4516,'4213609','Porto União','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4517,'4213708','Pouso Redondo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4518,'4213807','Praia Grande','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4519,'4213906','Presidente Castello Branco','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4520,'4214003','Presidente Getúlio','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4521,'4214102','Presidente Nereu','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4522,'4214151','Princesa','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4523,'4214201','Quilombo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4524,'4214300','Rancho Queimado','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4525,'4214409','Rio das Antas','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4526,'4214508','Rio do Campo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4527,'4214607','Rio do Oeste','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4528,'4214706','Rio dos Cedros','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4529,'4214805','Rio do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4530,'4214904','Rio Fortuna','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4531,'4215000','Rio Negrinho','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4532,'4215059','Rio Rufino','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4533,'4215075','Riqueza','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4534,'4215109','Rodeio','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4535,'4215208','Romelândia','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4536,'4215307','Salete','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4537,'4215356','Saltinho','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4538,'4215406','Salto Veloso','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4539,'4215455','Sangão','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4540,'4215505','Santa Cecília','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4541,'4215554','Santa Helena','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4542,'4215604','Santa Rosa de Lima','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4543,'4215653','Santa Rosa do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4544,'4215679','Santa Terezinha','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4545,'4215687','Santa Terezinha do Progresso','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4546,'4215695','Santiago do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4547,'4215703','Santo Amaro da Imperatriz','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4548,'4215752','São Bernardino','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4549,'4215802','São Bento do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4550,'4215901','São Bonifácio','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4551,'4216008','São Carlos','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4552,'4216057','São Cristovão do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4553,'4216107','São Domingos','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4554,'4216206','São Francisco do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4555,'4216255','São João do Oeste','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4556,'4216305','São João Batista','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4557,'4216354','São João do Itaperiú','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4558,'4216404','São João do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4559,'4216503','São Joaquim','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4560,'4216602','São José','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4561,'4216701','São José do Cedro','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4562,'4216800','São José do Cerrito','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4563,'4216909','São Lourenço do Oeste','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4564,'4217006','São Ludgero','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4565,'4217105','São Martinho','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4566,'4217154','São Miguel da Boa Vista','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4567,'4217204','São Miguel do Oeste','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4568,'4217253','São Pedro de Alcântara','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4569,'4217303','Saudades','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4570,'4217402','Schroeder','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4571,'4217501','Seara','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4572,'4217550','Serra Alta','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4573,'4217600','Siderópolis','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4574,'4217709','Sombrio','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4575,'4217758','Sul Brasil','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4576,'4217808','Taió','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4577,'4217907','Tangará','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4578,'4217956','Tigrinhos','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4579,'4218004','Tijucas','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4580,'4218103','Timbé do Sul','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4581,'4218202','Timbó','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4582,'4218251','Timbó Grande','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4583,'4218301','Três Barras','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4584,'4218350','Treviso','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4585,'4218400','Treze de Maio','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4586,'4218509','Treze Tílias','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4587,'4218608','Trombudo Central','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4588,'4218707','Tubarão','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4589,'4218756','Tunápolis','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4590,'4218806','Turvo','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4591,'4218855','União do Oeste','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4592,'4218905','Urubici','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4593,'4218954','Urupema','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4594,'4219002','Urussanga','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4595,'4219101','Vargeão','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4596,'4219150','Vargem','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4597,'4219176','Vargem Bonita','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4598,'4219200','Vidal Ramos','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4599,'4219309','Videira','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4600,'4219358','Vitor Meireles','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4601,'4219408','Witmarsum','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4602,'4219507','Xanxerê','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4603,'4219606','Xavantina','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4604,'4219705','Xaxim','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4605,'4219853','Zortéa','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4606,'4220000','Balneário Rincão','SC','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4607,'4300034','Aceguá','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4608,'4300059','Água Santa','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4609,'4300109','Agudo','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4610,'4300208','Ajuricaba','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4611,'4300307','Alecrim','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4612,'4300406','Alegrete','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4613,'4300455','Alegria','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4614,'4300471','Almirante Tamandaré do Sul','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4615,'4300505','Alpestre','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4616,'4300554','Alto Alegre','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4617,'4300570','Alto Feliz','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4618,'4300604','Alvorada','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4619,'4300638','Amaral Ferrador','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4620,'4300646','Ametista do Sul','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4621,'4300661','André da Rocha','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4622,'4300703','Anta Gorda','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4623,'4300802','Antônio Prado','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4624,'4300851','Arambaré','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4625,'4300877','Araricá','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4626,'4300901','Aratiba','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4627,'4301008','Arroio do Meio','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4628,'4301057','Arroio do Sal','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4629,'4301073','Arroio do Padre','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4630,'4301107','Arroio dos Ratos','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4631,'4301206','Arroio do Tigre','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4632,'4301305','Arroio Grande','RS','2020-11-24 14:29:17','2020-11-24 14:29:17'),(4633,'4301404','Arvorezinha','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4634,'4301503','Augusto Pestana','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4635,'4301552','Áurea','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4636,'4301602','Bagé','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4637,'4301636','Balneário Pinhal','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4638,'4301651','Barão','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4639,'4301701','Barão de Cotegipe','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4640,'4301750','Barão do Triunfo','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4641,'4301800','Barracão','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4642,'4301859','Barra do Guarita','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4643,'4301875','Barra do Quaraí','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4644,'4301909','Barra do Ribeiro','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4645,'4301925','Barra do Rio Azul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4646,'4301958','Barra Funda','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4647,'4302006','Barros Cassal','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4648,'4302055','Benjamin Constant do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4649,'4302105','Bento Gonçalves','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4650,'4302154','Boa Vista das Missões','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4651,'4302204','Boa Vista do Buricá','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4652,'4302220','Boa Vista do Cadeado','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4653,'4302238','Boa Vista do Incra','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4654,'4302253','Boa Vista do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4655,'4302303','Bom Jesus','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4656,'4302352','Bom Princípio','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4657,'4302378','Bom Progresso','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4658,'4302402','Bom Retiro do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4659,'4302451','Boqueirão do Leão','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4660,'4302501','Bossoroca','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4661,'4302584','Bozano','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4662,'4302600','Braga','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4663,'4302659','Brochier','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4664,'4302709','Butiá','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4665,'4302808','Caçapava do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4666,'4302907','Cacequi','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4667,'4303004','Cachoeira do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4668,'4303103','Cachoeirinha','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4669,'4303202','Cacique Doble','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4670,'4303301','Caibaté','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4671,'4303400','Caiçara','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4672,'4303509','Camaquã','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4673,'4303558','Camargo','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4674,'4303608','Cambará do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4675,'4303673','Campestre da Serra','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4676,'4303707','Campina das Missões','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4677,'4303806','Campinas do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4678,'4303905','Campo Bom','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4679,'4304002','Campo Novo','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4680,'4304101','Campos Borges','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4681,'4304200','Candelária','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4682,'4304309','Cândido Godói','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4683,'4304358','Candiota','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4684,'4304408','Canela','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4685,'4304507','Canguçu','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4686,'4304606','Canoas','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4687,'4304614','Canudos do Vale','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4688,'4304622','Capão Bonito do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4689,'4304630','Capão da Canoa','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4690,'4304655','Capão do Cipó','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4691,'4304663','Capão do Leão','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4692,'4304671','Capivari do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4693,'4304689','Capela de Santana','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4694,'4304697','Capitão','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4695,'4304705','Carazinho','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4696,'4304713','Caraá','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4697,'4304804','Carlos Barbosa','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4698,'4304853','Carlos Gomes','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4699,'4304903','Casca','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4700,'4304952','Caseiros','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4701,'4305009','Catuípe','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4702,'4305108','Caxias do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4703,'4305116','Centenário','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4704,'4305124','Cerrito','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4705,'4305132','Cerro Branco','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4706,'4305157','Cerro Grande','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4707,'4305173','Cerro Grande do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4708,'4305207','Cerro Largo','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4709,'4305306','Chapada','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4710,'4305355','Charqueadas','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4711,'4305371','Charrua','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4712,'4305405','Chiapetta','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4713,'4305439','Chuí','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4714,'4305447','Chuvisca','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4715,'4305454','Cidreira','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4716,'4305504','Ciríaco','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4717,'4305587','Colinas','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4718,'4305603','Colorado','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4719,'4305702','Condor','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4720,'4305801','Constantina','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4721,'4305835','Coqueiro Baixo','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4722,'4305850','Coqueiros do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4723,'4305871','Coronel Barros','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4724,'4305900','Coronel Bicaco','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4725,'4305934','Coronel Pilar','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4726,'4305959','Cotiporã','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4727,'4305975','Coxilha','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4728,'4306007','Crissiumal','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4729,'4306056','Cristal','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4730,'4306072','Cristal do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4731,'4306106','Cruz Alta','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4732,'4306130','Cruzaltense','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4733,'4306205','Cruzeiro do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4734,'4306304','David Canabarro','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4735,'4306320','Derrubadas','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4736,'4306353','Dezesseis de Novembro','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4737,'4306379','Dilermando de Aguiar','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4738,'4306403','Dois Irmãos','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4739,'4306429','Dois Irmãos das Missões','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4740,'4306452','Dois Lajeados','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4741,'4306502','Dom Feliciano','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4742,'4306551','Dom Pedro de Alcântara','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4743,'4306601','Dom Pedrito','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4744,'4306700','Dona Francisca','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4745,'4306734','Doutor Maurício Cardoso','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4746,'4306759','Doutor Ricardo','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4747,'4306767','Eldorado do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4748,'4306809','Encantado','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4749,'4306908','Encruzilhada do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4750,'4306924','Engenho Velho','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4751,'4306932','Entre-Ijuís','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4752,'4306957','Entre Rios do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4753,'4306973','Erebango','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4754,'4307005','Erechim','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4755,'4307054','Ernestina','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4756,'4307104','Herval','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4757,'4307203','Erval Grande','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4758,'4307302','Erval Seco','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4759,'4307401','Esmeralda','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4760,'4307450','Esperança do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4761,'4307500','Espumoso','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4762,'4307559','Estação','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4763,'4307609','Estância Velha','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4764,'4307708','Esteio','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4765,'4307807','Estrela','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4766,'4307815','Estrela Velha','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4767,'4307831','Eugênio de Castro','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4768,'4307864','Fagundes Varela','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4769,'4307906','Farroupilha','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4770,'4308003','Faxinal do Soturno','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4771,'4308052','Faxinalzinho','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4772,'4308078','Fazenda Vilanova','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4773,'4308102','Feliz','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4774,'4308201','Flores da Cunha','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4775,'4308250','Floriano Peixoto','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4776,'4308300','Fontoura Xavier','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4777,'4308409','Formigueiro','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4778,'4308433','Forquetinha','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4779,'4308458','Fortaleza dos Valos','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4780,'4308508','Frederico Westphalen','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4781,'4308607','Garibaldi','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4782,'4308656','Garruchos','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4783,'4308706','Gaurama','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4784,'4308805','General Câmara','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4785,'4308854','Gentil','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4786,'4308904','Getúlio Vargas','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4787,'4309001','Giruá','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4788,'4309050','Glorinha','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4789,'4309100','Gramado','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4790,'4309126','Gramado dos Loureiros','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4791,'4309159','Gramado Xavier','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4792,'4309209','Gravataí','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4793,'4309258','Guabiju','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4794,'4309308','Guaíba','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4795,'4309407','Guaporé','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4796,'4309506','Guarani das Missões','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4797,'4309555','Harmonia','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4798,'4309571','Herveiras','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4799,'4309605','Horizontina','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4800,'4309654','Hulha Negra','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4801,'4309704','Humaitá','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4802,'4309753','Ibarama','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4803,'4309803','Ibiaçá','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4804,'4309902','Ibiraiaras','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4805,'4309951','Ibirapuitã','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4806,'4310009','Ibirubá','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4807,'4310108','Igrejinha','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4808,'4310207','Ijuí','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4809,'4310306','Ilópolis','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4810,'4310330','Imbé','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4811,'4310363','Imigrante','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4812,'4310405','Independência','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4813,'4310413','Inhacorá','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4814,'4310439','Ipê','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4815,'4310462','Ipiranga do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4816,'4310504','Iraí','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4817,'4310538','Itaara','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4818,'4310553','Itacurubi','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4819,'4310579','Itapuca','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4820,'4310603','Itaqui','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4821,'4310652','Itati','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4822,'4310702','Itatiba do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4823,'4310751','Ivorá','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4824,'4310801','Ivoti','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4825,'4310850','Jaboticaba','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4826,'4310876','Jacuizinho','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4827,'4310900','Jacutinga','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4828,'4311007','Jaguarão','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4829,'4311106','Jaguari','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4830,'4311122','Jaquirana','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4831,'4311130','Jari','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4832,'4311155','Jóia','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4833,'4311205','Júlio de Castilhos','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4834,'4311239','Lagoa Bonita do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4835,'4311254','Lagoão','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4836,'4311270','Lagoa dos Três Cantos','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4837,'4311304','Lagoa Vermelha','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4838,'4311403','Lajeado','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4839,'4311429','Lajeado do Bugre','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4840,'4311502','Lavras do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4841,'4311601','Liberato Salzano','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4842,'4311627','Lindolfo Collor','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4843,'4311643','Linha Nova','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4844,'4311700','Machadinho','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4845,'4311718','Maçambará','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4846,'4311734','Mampituba','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4847,'4311759','Manoel Viana','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4848,'4311775','Maquiné','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4849,'4311791','Maratá','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4850,'4311809','Marau','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4851,'4311908','Marcelino Ramos','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4852,'4311981','Mariana Pimentel','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4853,'4312005','Mariano Moro','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4854,'4312054','Marques de Souza','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4855,'4312104','Mata','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4856,'4312138','Mato Castelhano','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4857,'4312153','Mato Leitão','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4858,'4312179','Mato Queimado','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4859,'4312203','Maximiliano de Almeida','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4860,'4312252','Minas do Leão','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4861,'4312302','Miraguaí','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4862,'4312351','Montauri','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4863,'4312377','Monte Alegre dos Campos','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4864,'4312385','Monte Belo do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4865,'4312401','Montenegro','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4866,'4312427','Mormaço','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4867,'4312443','Morrinhos do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4868,'4312450','Morro Redondo','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4869,'4312476','Morro Reuter','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4870,'4312500','Mostardas','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4871,'4312609','Muçum','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4872,'4312617','Muitos Capões','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4873,'4312625','Muliterno','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4874,'4312658','Não-Me-Toque','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4875,'4312674','Nicolau Vergueiro','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4876,'4312708','Nonoai','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4877,'4312757','Nova Alvorada','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4878,'4312807','Nova Araçá','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4879,'4312906','Nova Bassano','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4880,'4312955','Nova Boa Vista','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4881,'4313003','Nova Bréscia','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4882,'4313011','Nova Candelária','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4883,'4313037','Nova Esperança do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4884,'4313060','Nova Hartz','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4885,'4313086','Nova Pádua','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4886,'4313102','Nova Palma','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4887,'4313201','Nova Petrópolis','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4888,'4313300','Nova Prata','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4889,'4313334','Nova Ramada','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4890,'4313359','Nova Roma do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4891,'4313375','Nova Santa Rita','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4892,'4313391','Novo Cabrais','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4893,'4313409','Novo Hamburgo','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4894,'4313425','Novo Machado','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4895,'4313441','Novo Tiradentes','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4896,'4313466','Novo Xingu','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4897,'4313490','Novo Barreiro','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4898,'4313508','Osório','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4899,'4313607','Paim Filho','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4900,'4313656','Palmares do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4901,'4313706','Palmeira das Missões','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4902,'4313805','Palmitinho','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4903,'4313904','Panambi','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4904,'4313953','Pantano Grande','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4905,'4314001','Paraí','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4906,'4314027','Paraíso do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4907,'4314035','Pareci Novo','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4908,'4314050','Parobé','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4909,'4314068','Passa Sete','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4910,'4314076','Passo do Sobrado','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4911,'4314100','Passo Fundo','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4912,'4314134','Paulo Bento','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4913,'4314159','Paverama','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4914,'4314175','Pedras Altas','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4915,'4314209','Pedro Osório','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4916,'4314308','Pejuçara','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4917,'4314407','Pelotas','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4918,'4314423','Picada Café','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4919,'4314456','Pinhal','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4920,'4314464','Pinhal da Serra','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4921,'4314472','Pinhal Grande','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4922,'4314498','Pinheirinho do Vale','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4923,'4314506','Pinheiro Machado','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4924,'4314548','Pinto Bandeira','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4925,'4314555','Pirapó','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4926,'4314605','Piratini','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4927,'4314704','Planalto','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4928,'4314753','Poço das Antas','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4929,'4314779','Pontão','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4930,'4314787','Ponte Preta','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4931,'4314803','Portão','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4932,'4314902','Porto Alegre','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4933,'4315008','Porto Lucena','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4934,'4315057','Porto Mauá','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4935,'4315073','Porto Vera Cruz','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4936,'4315107','Porto Xavier','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4937,'4315131','Pouso Novo','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4938,'4315149','Presidente Lucena','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4939,'4315156','Progresso','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4940,'4315172','Protásio Alves','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4941,'4315206','Putinga','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4942,'4315305','Quaraí','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4943,'4315313','Quatro Irmãos','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4944,'4315321','Quevedos','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4945,'4315354','Quinze de Novembro','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4946,'4315404','Redentora','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4947,'4315453','Relvado','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4948,'4315503','Restinga Seca','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4949,'4315552','Rio dos Índios','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4950,'4315602','Rio Grande','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4951,'4315701','Rio Pardo','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4952,'4315750','Riozinho','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4953,'4315800','Roca Sales','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4954,'4315909','Rodeio Bonito','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4955,'4315958','Rolador','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4956,'4316006','Rolante','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4957,'4316105','Ronda Alta','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4958,'4316204','Rondinha','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4959,'4316303','Roque Gonzales','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4960,'4316402','Rosário do Sul','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4961,'4316428','Sagrada Família','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4962,'4316436','Saldanha Marinho','RS','2020-11-24 14:29:18','2020-11-24 14:29:18'),(4963,'4316451','Salto do Jacuí','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4964,'4316477','Salvador das Missões','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4965,'4316501','Salvador do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4966,'4316600','Sananduva','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4967,'4316709','Santa Bárbara do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4968,'4316733','Santa Cecília do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4969,'4316758','Santa Clara do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4970,'4316808','Santa Cruz do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4971,'4316907','Santa Maria','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4972,'4316956','Santa Maria do Herval','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4973,'4316972','Santa Margarida do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4974,'4317004','Santana da Boa Vista','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4975,'4317103','Sant\'Ana do Livramento','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4976,'4317202','Santa Rosa','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4977,'4317251','Santa Tereza','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4978,'4317301','Santa Vitória do Palmar','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4979,'4317400','Santiago','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4980,'4317509','Santo Ângelo','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4981,'4317558','Santo Antônio do Palma','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4982,'4317608','Santo Antônio da Patrulha','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4983,'4317707','Santo Antônio das Missões','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4984,'4317756','Santo Antônio do Planalto','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4985,'4317806','Santo Augusto','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4986,'4317905','Santo Cristo','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4987,'4317954','Santo Expedito do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4988,'4318002','São Borja','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4989,'4318051','São Domingos do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4990,'4318101','São Francisco de Assis','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4991,'4318200','São Francisco de Paula','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4992,'4318309','São Gabriel','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4993,'4318408','São Jerônimo','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4994,'4318424','São João da Urtiga','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4995,'4318432','São João do Polêsine','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4996,'4318440','São Jorge','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4997,'4318457','São José das Missões','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4998,'4318465','São José do Herval','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(4999,'4318481','São José do Hortêncio','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5000,'4318499','São José do Inhacorá','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5001,'4318507','São José do Norte','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5002,'4318606','São José do Ouro','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5003,'4318614','São José do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5004,'4318622','São José dos Ausentes','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5005,'4318705','São Leopoldo','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5006,'4318804','São Lourenço do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5007,'4318903','São Luiz Gonzaga','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5008,'4319000','São Marcos','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5009,'4319109','São Martinho','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5010,'4319125','São Martinho da Serra','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5011,'4319158','São Miguel das Missões','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5012,'4319208','São Nicolau','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5013,'4319307','São Paulo das Missões','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5014,'4319356','São Pedro da Serra','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5015,'4319364','São Pedro das Missões','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5016,'4319372','São Pedro do Butiá','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5017,'4319406','São Pedro do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5018,'4319505','São Sebastião do Caí','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5019,'4319604','São Sepé','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5020,'4319703','São Valentim','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5021,'4319711','São Valentim do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5022,'4319737','São Valério do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5023,'4319752','São Vendelino','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5024,'4319802','São Vicente do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5025,'4319901','Sapiranga','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5026,'4320008','Sapucaia do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5027,'4320107','Sarandi','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5028,'4320206','Seberi','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5029,'4320230','Sede Nova','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5030,'4320263','Segredo','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5031,'4320305','Selbach','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5032,'4320321','Senador Salgado Filho','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5033,'4320354','Sentinela do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5034,'4320404','Serafina Corrêa','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5035,'4320453','Sério','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5036,'4320503','Sertão','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5037,'4320552','Sertão Santana','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5038,'4320578','Sete de Setembro','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5039,'4320602','Severiano de Almeida','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5040,'4320651','Silveira Martins','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5041,'4320677','Sinimbu','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5042,'4320701','Sobradinho','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5043,'4320800','Soledade','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5044,'4320859','Tabaí','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5045,'4320909','Tapejara','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5046,'4321006','Tapera','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5047,'4321105','Tapes','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5048,'4321204','Taquara','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5049,'4321303','Taquari','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5050,'4321329','Taquaruçu do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5051,'4321352','Tavares','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5052,'4321402','Tenente Portela','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5053,'4321436','Terra de Areia','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5054,'4321451','Teutônia','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5055,'4321469','Tio Hugo','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5056,'4321477','Tiradentes do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5057,'4321493','Toropi','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5058,'4321501','Torres','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5059,'4321600','Tramandaí','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5060,'4321626','Travesseiro','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5061,'4321634','Três Arroios','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5062,'4321667','Três Cachoeiras','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5063,'4321709','Três Coroas','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5064,'4321808','Três de Maio','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5065,'4321832','Três Forquilhas','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5066,'4321857','Três Palmeiras','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5067,'4321907','Três Passos','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5068,'4321956','Trindade do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5069,'4322004','Triunfo','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5070,'4322103','Tucunduva','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5071,'4322152','Tunas','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5072,'4322186','Tupanci do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5073,'4322202','Tupanciretã','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5074,'4322251','Tupandi','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5075,'4322301','Tuparendi','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5076,'4322327','Turuçu','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5077,'4322343','Ubiretama','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5078,'4322350','União da Serra','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5079,'4322376','Unistalda','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5080,'4322400','Uruguaiana','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5081,'4322509','Vacaria','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5082,'4322525','Vale Verde','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5083,'4322533','Vale do Sol','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5084,'4322541','Vale Real','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5085,'4322558','Vanini','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5086,'4322608','Venâncio Aires','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5087,'4322707','Vera Cruz','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5088,'4322806','Veranópolis','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5089,'4322855','Vespasiano Correa','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5090,'4322905','Viadutos','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5091,'4323002','Viamão','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5092,'4323101','Vicente Dutra','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5093,'4323200','Victor Graeff','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5094,'4323309','Vila Flores','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5095,'4323358','Vila Lângaro','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5096,'4323408','Vila Maria','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5097,'4323457','Vila Nova do Sul','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5098,'4323507','Vista Alegre','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5099,'4323606','Vista Alegre do Prata','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5100,'4323705','Vista Gaúcha','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5101,'4323754','Vitória das Missões','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5102,'4323770','Westfalia','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5103,'4323804','Xangri-lá','RS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5104,'5000203','Água Clara','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5105,'5000252','Alcinópolis','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5106,'5000609','Amambai','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5107,'5000708','Anastácio','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5108,'5000807','Anaurilândia','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5109,'5000856','Angélica','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5110,'5000906','Antônio João','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5111,'5001003','Aparecida do Taboado','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5112,'5001102','Aquidauana','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5113,'5001243','Aral Moreira','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5114,'5001508','Bandeirantes','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5115,'5001904','Bataguassu','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5116,'5002001','Batayporã','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5117,'5002100','Bela Vista','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5118,'5002159','Bodoquena','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5119,'5002209','Bonito','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5120,'5002308','Brasilândia','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5121,'5002407','Caarapó','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5122,'5002605','Camapuã','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5123,'5002704','Campo Grande','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5124,'5002803','Caracol','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5125,'5002902','Cassilândia','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5126,'5002951','Chapadão do Sul','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5127,'5003108','Corguinho','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5128,'5003157','Coronel Sapucaia','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5129,'5003207','Corumbá','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5130,'5003256','Costa Rica','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5131,'5003306','Coxim','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5132,'5003454','Deodápolis','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5133,'5003488','Dois Irmãos do Buriti','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5134,'5003504','Douradina','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5135,'5003702','Dourados','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5136,'5003751','Eldorado','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5137,'5003801','Fátima do Sul','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5138,'5003900','Figueirão','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5139,'5004007','Glória de Dourados','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5140,'5004106','Guia Lopes da Laguna','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5141,'5004304','Iguatemi','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5142,'5004403','Inocência','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5143,'5004502','Itaporã','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5144,'5004601','Itaquiraí','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5145,'5004700','Ivinhema','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5146,'5004809','Japorã','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5147,'5004908','Jaraguari','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5148,'5005004','Jardim','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5149,'5005103','Jateí','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5150,'5005152','Juti','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5151,'5005202','Ladário','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5152,'5005251','Laguna Carapã','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5153,'5005400','Maracaju','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5154,'5005608','Miranda','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5155,'5005681','Mundo Novo','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5156,'5005707','Naviraí','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5157,'5005806','Nioaque','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5158,'5006002','Nova Alvorada do Sul','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5159,'5006200','Nova Andradina','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5160,'5006259','Novo Horizonte do Sul','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5161,'5006275','Paraíso das Águas','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5162,'5006309','Paranaíba','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5163,'5006358','Paranhos','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5164,'5006408','Pedro Gomes','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5165,'5006606','Ponta Porã','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5166,'5006903','Porto Murtinho','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5167,'5007109','Ribas do Rio Pardo','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5168,'5007208','Rio Brilhante','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5169,'5007307','Rio Negro','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5170,'5007406','Rio Verde de Mato Grosso','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5171,'5007505','Rochedo','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5172,'5007554','Santa Rita do Pardo','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5173,'5007695','São Gabriel do Oeste','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5174,'5007703','Sete Quedas','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5175,'5007802','Selvíria','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5176,'5007901','Sidrolândia','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5177,'5007935','Sonora','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5178,'5007950','Tacuru','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5179,'5007976','Taquarussu','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5180,'5008008','Terenos','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5181,'5008305','Três Lagoas','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5182,'5008404','Vicentina','MS','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5183,'5100102','Acorizal','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5184,'5100201','Água Boa','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5185,'5100250','Alta Floresta','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5186,'5100300','Alto Araguaia','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5187,'5100359','Alto Boa Vista','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5188,'5100409','Alto Garças','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5189,'5100508','Alto Paraguai','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5190,'5100607','Alto Taquari','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5191,'5100805','Apiacás','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5192,'5101001','Araguaiana','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5193,'5101209','Araguainha','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5194,'5101258','Araputanga','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5195,'5101308','Arenápolis','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5196,'5101407','Aripuanã','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5197,'5101605','Barão de Melgaço','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5198,'5101704','Barra do Bugres','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5199,'5101803','Barra do Garças','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5200,'5101852','Bom Jesus do Araguaia','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5201,'5101902','Brasnorte','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5202,'5102504','Cáceres','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5203,'5102603','Campinápolis','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5204,'5102637','Campo Novo do Parecis','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5205,'5102678','Campo Verde','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5206,'5102686','Campos de Júlio','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5207,'5102694','Canabrava do Norte','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5208,'5102702','Canarana','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5209,'5102793','Carlinda','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5210,'5102850','Castanheira','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5211,'5103007','Chapada dos Guimarães','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5212,'5103056','Cláudia','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5213,'5103106','Cocalinho','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5214,'5103205','Colíder','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5215,'5103254','Colniza','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5216,'5103304','Comodoro','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5217,'5103353','Confresa','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5218,'5103361','Conquista D\'Oeste','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5219,'5103379','Cotriguaçu','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5220,'5103403','Cuiabá','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5221,'5103437','Curvelândia','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5222,'5103452','Denise','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5223,'5103502','Diamantino','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5224,'5103601','Dom Aquino','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5225,'5103700','Feliz Natal','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5226,'5103809','Figueirópolis D\'Oeste','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5227,'5103858','Gaúcha do Norte','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5228,'5103908','General Carneiro','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5229,'5103957','Glória D\'Oeste','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5230,'5104104','Guarantã do Norte','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5231,'5104203','Guiratinga','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5232,'5104500','Indiavaí','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5233,'5104526','Ipiranga do Norte','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5234,'5104542','Itanhangá','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5235,'5104559','Itaúba','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5236,'5104609','Itiquira','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5237,'5104807','Jaciara','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5238,'5104906','Jangada','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5239,'5105002','Jauru','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5240,'5105101','Juara','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5241,'5105150','Juína','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5242,'5105176','Juruena','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5243,'5105200','Juscimeira','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5244,'5105234','Lambari D\'Oeste','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5245,'5105259','Lucas do Rio Verde','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5246,'5105309','Luciara','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5247,'5105507','Vila Bela da Santíssima Trindade','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5248,'5105580','Marcelândia','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5249,'5105606','Matupá','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5250,'5105622','Mirassol D\'Oeste','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5251,'5105903','Nobres','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5252,'5106000','Nortelândia','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5253,'5106109','Nossa Senhora do Livramento','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5254,'5106158','Nova Bandeirantes','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5255,'5106174','Nova Nazaré','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5256,'5106182','Nova Lacerda','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5257,'5106190','Nova Santa Helena','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5258,'5106208','Nova Brasilândia','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5259,'5106216','Nova Canaã do Norte','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5260,'5106224','Nova Mutum','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5261,'5106232','Nova Olímpia','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5262,'5106240','Nova Ubiratã','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5263,'5106257','Nova Xavantina','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5264,'5106265','Novo Mundo','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5265,'5106273','Novo Horizonte do Norte','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5266,'5106281','Novo São Joaquim','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5267,'5106299','Paranaíta','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5268,'5106307','Paranatinga','MT','2020-11-24 14:29:19','2020-11-24 14:29:19'),(5269,'5106315','Novo Santo Antônio','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5270,'5106372','Pedra Preta','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5271,'5106422','Peixoto de Azevedo','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5272,'5106455','Planalto da Serra','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5273,'5106505','Poconé','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5274,'5106653','Pontal do Araguaia','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5275,'5106703','Ponte Branca','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5276,'5106752','Pontes e Lacerda','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5277,'5106778','Porto Alegre do Norte','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5278,'5106802','Porto dos Gaúchos','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5279,'5106828','Porto Esperidião','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5280,'5106851','Porto Estrela','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5281,'5107008','Poxoréo','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5282,'5107040','Primavera do Leste','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5283,'5107065','Querência','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5284,'5107107','São José dos Quatro Marcos','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5285,'5107156','Reserva do Cabaçal','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5286,'5107180','Ribeirão Cascalheira','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5287,'5107198','Ribeirãozinho','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5288,'5107206','Rio Branco','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5289,'5107248','Santa Carmem','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5290,'5107263','Santo Afonso','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5291,'5107297','São José do Povo','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5292,'5107305','São José do Rio Claro','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5293,'5107354','São José do Xingu','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5294,'5107404','São Pedro da Cipa','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5295,'5107578','Rondolândia','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5296,'5107602','Rondonópolis','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5297,'5107701','Rosário Oeste','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5298,'5107743','Santa Cruz do Xingu','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5299,'5107750','Salto do Céu','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5300,'5107768','Santa Rita do Trivelato','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5301,'5107776','Santa Terezinha','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5302,'5107792','Santo Antônio do Leste','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5303,'5107800','Santo Antônio do Leverger','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5304,'5107859','São Félix do Araguaia','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5305,'5107875','Sapezal','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5306,'5107883','Serra Nova Dourada','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5307,'5107909','Sinop','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5308,'5107925','Sorriso','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5309,'5107941','Tabaporã','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5310,'5107958','Tangará da Serra','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5311,'5108006','Tapurah','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5312,'5108055','Terra Nova do Norte','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5313,'5108105','Tesouro','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5314,'5108204','Torixoréu','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5315,'5108303','União do Sul','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5316,'5108352','Vale de São Domingos','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5317,'5108402','Várzea Grande','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5318,'5108501','Vera','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5319,'5108600','Vila Rica','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5320,'5108808','Nova Guarita','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5321,'5108857','Nova Marilândia','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5322,'5108907','Nova Maringá','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5323,'5108956','Nova Monte Verde','MT','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5324,'5200050','Abadia de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5325,'5200100','Abadiânia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5326,'5200134','Acreúna','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5327,'5200159','Adelândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5328,'5200175','Água Fria de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5329,'5200209','Água Limpa','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5330,'5200258','Águas Lindas de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5331,'5200308','Alexânia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5332,'5200506','Aloândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5333,'5200555','Alto Horizonte','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5334,'5200605','Alto Paraíso de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5335,'5200803','Alvorada do Norte','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5336,'5200829','Amaralina','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5337,'5200852','Americano do Brasil','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5338,'5200902','Amorinópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5339,'5201108','Anápolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5340,'5201207','Anhanguera','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5341,'5201306','Anicuns','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5342,'5201405','Aparecida de Goiânia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5343,'5201454','Aparecida do Rio Doce','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5344,'5201504','Aporé','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5345,'5201603','Araçu','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5346,'5201702','Aragarças','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5347,'5201801','Aragoiânia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5348,'5202155','Araguapaz','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5349,'5202353','Arenópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5350,'5202502','Aruanã','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5351,'5202601','Aurilândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5352,'5202809','Avelinópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5353,'5203104','Baliza','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5354,'5203203','Barro Alto','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5355,'5203302','Bela Vista de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5356,'5203401','Bom Jardim de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5357,'5203500','Bom Jesus de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5358,'5203559','Bonfinópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5359,'5203575','Bonópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5360,'5203609','Brazabrantes','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5361,'5203807','Britânia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5362,'5203906','Buriti Alegre','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5363,'5203939','Buriti de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5364,'5203962','Buritinópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5365,'5204003','Cabeceiras','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5366,'5204102','Cachoeira Alta','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5367,'5204201','Cachoeira de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5368,'5204250','Cachoeira Dourada','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5369,'5204300','Caçu','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5370,'5204409','Caiapônia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5371,'5204508','Caldas Novas','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5372,'5204557','Caldazinha','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5373,'5204607','Campestre de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5374,'5204656','Campinaçu','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5375,'5204706','Campinorte','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5376,'5204805','Campo Alegre de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5377,'5204854','Campo Limpo de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5378,'5204904','Campos Belos','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5379,'5204953','Campos Verdes','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5380,'5205000','Carmo do Rio Verde','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5381,'5205059','Castelândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5382,'5205109','Catalão','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5383,'5205208','Caturaí','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5384,'5205307','Cavalcante','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5385,'5205406','Ceres','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5386,'5205455','Cezarina','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5387,'5205471','Chapadão do Céu','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5388,'5205497','cidades Ocidental','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5389,'5205513','Cocalzinho de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5390,'5205521','Colinas do Sul','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5391,'5205703','Córrego do Ouro','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5392,'5205802','Corumbá de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5393,'5205901','Corumbaíba','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5394,'5206206','Cristalina','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5395,'5206305','Cristianópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5396,'5206404','Crixás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5397,'5206503','Cromínia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5398,'5206602','Cumari','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5399,'5206701','Damianópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5400,'5206800','Damolândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5401,'5206909','Davinópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5402,'5207105','Diorama','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5403,'5207253','Doverlândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5404,'5207352','Edealina','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5405,'5207402','Edéia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5406,'5207501','Estrela do Norte','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5407,'5207535','Faina','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5408,'5207600','Fazenda Nova','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5409,'5207808','Firminópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5410,'5207907','Flores de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5411,'5208004','Formosa','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5412,'5208103','Formoso','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5413,'5208152','Gameleira de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5414,'5208301','Divinópolis de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5415,'5208400','Goianápolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5416,'5208509','Goiandira','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5417,'5208608','Goianésia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5418,'5208707','Goiânia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5419,'5208806','Goianira','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5420,'5208905','Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5421,'5209101','Goiatuba','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5422,'5209150','Gouvelândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5423,'5209200','Guapó','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5424,'5209291','Guaraíta','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5425,'5209408','Guarani de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5426,'5209457','Guarinos','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5427,'5209606','Heitoraí','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5428,'5209705','Hidrolândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5429,'5209804','Hidrolina','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5430,'5209903','Iaciara','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5431,'5209937','Inaciolândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5432,'5209952','Indiara','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5433,'5210000','Inhumas','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5434,'5210109','Ipameri','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5435,'5210158','Ipiranga de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5436,'5210208','Iporá','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5437,'5210307','Israelândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5438,'5210406','Itaberaí','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5439,'5210562','Itaguari','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5440,'5210604','Itaguaru','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5441,'5210802','Itajá','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5442,'5210901','Itapaci','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5443,'5211008','Itapirapuã','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5444,'5211206','Itapuranga','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5445,'5211305','Itarumã','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5446,'5211404','Itauçu','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5447,'5211503','Itumbiara','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5448,'5211602','Ivolândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5449,'5211701','Jandaia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5450,'5211800','Jaraguá','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5451,'5211909','Jataí','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5452,'5212006','Jaupaci','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5453,'5212055','Jesúpolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5454,'5212105','Joviânia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5455,'5212204','Jussara','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5456,'5212253','Lagoa Santa','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5457,'5212303','Leopoldo de Bulhões','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5458,'5212501','Luziânia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5459,'5212600','Mairipotaba','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5460,'5212709','Mambaí','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5461,'5212808','Mara Rosa','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5462,'5212907','Marzagão','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5463,'5212956','Matrinchã','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5464,'5213004','Maurilândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5465,'5213053','Mimoso de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5466,'5213087','Minaçu','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5467,'5213103','Mineiros','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5468,'5213400','Moiporá','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5469,'5213509','Monte Alegre de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5470,'5213707','Montes Claros de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5471,'5213756','Montividiu','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5472,'5213772','Montividiu do Norte','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5473,'5213806','Morrinhos','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5474,'5213855','Morro Agudo de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5475,'5213905','Mossâmedes','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5476,'5214002','Mozarlândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5477,'5214051','Mundo Novo','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5478,'5214101','Mutunópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5479,'5214408','Nazário','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5480,'5214507','Nerópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5481,'5214606','Niquelândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5482,'5214705','Nova América','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5483,'5214804','Nova Aurora','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5484,'5214838','Nova Crixás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5485,'5214861','Nova Glória','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5486,'5214879','Nova Iguaçu de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5487,'5214903','Nova Roma','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5488,'5215009','Nova Veneza','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5489,'5215207','Novo Brasil','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5490,'5215231','Novo Gama','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5491,'5215256','Novo Planalto','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5492,'5215306','Orizona','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5493,'5215405','Ouro Verde de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5494,'5215504','Ouvidor','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5495,'5215603','Padre Bernardo','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5496,'5215652','Palestina de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5497,'5215702','Palmeiras de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5498,'5215801','Palmelo','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5499,'5215900','Palminópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5500,'5216007','Panamá','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5501,'5216304','Paranaiguara','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5502,'5216403','Paraúna','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5503,'5216452','Perolândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5504,'5216809','Petrolina de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5505,'5216908','Pilar de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5506,'5217104','Piracanjuba','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5507,'5217203','Piranhas','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5508,'5217302','Pirenópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5509,'5217401','Pires do Rio','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5510,'5217609','Planaltina','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5511,'5217708','Pontalina','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5512,'5218003','Porangatu','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5513,'5218052','Porteirão','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5514,'5218102','Portelândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5515,'5218300','Posse','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5516,'5218391','Professor Jamil','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5517,'5218508','Quirinópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5518,'5218607','Rialma','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5519,'5218706','Rianápolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5520,'5218789','Rio Quente','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5521,'5218805','Rio Verde','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5522,'5218904','Rubiataba','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5523,'5219001','Sanclerlândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5524,'5219100','Santa Bárbara de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5525,'5219209','Santa Cruz de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5526,'5219258','Santa Fé de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5527,'5219308','Santa Helena de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5528,'5219357','Santa Isabel','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5529,'5219407','Santa Rita do Araguaia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5530,'5219456','Santa Rita do Novo Destino','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5531,'5219506','Santa Rosa de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5532,'5219605','Santa Tereza de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5533,'5219704','Santa Terezinha de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5534,'5219712','Santo Antônio da Barra','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5535,'5219738','Santo Antônio de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5536,'5219753','Santo Antônio do Descoberto','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5537,'5219803','São Domingos','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5538,'5219902','São Francisco de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5539,'5220009','São João D\'Aliança','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5540,'5220058','São João da Paraúna','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5541,'5220108','São Luís de Montes Belos','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5542,'5220157','São Luíz do Norte','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5543,'5220207','São Miguel do Araguaia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5544,'5220264','São Miguel do Passa Quatro','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5545,'5220280','São Patrício','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5546,'5220405','São Simão','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5547,'5220454','Senador Canedo','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5548,'5220504','Serranópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5549,'5220603','Silvânia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5550,'5220686','Simolândia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5551,'5220702','Sítio D\'Abadia','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5552,'5221007','Taquaral de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5553,'5221080','Teresina de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5554,'5221197','Terezópolis de Goiás','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5565,'5221908','Varjão','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5566,'5222005','Vianópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5567,'5222054','Vicentinópolis','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5568,'5222203','Vila Boa','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5569,'5222302','Vila Propício','GO','2020-11-24 14:29:20','2020-11-24 14:29:20'),(5570,'5300108','Brasília','DF','2020-11-24 14:29:20','2020-11-24 14:29:20');
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `componente_ctes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `componente_ctes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nome` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor` decimal(10,4) NOT NULL,
  `cte_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `componente_ctes_cte_id_foreign` (`cte_id`),
  CONSTRAINT `componente_ctes_cte_id_foreign` FOREIGN KEY (`cte_id`) REFERENCES `ctes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `componente_ctes` WRITE;
/*!40000 ALTER TABLE `componente_ctes` DISABLE KEYS */;
/*!40000 ALTER TABLE `componente_ctes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `city_id` int(10) unsigned NOT NULL,
  `cpf_cnpj` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ie_rg` varchar(18) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `consumidor_final` int(11) NOT NULL DEFAULT 1,
  `contribuinte` int(11) NOT NULL DEFAULT 1,
  `rua` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bairro` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cep` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_business_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landmark` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landline` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `total_rp` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `shipping_address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_city_id_foreign` (`city_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,1,NULL,NULL,1,1,NULL,NULL,NULL,NULL,'customer',NULL,'Cliente padrão',NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,1,0,0,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(2,2,1,NULL,NULL,1,1,NULL,NULL,NULL,NULL,'customer',NULL,'Cliente padrão',NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,2,0,0,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(3,3,1,NULL,NULL,1,1,NULL,NULL,NULL,NULL,'customer',NULL,'Cliente padrão',NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,3,0,0,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(5,5,3068,NULL,NULL,1,1,'Floriano Peixoto','1000','Aparecida','38300000','customer','Algar','Algar Telecom',NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,5,0,0,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-02-03 13:03:51','2021-02-03 13:23:08');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ctes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `chave_nfe` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remetente_id` int(10) unsigned NOT NULL,
  `destinatario_id` int(10) unsigned NOT NULL,
  `usuario_id` int(10) unsigned NOT NULL,
  `natureza_id` int(10) unsigned NOT NULL,
  `tomador` int(11) NOT NULL,
  `municipio_envio` int(10) unsigned NOT NULL,
  `municipio_inicio` int(10) unsigned NOT NULL,
  `municipio_fim` int(10) unsigned NOT NULL,
  `logradouro_tomador` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_tomador` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bairro_tomador` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cep_tomador` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `municipio_tomador` int(10) unsigned DEFAULT NULL,
  `valor_transporte` decimal(10,2) NOT NULL,
  `valor_receber` decimal(10,2) NOT NULL,
  `valor_carga` decimal(10,2) NOT NULL,
  `produto_predominante` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_previsata_entrega` date NOT NULL,
  `observacao` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequencia_cce` int(11) NOT NULL,
  `cte_numero` int(11) NOT NULL DEFAULT 0,
  `chave` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path_xml` varchar(51) COLLATE utf8mb4_unicode_ci NOT NULL,
  `estado` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_registro` timestamp NOT NULL DEFAULT current_timestamp(),
  `retira` tinyint(1) NOT NULL,
  `detalhes_retira` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `modal` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `veiculo_id` int(10) unsigned NOT NULL,
  `tpDoc` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descOutros` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nDoc` int(11) NOT NULL,
  `vDocFisc` decimal(10,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctes_business_id_foreign` (`business_id`),
  KEY `ctes_remetente_id_foreign` (`remetente_id`),
  KEY `ctes_destinatario_id_foreign` (`destinatario_id`),
  KEY `ctes_usuario_id_foreign` (`usuario_id`),
  KEY `ctes_natureza_id_foreign` (`natureza_id`),
  KEY `ctes_municipio_envio_foreign` (`municipio_envio`),
  KEY `ctes_municipio_inicio_foreign` (`municipio_inicio`),
  KEY `ctes_municipio_fim_foreign` (`municipio_fim`),
  KEY `ctes_municipio_tomador_foreign` (`municipio_tomador`),
  KEY `ctes_veiculo_id_foreign` (`veiculo_id`),
  CONSTRAINT `ctes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ctes_destinatario_id_foreign` FOREIGN KEY (`destinatario_id`) REFERENCES `contacts` (`id`),
  CONSTRAINT `ctes_municipio_envio_foreign` FOREIGN KEY (`municipio_envio`) REFERENCES `cities` (`id`),
  CONSTRAINT `ctes_municipio_fim_foreign` FOREIGN KEY (`municipio_fim`) REFERENCES `cities` (`id`),
  CONSTRAINT `ctes_municipio_inicio_foreign` FOREIGN KEY (`municipio_inicio`) REFERENCES `cities` (`id`),
  CONSTRAINT `ctes_municipio_tomador_foreign` FOREIGN KEY (`municipio_tomador`) REFERENCES `cities` (`id`),
  CONSTRAINT `ctes_natureza_id_foreign` FOREIGN KEY (`natureza_id`) REFERENCES `natureza_operacaos` (`id`),
  CONSTRAINT `ctes_remetente_id_foreign` FOREIGN KEY (`remetente_id`) REFERENCES `contacts` (`id`),
  CONSTRAINT `ctes_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ctes_veiculo_id_foreign` FOREIGN KEY (`veiculo_id`) REFERENCES `veiculos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ctes` WRITE;
/*!40000 ALTER TABLE `ctes` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousand_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=141 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$','.',',',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHC','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NG','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(5,2) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`),
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `devolucaos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `devolucaos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `natureza_id` int(10) unsigned NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `valor_integral` decimal(10,2) NOT NULL,
  `valor_devolvido` decimal(10,2) NOT NULL,
  `motivo` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `estado` int(11) NOT NULL,
  `devolucao_parcial` tinyint(1) NOT NULL,
  `chave_nf_entrada` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nNf` int(11) NOT NULL,
  `vFrete` decimal(10,2) NOT NULL,
  `vDesc` decimal(10,2) NOT NULL,
  `chave_gerada` varchar(44) COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_gerado` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `devolucaos_contact_id_foreign` (`contact_id`),
  KEY `devolucaos_natureza_id_foreign` (`natureza_id`),
  KEY `devolucaos_business_id_foreign` (`business_id`),
  CONSTRAINT `devolucaos_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `devolucaos_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`),
  CONSTRAINT `devolucaos_natureza_id_foreign` FOREIGN KEY (`natureza_id`) REFERENCES `natureza_operacaos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `devolucaos` WRITE;
/*!40000 ALTER TABLE `devolucaos` DISABLE KEYS */;
/*!40000 ALTER TABLE `devolucaos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `applicable_in_spg` tinyint(1) DEFAULT 0,
  `applicable_in_cg` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_text` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `round_off_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_due_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT 0,
  `client_id_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_time_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT 1,
  `show_brand` tinyint(1) NOT NULL DEFAULT 0,
  `show_sku` tinyint(1) NOT NULL DEFAULT 1,
  `show_cat_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `show_lot` tinyint(1) NOT NULL DEFAULT 0,
  `show_image` tinyint(1) NOT NULL DEFAULT 0,
  `show_sale_description` tinyint(1) NOT NULL DEFAULT 0,
  `sales_person_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT 0,
  `table_product_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_qty_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_unit_price_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_subtotal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_code_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT 0,
  `show_business_name` tinyint(1) NOT NULL DEFAULT 0,
  `show_location_name` tinyint(1) NOT NULL DEFAULT 1,
  `show_landmark` tinyint(1) NOT NULL DEFAULT 1,
  `show_city` tinyint(1) NOT NULL DEFAULT 1,
  `show_state` tinyint(1) NOT NULL DEFAULT 1,
  `show_zip_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_country` tinyint(1) NOT NULL DEFAULT 1,
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT 1,
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT 0,
  `show_email` tinyint(1) NOT NULL DEFAULT 0,
  `show_tax_1` tinyint(1) NOT NULL DEFAULT 1,
  `show_tax_2` tinyint(1) NOT NULL DEFAULT 0,
  `show_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `show_payments` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer` tinyint(1) NOT NULL DEFAULT 0,
  `customer_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_reward_point` tinyint(1) NOT NULL DEFAULT 0,
  `highlight_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_text` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module_info` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `common_settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `business_id` int(10) unsigned NOT NULL,
  `design` varchar(190) COLLATE utf8mb4_unicode_ci DEFAULT 'classic',
  `cn_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cn_amount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_tax_headings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT 0,
  `prev_bal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `change_return_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_fields` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_custom_fields` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_custom_fields` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',0,'#000000','',NULL,NULL,1,1,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(2,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',0,'#000000','',NULL,NULL,1,2,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(3,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',0,'#000000','',NULL,NULL,1,3,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(5,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',0,'#000000','',NULL,NULL,1,5,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2021-02-03 13:03:51','2021-02-03 13:03:51');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheme_type` enum('blank','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT 0,
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','',1,0,4,1,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(2,2,'Default','blank','',1,2,4,1,'2020-12-29 17:51:34','2020-12-29 20:28:51'),(3,3,'Default','blank','',1,0,4,1,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(5,5,'Default','blank','',1,0,4,1,'2021-02-03 13:03:51','2021-02-03 13:03:51');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `item_devolucaos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `item_devolucaos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cod` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ncm` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cfop` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codBarras` varchar(13) COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor_unit` decimal(10,2) NOT NULL,
  `quantidade` decimal(8,2) NOT NULL,
  `item_parcial` tinyint(1) NOT NULL,
  `unidade_medida` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `devolucao_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_devolucaos_devolucao_id_foreign` (`devolucao_id`),
  CONSTRAINT `item_devolucaos_devolucao_id_foreign` FOREIGN KEY (`devolucao_id`) REFERENCES `devolucaos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `item_devolucaos` WRITE;
/*!40000 ALTER TABLE `item_devolucaos` DISABLE KEYS */;
/*!40000 ALTER TABLE `item_devolucaos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `item_dves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `item_dves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `numero_nfe` int(11) NOT NULL,
  `produto_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_dves_business_id_foreign` (`business_id`),
  CONSTRAINT `item_dves_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `item_dves` WRITE;
/*!40000 ALTER TABLE `item_dves` DISABLE KEYS */;
/*!40000 ALTER TABLE `item_dves` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `manifesto_limites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `manifesto_limites` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `manifesto_limites_business_id_foreign` (`business_id`),
  CONSTRAINT `manifesto_limites_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `manifesto_limites` WRITE;
/*!40000 ALTER TABLE `manifesto_limites` DISABLE KEYS */;
/*!40000 ALTER TABLE `manifesto_limites` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `manifestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `manifestos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `chave` varchar(44) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  `num_prot` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_emissao` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequencia_evento` int(11) NOT NULL,
  `fatura_salva` tinyint(1) NOT NULL,
  `tipo` int(11) NOT NULL,
  `nsu` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `manifestos_business_id_foreign` (`business_id`),
  CONSTRAINT `manifestos_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `manifestos` WRITE;
/*!40000 ALTER TABLE `manifestos` DISABLE KEYS */;
/*!40000 ALTER TABLE `manifestos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
INSERT INTO `media` VALUES (1,1,'1609256831_585363396_Bruno_200_200.png',NULL,1,'App\\User',1,'2020-12-29 16:47:11','2020-12-29 16:47:11');
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `medida_ctes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `medida_ctes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cod_unidade` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_medida` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantidade_carga` decimal(10,4) NOT NULL,
  `cte_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `medida_ctes_cte_id_foreign` (`cte_id`),
  CONSTRAINT `medida_ctes_cte_id_foreign` FOREIGN KEY (`cte_id`) REFERENCES `ctes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `medida_ctes` WRITE;
/*!40000 ALTER TABLE `medida_ctes` DISABLE KEYS */;
/*!40000 ALTER TABLE `medida_ctes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=255 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_003455_create_cities_table',1),(3,'2014_10_12_100000_create_password_resets_table',1),(4,'2017_07_05_071953_create_currencies_table',1),(5,'2017_07_05_073658_create_business_table',1),(6,'2017_07_05_074333_create_natureza_operacaos_table',1),(7,'2017_07_22_075923_add_business_id_users_table',1),(8,'2017_07_23_113209_create_brands_table',1),(9,'2017_07_26_083429_create_permission_tables',1),(10,'2017_07_26_110000_create_tax_rates_table',1),(11,'2017_07_26_122313_create_units_table',1),(12,'2017_07_27_075706_create_contacts_table',1),(13,'2017_08_04_071038_create_categories_table',1),(14,'2017_08_08_115903_create_products_table',1),(15,'2017_08_09_061616_create_variation_templates_table',1),(16,'2017_08_09_061638_create_variation_value_templates_table',1),(17,'2017_08_10_061146_create_product_variations_table',1),(18,'2017_08_10_061216_create_variations_table',1),(19,'2017_08_18_054827_create_transportadoras_table',1),(20,'2017_08_19_054827_create_transactions_table',1),(21,'2017_08_31_073533_create_purchase_lines_table',1),(22,'2017_10_15_064638_create_transaction_payments_table',1),(23,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(24,'2017_11_20_051930_create_table_group_sub_taxes',1),(25,'2017_11_20_063603_create_transaction_sell_lines',1),(26,'2017_11_21_064540_create_barcodes_table',1),(27,'2017_11_23_181237_create_invoice_schemes_table',1),(28,'2017_12_25_122822_create_business_locations_table',1),(29,'2017_12_25_160253_add_location_id_to_transactions_table',1),(30,'2017_12_25_163227_create_variation_location_details_table',1),(31,'2018_01_04_115627_create_sessions_table',1),(32,'2018_01_05_112817_create_invoice_layouts_table',1),(33,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(34,'2018_01_08_104124_create_expense_categories_table',1),(35,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(36,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(37,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(38,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(39,'2018_01_27_184322_create_printers_table',1),(40,'2018_01_30_181442_create_cash_registers_table',1),(41,'2018_01_31_125836_create_cash_register_transactions_table',1),(42,'2018_02_07_173326_modify_business_table',1),(43,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(44,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(45,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(46,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(47,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(48,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(49,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(50,'2018_02_13_183323_alter_decimal_fields_size',1),(51,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(52,'2018_02_15_161032_add_document_column_to_transactions_table',1),(53,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(54,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(55,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(56,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(57,'2018_02_21_105329_create_system_table',1),(58,'2018_02_23_100549_version_1_2',1),(59,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(60,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(61,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(62,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(63,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(64,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(65,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(66,'2018_03_06_210206_modify_product_barcode_types',1),(67,'2018_03_13_181541_add_expiry_type_to_business_table',1),(68,'2018_03_16_113446_product_expiry_setting_for_business',1),(69,'2018_03_19_113601_add_business_settings_options',1),(70,'2018_03_26_125334_add_pos_settings_to_business_table',1),(71,'2018_03_26_165350_create_customer_groups_table',1),(72,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(73,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(74,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(75,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(76,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(77,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(78,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(79,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(80,'2018_04_17_123122_add_lot_number_to_business',1),(81,'2018_04_17_160845_add_product_racks_table',1),(82,'2018_04_20_182015_create_res_tables_table',1),(83,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(84,'2018_04_24_114149_add_enabled_modules_business_table',1),(85,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(86,'2018_04_27_132653_quotation_related_change',1),(87,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(88,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(89,'2018_05_14_114027_add_rows_positions_for_products',1),(90,'2018_05_14_125223_add_weight_to_products_table',1),(91,'2018_05_14_164754_add_opening_stock_permission',1),(92,'2018_05_15_134729_add_design_to_invoice_layouts',1),(93,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(94,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(95,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(96,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(97,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(98,'2018_05_22_123527_create_reference_counts_table',1),(99,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(100,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(101,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(102,'2018_05_25_180603_create_modifiers_related_table',1),(103,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(104,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(105,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(106,'2018_06_05_111905_modify_products_table_for_modifiers',1),(107,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(108,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(109,'2018_06_07_182258_add_image_field_to_products_table',1),(110,'2018_06_13_133705_create_bookings_table',1),(111,'2018_06_15_173636_add_email_column_to_contacts_table',1),(112,'2018_06_27_182835_add_superadmin_related_fields_business',1),(113,'2018_06_27_185405_create_packages_table',1),(114,'2018_06_28_182803_create_subscriptions_table',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_17_182021_add_rows_to_system_table',1),(119,'2018_07_19_131721_add_options_to_packages_table',1),(120,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(121,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(122,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(123,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(124,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(125,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(126,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(127,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(128,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(129,'2018_08_17_155534_add_min_termination_alert_days',1),(130,'2018_08_28_105945_add_business_based_username_settings_to_system_table',1),(131,'2018_08_30_105906_add_superadmin_communicator_logs_table',1),(132,'2018_09_04_155900_create_accounts_table',1),(133,'2018_09_06_114438_create_selling_price_groups_table',1),(134,'2018_09_06_154057_create_variation_group_prices_table',1),(135,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(136,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(137,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(138,'2018_09_10_152703_create_account_transactions_table',1),(139,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(140,'2018_09_19_123914_create_notification_templates_table',1),(141,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(142,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(143,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(144,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(145,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(146,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(147,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(148,'2018_10_03_185947_add_default_notification_templates_to_database',1),(149,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(150,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(151,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(152,'2018_10_22_134428_modify_variable_product_data',1),(153,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(154,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(155,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(156,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(157,'2018_10_31_175627_add_user_contact_access',1),(158,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(159,'2018_11_02_130636_add_custom_permissions_to_packages_table',1),(160,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(161,'2018_11_05_161848_add_more_fields_to_packages_table',1),(162,'2018_11_08_105621_add_role_permissions',1),(163,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(164,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(165,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(166,'2018_11_29_115918_add_primary_key_in_system_table',1),(167,'2018_12_03_185546_add_product_description_column_to_products_table',1),(168,'2018_12_06_114937_modify_system_table_and_users_table',1),(169,'2018_12_10_124621_modify_system_table_values_null_default',1),(170,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(171,'2018_12_14_103307_modify_system_table',1),(172,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(173,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(174,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(175,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(176,'2018_12_24_154933_create_notifications_table',1),(177,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(178,'2019_01_10_124645_add_account_permission',1),(179,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(180,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(181,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(182,'2019_02_19_103118_create_discounts_table',1),(183,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(184,'2019_02_21_134324_add_permission_for_discount',1),(185,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(186,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(187,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(188,'2019_03_12_120336_create_activity_log_table',1),(189,'2019_03_15_132925_create_media_table',1),(190,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(191,'2019_05_10_132311_add_missing_column_indexing',1),(192,'2019_05_10_135434_add_missing_database_column_indexes',1),(193,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(194,'2019_05_25_104922_add_view_purchase_price_permission',1),(195,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(196,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(197,'2019_06_19_112058_add_database_changes_for_reward_points',1),(198,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(199,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(200,'2019_07_15_165136_add_fields_for_combo_product',1),(201,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(202,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(203,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(204,'2019_08_08_162302_add_sub_units_related_fields',1),(205,'2019_08_16_115300_create_superadmin_frontend_pages_table',1),(206,'2019_08_26_133419_update_price_fields_decimal_point',1),(207,'2019_09_02_160054_remove_location_permissions_from_roles',1),(208,'2019_09_03_185259_add_permission_for_pos_screen',1),(209,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(210,'2019_09_04_184008_create_types_of_services_table',1),(211,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(212,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(213,'2019_09_12_105616_create_product_locations_table',1),(214,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(215,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(216,'2019_09_19_170927_close_all_active_registers',1),(217,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(218,'2019_10_18_155633_create_account_types_table',1),(219,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(220,'2019_10_29_132521_add_update_purchase_status_permission',1),(221,'2019_11_09_110522_add_indexing_to_lot_number',1),(222,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(223,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(224,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(225,'2019_12_02_105025_create_warranties_table',1),(226,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(227,'2019_12_05_183955_add_more_fields_to_users_table',1),(228,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(229,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(230,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(231,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(232,'2019_12_25_173413_create_dashboard_configurations_table',1),(233,'2020_01_08_133506_create_document_and_notes_table',1),(234,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(235,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(236,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(237,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(238,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(239,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(240,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(241,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(242,'2020_04_15_151802_add_user_type_to_users_table',1),(243,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(244,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(245,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(246,'2020_08_16_154813_create_devolucaos_table',1),(247,'2020_08_16_155443_create_item_devolucaos_table',1),(248,'2020_11_14_143711_create_veiculos_table',1),(249,'2020_11_15_142315_create_ctes_table',1),(250,'2020_11_15_142325_create_componente_ctes_table',1),(251,'2020_11_15_142337_create_medida_ctes_table',1),(252,'2020_11_21_090013_create_manifestos_table',1),(253,'2020_11_21_090053_create_manifesto_limites_table',1),(254,'2020_11_21_090341_create_item_dves_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1),(3,'App\\User',2),(5,'App\\User',3),(9,'App\\User',5);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `natureza_operacaos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `natureza_operacaos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `natureza` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cfop_entrada_estadual` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfop_entrada_inter_estadual` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfop_saida_estadual` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfop_saida_inter_estadual` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `business_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `natureza_operacaos_business_id_foreign` (`business_id`),
  CONSTRAINT `natureza_operacaos_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `natureza_operacaos` WRITE;
/*!40000 ALTER TABLE `natureza_operacaos` DISABLE KEYS */;
/*!40000 ALTER TABLE `natureza_operacaos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_body` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sms_body` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bcc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',NULL,NULL,0,0,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}','Payment Received, from {business_name}',NULL,NULL,0,0,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',NULL,NULL,0,0,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',NULL,NULL,0,0,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',NULL,NULL,0,0,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',NULL,NULL,0,0,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',NULL,NULL,0,0,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',NULL,NULL,0,0,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(9,2,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',NULL,NULL,0,0,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(10,2,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}','Payment Received, from {business_name}',NULL,NULL,0,0,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(11,2,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',NULL,NULL,0,0,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(12,2,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',NULL,NULL,0,0,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(13,2,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',NULL,NULL,0,0,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(14,2,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',NULL,NULL,0,0,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(15,2,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',NULL,NULL,0,0,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(16,2,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',NULL,NULL,0,0,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(17,3,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',NULL,NULL,0,0,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(18,3,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}','Payment Received, from {business_name}',NULL,NULL,0,0,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(19,3,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',NULL,NULL,0,0,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(20,3,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',NULL,NULL,0,0,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(21,3,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',NULL,NULL,0,0,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(22,3,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',NULL,NULL,0,0,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(23,3,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',NULL,NULL,0,0,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(24,3,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',NULL,NULL,0,0,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(25,4,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',NULL,NULL,0,0,'2021-02-03 12:31:15','2021-02-03 12:31:15'),(26,4,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}','Payment Received, from {business_name}',NULL,NULL,0,0,'2021-02-03 12:31:15','2021-02-03 12:31:15'),(27,4,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',NULL,NULL,0,0,'2021-02-03 12:31:15','2021-02-03 12:31:15'),(28,4,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',NULL,NULL,0,0,'2021-02-03 12:31:15','2021-02-03 12:31:15'),(29,4,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',NULL,NULL,0,0,'2021-02-03 12:31:15','2021-02-03 12:31:15'),(30,4,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',NULL,NULL,0,0,'2021-02-03 12:31:15','2021-02-03 12:31:15'),(31,4,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',NULL,NULL,0,0,'2021-02-03 12:31:15','2021-02-03 12:31:15'),(32,4,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',NULL,NULL,0,0,'2021-02-03 12:31:15','2021-02-03 12:31:15'),(33,5,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',NULL,NULL,0,0,'2021-02-03 13:03:51','2021-02-03 13:03:51'),(34,5,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}','Payment Received, from {business_name}',NULL,NULL,0,0,'2021-02-03 13:03:51','2021-02-03 13:03:51'),(35,5,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',NULL,NULL,0,0,'2021-02-03 13:03:51','2021-02-03 13:03:51'),(36,5,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',NULL,NULL,0,0,'2021-02-03 13:03:51','2021-02-03 13:03:51'),(37,5,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',NULL,NULL,0,0,'2021-02-03 13:03:51','2021-02-03 13:03:51'),(38,5,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',NULL,NULL,0,0,'2021-02-03 13:03:51','2021-02-03 13:03:51'),(39,5,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',NULL,NULL,0,0,'2021-02-03 13:03:51','2021-02-03 13:03:51'),(40,5,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',NULL,NULL,0,0,'2021-02-03 13:03:51','2021-02-03 13:03:51');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_count` int(11) NOT NULL COMMENT 'No. of Business Locations, 0 = infinite option.',
  `user_count` int(11) NOT NULL,
  `product_count` int(11) NOT NULL,
  `bookings` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable bookings',
  `kitchen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable kitchen',
  `order_screen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable order_screen',
  `tables` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable tables',
  `invoice_count` int(11) NOT NULL,
  `interval` enum('days','months','years') COLLATE utf8mb4_unicode_ci NOT NULL,
  `interval_count` int(11) NOT NULL,
  `trial_days` int(11) NOT NULL,
  `price` decimal(22,4) NOT NULL,
  `custom_permissions` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `is_one_time` tinyint(1) NOT NULL DEFAULT 0,
  `enable_custom_link` tinyint(1) NOT NULL DEFAULT 0,
  `custom_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_link_text` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` VALUES (1,'Teste 7 dias','Plano de demonstração por 7 dias',1,1,10,0,0,0,0,3,'days',7,0,0.0000,'',1,1,0,0,0,0,'','',NULL,'2020-12-29 16:30:38','2021-01-08 20:40:16'),(2,'Básico','Emissão de notas fiscais, gerenciamento de estoques e controles básicos.',1,5,100,0,0,0,0,20,'months',30,0,49.9000,'',1,1,0,0,0,0,'','',NULL,'2020-12-29 16:33:05','2022-10-27 23:11:06'),(3,'Intermediário','Plano Básico + Gerenciamento de compras, vendas e finanças.',2,5,150,0,0,0,0,50,'months',30,0,79.9000,'',1,1,0,0,0,0,'','',NULL,'2020-12-29 16:34:58','2021-01-08 20:40:37'),(4,'Master','Plano Básico + Plano Intermediário + Automações para melhor eficiência da operação.',2,10,200,0,0,0,0,100,'months',30,0,90.0000,'',1,1,0,0,0,0,'','',NULL,'2020-12-29 16:35:58','2021-01-08 20:40:50'),(5,'Admin','Adminstradores',1000,100,100000,0,0,0,0,100000,'years',2,0,0.0000,'',1,1,1,1,0,0,'','',NULL,'2020-12-29 16:44:23','2021-01-08 20:41:16'),(6,'Teste Homologação','Teste Homologação',2,3,50,0,0,0,0,50,'months',1,0,0.0000,'',1,1,1,1,0,0,'','',NULL,'2020-12-29 18:05:55','2020-12-29 18:05:55'),(7,'Super Master','Alto volume de pedidos e Indústrias.',10,30,1000,0,0,0,0,10000,'months',1,7,500.0000,'',1,5,0,0,0,0,'','',NULL,'2020-12-30 21:15:34','2021-01-08 20:41:32');
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2020-11-24 14:28:39',NULL),(2,'direct_sell.access','web','2020-11-24 14:28:39',NULL),(3,'product.opening_stock','web','2020-11-24 14:28:45','2020-11-24 14:28:45'),(4,'crud_all_bookings','web','2020-11-24 14:28:46','2020-11-24 14:28:46'),(5,'crud_own_bookings','web','2020-11-24 14:28:46','2020-11-24 14:28:46'),(6,'access_default_selling_price','web','2020-11-24 14:28:48','2020-11-24 14:28:48'),(7,'purchase.payments','web','2020-11-24 14:28:50','2020-11-24 14:28:50'),(8,'sell.payments','web','2020-11-24 14:28:50','2020-11-24 14:28:50'),(9,'edit_product_price_from_sale_screen','web','2020-11-24 14:28:50','2020-11-24 14:28:50'),(10,'edit_product_discount_from_sale_screen','web','2020-11-24 14:28:50','2020-11-24 14:28:50'),(11,'roles.view','web','2020-11-24 14:28:50','2020-11-24 14:28:50'),(12,'roles.create','web','2020-11-24 14:28:50','2020-11-24 14:28:50'),(13,'roles.update','web','2020-11-24 14:28:50','2020-11-24 14:28:50'),(14,'roles.delete','web','2020-11-24 14:28:50','2020-11-24 14:28:50'),(15,'account.access','web','2020-11-24 14:28:51','2020-11-24 14:28:51'),(16,'discount.access','web','2020-11-24 14:28:51','2020-11-24 14:28:51'),(17,'view_purchase_price','web','2020-11-24 14:28:52','2020-11-24 14:28:52'),(18,'view_own_sell_only','web','2020-11-24 14:28:52','2020-11-24 14:28:52'),(19,'edit_product_discount_from_pos_screen','web','2020-11-24 14:28:54','2020-11-24 14:28:54'),(20,'edit_product_price_from_pos_screen','web','2020-11-24 14:28:54','2020-11-24 14:28:54'),(21,'access_shipping','web','2020-11-24 14:28:55','2020-11-24 14:28:55'),(22,'purchase.update_status','web','2020-11-24 14:28:56','2020-11-24 14:28:56'),(23,'list_drafts','web','2020-11-24 14:28:57','2020-11-24 14:28:57'),(24,'list_quotations','web','2020-11-24 14:28:57','2020-11-24 14:28:57'),(25,'user.view','web','2020-11-24 14:29:01',NULL),(26,'user.create','web','2020-11-24 14:29:01',NULL),(27,'user.update','web','2020-11-24 14:29:01',NULL),(28,'user.delete','web','2020-11-24 14:29:01',NULL),(29,'supplier.view','web','2020-11-24 14:29:01',NULL),(30,'supplier.create','web','2020-11-24 14:29:01',NULL),(31,'supplier.update','web','2020-11-24 14:29:01',NULL),(32,'supplier.delete','web','2020-11-24 14:29:01',NULL),(33,'customer.view','web','2020-11-24 14:29:01',NULL),(34,'customer.create','web','2020-11-24 14:29:01',NULL),(35,'customer.update','web','2020-11-24 14:29:01',NULL),(36,'customer.delete','web','2020-11-24 14:29:01',NULL),(37,'product.view','web','2020-11-24 14:29:01',NULL),(38,'product.create','web','2020-11-24 14:29:01',NULL),(39,'product.update','web','2020-11-24 14:29:01',NULL),(40,'product.delete','web','2020-11-24 14:29:01',NULL),(41,'purchase.view','web','2020-11-24 14:29:01',NULL),(42,'purchase.create','web','2020-11-24 14:29:01',NULL),(43,'purchase.update','web','2020-11-24 14:29:01',NULL),(44,'purchase.delete','web','2020-11-24 14:29:01',NULL),(45,'sell.view','web','2020-11-24 14:29:01',NULL),(46,'sell.create','web','2020-11-24 14:29:01',NULL),(47,'sell.update','web','2020-11-24 14:29:01',NULL),(48,'sell.delete','web','2020-11-24 14:29:01',NULL),(49,'purchase_n_sell_report.view','web','2020-11-24 14:29:01',NULL),(50,'contacts_report.view','web','2020-11-24 14:29:01',NULL),(51,'stock_report.view','web','2020-11-24 14:29:01',NULL),(52,'tax_report.view','web','2020-11-24 14:29:01',NULL),(53,'trending_product_report.view','web','2020-11-24 14:29:01',NULL),(54,'register_report.view','web','2020-11-24 14:29:01',NULL),(55,'sales_representative.view','web','2020-11-24 14:29:01',NULL),(56,'expense_report.view','web','2020-11-24 14:29:01',NULL),(57,'business_settings.access','web','2020-11-24 14:29:01',NULL),(58,'barcode_settings.access','web','2020-11-24 14:29:01',NULL),(59,'invoice_settings.access','web','2020-11-24 14:29:01',NULL),(60,'brand.view','web','2020-11-24 14:29:01',NULL),(61,'brand.create','web','2020-11-24 14:29:01',NULL),(62,'brand.update','web','2020-11-24 14:29:01',NULL),(63,'brand.delete','web','2020-11-24 14:29:01',NULL),(64,'tax_rate.view','web','2020-11-24 14:29:01',NULL),(65,'tax_rate.create','web','2020-11-24 14:29:01',NULL),(66,'tax_rate.update','web','2020-11-24 14:29:01',NULL),(67,'tax_rate.delete','web','2020-11-24 14:29:01',NULL),(68,'unit.view','web','2020-11-24 14:29:01',NULL),(69,'unit.create','web','2020-11-24 14:29:01',NULL),(70,'unit.update','web','2020-11-24 14:29:01',NULL),(71,'unit.delete','web','2020-11-24 14:29:01',NULL),(72,'category.view','web','2020-11-24 14:29:01',NULL),(73,'category.create','web','2020-11-24 14:29:01',NULL),(74,'category.update','web','2020-11-24 14:29:01',NULL),(75,'category.delete','web','2020-11-24 14:29:01',NULL),(76,'expense.access','web','2020-11-24 14:29:01',NULL),(77,'access_all_locations','web','2020-11-24 14:29:01',NULL),(78,'dashboard.data','web','2020-11-24 14:29:01',NULL),(79,'location.1','web','2020-12-29 13:47:48','2020-12-29 13:47:48'),(80,'location.2','web','2020-12-29 17:51:35','2020-12-29 17:51:35'),(81,'location.3','web','2020-12-30 20:41:04','2020-12-30 20:41:04'),(82,'location.4','web','2021-02-03 12:31:15','2021-02-03 12:31:15'),(83,'location.5','web','2021-02-03 13:03:51','2021-02-03 13:03:51');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection_type` enum('network','windows','linux') COLLATE utf8mb4_unicode_ci NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (1,2),(2,2),(3,2),(4,2),(5,2),(6,2),(7,2),(8,2);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2020-12-29 19:49:21','2020-12-29 19:49:21'),(2,NULL,'DUMMY',2,1,'2020-12-29 19:52:13','2020-12-29 19:52:13'),(3,NULL,'DUMMY',3,1,'2020-12-29 19:54:32','2020-12-29 19:54:32'),(4,NULL,'DUMMY',4,1,'2020-12-29 19:56:42','2020-12-29 19:56:42'),(5,NULL,'DUMMY',5,1,'2020-12-29 19:58:55','2020-12-29 19:58:55'),(6,NULL,'DUMMY',6,1,'2020-12-29 20:01:50','2020-12-29 20:01:50'),(7,NULL,'DUMMY',7,1,'2020-12-29 20:06:44','2020-12-29 20:06:44'),(8,NULL,'DUMMY',8,1,'2020-12-29 20:08:34','2020-12-29 20:08:34');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `sub_unit_ids` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT 0,
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT 0,
  `weight` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT 0,
  `not_for_selling` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `perc_icms` decimal(4,2) NOT NULL DEFAULT 0.00,
  `perc_pis` decimal(4,2) NOT NULL DEFAULT 0.00,
  `perc_cofins` decimal(4,2) NOT NULL DEFAULT 0.00,
  `perc_ipi` decimal(4,2) NOT NULL DEFAULT 0.00,
  `cfop_interno` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '5101',
  `cfop_externo` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '6101',
  `cst_csosn` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '101',
  `cst_pis` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '49',
  `cst_cofins` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '49',
  `cst_ipi` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '99',
  `ncm` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `cest` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'PAO FRANCES',2,'single',22,NULL,1,1,NULL,NULL,'exclusive',0,0.0000,'005000','EAN13',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2020-12-29 19:49:21','2020-12-29 19:49:21',0.00,0.00,0.00,0.00,'5102','6102','102','49','49','99','1905.90.90','1706000'),(2,'PÃO INTEGRAL 12 GRÃOS ZERO',2,'single',2,NULL,3,1,NULL,NULL,'exclusive',1,5.0000,'7896002366304','EAN13',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2020-12-29 19:52:13','2020-12-29 20:13:29',0.00,0.00,0.00,0.00,'5102','6102','102','49','49','99','1905.90.10','1706000'),(3,'PÃO ARTESANO GOTAS DE CHOCOLATE',2,'single',2,NULL,3,1,NULL,NULL,'exclusive',1,5.0000,'7896002303965','EAN13',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2020-12-29 19:54:32','2020-12-29 20:20:01',0.00,0.00,0.00,0.00,'5102','6102','102','49','49','99','1905.90.10','1706000'),(4,'BOLO DE QUEIJO',2,'single',2,NULL,1,1,NULL,NULL,'exclusive',1,0.0000,'002200','EAN13',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2020-12-29 19:56:42','2020-12-29 20:21:14',0.00,0.00,0.00,0.00,'5102','6102','102','49','49','99','1905.90.90','1706000'),(5,'QUEIJO MINAS',2,'single',22,NULL,1,1,NULL,NULL,'exclusive',0,0.0000,'001500','EAN13',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2020-12-29 19:58:55','2020-12-29 19:58:55',0.00,0.00,0.00,0.00,'5102','6102','102','49','49','99','0406.10.90','1702402'),(6,'COCA COLA 2 L',2,'single',2,NULL,9,1,NULL,NULL,'exclusive',1,15.0000,'7894900011517','EAN13',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2020-12-29 20:01:50','2020-12-29 20:21:47',0.00,0.00,0.00,0.00,'5102','6102','102','49','49','99','2202.10.00','0301000'),(7,'PRESUNTO PERDIGÃO',2,'single',22,NULL,1,1,NULL,NULL,'exclusive',0,0.0000,'001800','EAN13',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2020-12-29 20:06:44','2020-12-29 20:06:44',0.00,0.00,0.00,0.00,'5102','6102','102','49','49','99','1622.41.00','1707901'),(8,'MUSSARELA CALU',2,'single',22,NULL,1,1,NULL,NULL,'exclusive',0,0.0000,'004000','EAN13',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,0,'2020-12-29 20:08:34','2020-12-29 20:08:34',0.00,0.00,0.00,0.00,'5102','6102','102','49','49','99','0406.10.10','1702401');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pp_without_discount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT 0.00 COMMENT 'Inline discount percentage',
  `purchase_price` decimal(22,4) NOT NULL,
  `purchase_price_inc_tax` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `quantity_sold` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `quantity_returned` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_quantity_used` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`),
  KEY `purchase_lines_lot_number_index` (`lot_number`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,1,2,2,30.0000,5.8000,0.00,5.8000,5.8000,0.0000,NULL,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-12-29 20:19:23','2020-12-29 20:19:23'),(2,2,3,3,30.0000,6.5200,0.00,6.5200,6.5200,0.0000,NULL,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-12-29 20:20:10','2020-12-29 20:20:10'),(3,3,4,4,10.0000,6.0000,0.00,6.0000,6.0000,0.0000,NULL,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-12-29 20:21:24','2020-12-29 20:28:51'),(4,4,6,6,120.0000,5.9900,0.00,5.9900,5.9900,0.0000,NULL,1.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-12-29 20:21:56','2020-12-29 20:28:08');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'contacts',1,1,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(2,'business_location',1,1,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(3,'contacts',1,2,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(4,'business_location',1,2,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(5,'sell_payment',2,2,'2020-12-29 20:28:08','2020-12-29 20:28:51'),(6,'contacts',1,3,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(7,'business_location',1,3,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(8,'contacts',1,4,'2021-02-03 12:31:15','2021-02-03 12:31:15'),(9,'business_location',1,4,'2021-02-03 12:31:15','2021-02-03 12:31:15'),(10,'contacts',1,5,'2021-02-03 13:03:51','2021-02-03 13:03:51'),(11,'business_location',1,5,'2021-02-03 13:03:51','2021-02-03 13:03:51');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_tables_business_id_foreign` (`business_id`),
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (45,2),(45,4),(45,6),(45,10),(46,2),(46,4),(46,6),(46,10),(47,2),(47,4),(47,6),(47,10),(48,2),(48,4),(48,6),(48,10),(77,2),(77,4),(77,6),(77,10);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_service_staff` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,0,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(2,'Cashier#1','web',1,0,0,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(3,'Admin#2','web',2,1,0,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(4,'Cashier#2','web',2,0,0,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(5,'Admin#3','web',3,1,0,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(6,'Cashier#3','web',3,0,0,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(9,'Admin#5','web',5,1,0,'2021-02-03 13:03:51','2021-02-03 13:03:51'),(10,'Cashier#5','web',5,0,0,'2021-02-03 13:03:51','2021-02-03 13:03:51');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sell_line_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sell_line_warranties` (
  `sell_line_id` int(11) NOT NULL,
  `warranty_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sell_line_warranties` WRITE;
/*!40000 ALTER TABLE `sell_line_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `sell_line_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `selling_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `selling_price_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `selling_price_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `selling_price_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `selling_price_groups` WRITE;
/*!40000 ALTER TABLE `selling_price_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `selling_price_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `package_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `trial_end_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `package_price` decimal(22,4) NOT NULL,
  `package_details` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_id` int(10) unsigned NOT NULL,
  `paid_via` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('approved','waiting','declined') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subscriptions_business_id_foreign` (`business_id`),
  KEY `subscriptions_package_id_index` (`package_id`),
  KEY `subscriptions_created_id_index` (`created_id`),
  CONSTRAINT `subscriptions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
INSERT INTO `subscriptions` VALUES (1,1,1,'2020-12-29','2021-01-05','2021-01-05',0.0000,'{\"location_count\":\"1\",\"user_count\":\"1\",\"product_count\":\"20\",\"invoice_count\":\"5\",\"name\":\"Teste 7 dias\"}',1,NULL,'FREE','declined',NULL,'2020-12-29 16:42:14','2020-12-29 18:06:41'),(2,1,5,'2021-01-06','2023-01-06','2023-01-06',0.0000,'{\"location_count\":\"1000\",\"user_count\":\"100\",\"product_count\":\"100000\",\"invoice_count\":\"100000\",\"name\":\"Admin\"}',1,NULL,'FREE','approved',NULL,'2020-12-29 16:45:22','2020-12-29 16:45:22'),(3,2,6,'2020-12-29','2021-01-29','2021-01-29',0.0000,'{\"location_count\":\"2\",\"user_count\":\"3\",\"product_count\":\"50\",\"invoice_count\":\"50\",\"name\":\"Teste Homologa\\u00e7\\u00e3o\"}',1,'offline',NULL,'approved',NULL,'2020-12-29 18:08:21','2020-12-29 18:08:21'),(4,5,6,'2021-02-03','2021-03-03','2021-03-03',0.0000,'{\"location_count\":\"2\",\"user_count\":\"3\",\"product_count\":\"50\",\"invoice_count\":\"50\",\"name\":\"Teste Homologa\\u00e7\\u00e3o\"}',1,'offline',NULL,'approved',NULL,'2021-02-03 13:13:43','2021-02-03 13:13:43');
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_communicator_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `superadmin_communicator_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_ids` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_communicator_logs` WRITE;
/*!40000 ALTER TABLE `superadmin_communicator_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `superadmin_communicator_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_frontend_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `superadmin_frontend_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_shown` tinyint(1) NOT NULL,
  `menu_order` int(11) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_frontend_pages` WRITE;
/*!40000 ALTER TABLE `superadmin_frontend_pages` DISABLE KEYS */;
/*!40000 ALTER TABLE `superadmin_frontend_pages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES (1,'db_version','3.3'),(2,'default_business_active_status','1'),(3,'superadmin_version','2.2'),(4,'app_currency_id','18'),(5,'invoice_business_name','EzCompany Soluções'),(6,'invoice_business_landmark','EzCompany Soluções'),(7,'invoice_business_zip','38408186'),(8,'invoice_business_state','MG'),(9,'invoice_business_city','Uberlândia'),(10,'invoice_business_country','Brasil'),(11,'email','contato@ezcompany.tec.br'),(12,'package_expiry_alert_days','5'),(13,'enable_business_based_username','0'),(14,'superadmin_register_tc',NULL),(15,'welcome_email_subject',NULL),(16,'welcome_email_body',NULL),(17,'additional_js',NULL),(18,'additional_css',NULL),(19,'offline_payment_details',NULL),(20,'superadmin_enable_register_tc','0'),(21,'allow_email_settings_to_businesses','0'),(22,'enable_new_business_registration_notification','0'),(23,'enable_new_subscription_notification','0'),(24,'enable_welcome_email','0'),(25,'enable_offline_payment','1');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(22,4) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) unsigned DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Used during sales to return the change',
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `method` enum('cash','card','cheque','bank_transfer','custom_pay_1','custom_pay_2','custom_pay_3','other') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_transaction_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_holder_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_month` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_year` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_security` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `payment_for` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  KEY `transaction_payments_parent_id_index` (`parent_id`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
INSERT INTO `transaction_payments` VALUES (1,5,2,0,30.4100,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 17:28:08',2,2,NULL,NULL,NULL,'SP2020/0001',NULL,'2020-12-29 20:28:08','2020-12-29 20:28:08'),(2,6,2,0,16.1400,'card',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 17:28:51',2,2,NULL,NULL,NULL,'SP2020/0002',NULL,'2020-12-29 20:28:51','2020-12-29 20:28:51');
/*!40000 ALTER TABLE `transaction_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT 0.0000,
  `unit_price_before_discount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Sell price excluding tax',
  `line_discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line_discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `sell_line_note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `res_service_staff_id` int(11) DEFAULT NULL,
  `res_line_order_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_sell_line_id` int(11) DEFAULT NULL,
  `children_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Type of children for the parent, like modifier or combo',
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_sell_lines_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_sell_lines_product_id_foreign` (`product_id`),
  KEY `transaction_sell_lines_variation_id_foreign` (`variation_id`),
  KEY `transaction_sell_lines_tax_id_foreign` (`tax_id`),
  KEY `transaction_sell_lines_children_type_index` (`children_type`),
  KEY `transaction_sell_lines_parent_sell_line_id_index` (`parent_sell_line_id`),
  CONSTRAINT `transaction_sell_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines` VALUES (1,5,1,1,0.5500,0.0000,11.9000,11.9000,'fixed',0.0000,11.9000,0.0000,NULL,NULL,NULL,'',NULL,NULL,NULL,'',NULL,'2020-12-29 20:28:08','2020-12-29 20:28:08'),(2,5,6,6,1.0000,0.0000,8.0000,8.0000,'fixed',0.0000,8.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,NULL,'',NULL,'2020-12-29 20:28:08','2020-12-29 20:28:08'),(3,5,7,7,0.2310,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,NULL,'',NULL,'2020-12-29 20:28:08','2020-12-29 20:28:08'),(4,5,8,8,0.2100,0.0000,48.0000,48.0000,'fixed',0.0000,48.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,NULL,'',NULL,'2020-12-29 20:28:08','2020-12-29 20:28:08'),(5,6,1,1,0.6000,0.0000,11.9000,11.9000,'fixed',0.0000,11.9000,0.0000,NULL,NULL,NULL,'',NULL,NULL,NULL,'',NULL,'2020-12-29 20:28:51','2020-12-29 20:28:51'),(6,6,4,4,1.0000,0.0000,9.0000,9.0000,'fixed',0.0000,9.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,NULL,'',NULL,'2020-12-29 20:28:51','2020-12-29 20:28:51');
/*!40000 ALTER TABLE `transaction_sell_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines_purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines_purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sell_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from transaction_sell_lines',
  `stock_adjustment_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from stock_adjustment_lines',
  `purchase_line_id` int(10) unsigned NOT NULL COMMENT 'id from purchase_lines',
  `quantity` decimal(22,4) NOT NULL,
  `qty_returned` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sell_line_id` (`sell_line_id`),
  KEY `stock_adjustment_line_id` (`stock_adjustment_line_id`),
  KEY `purchase_line_id` (`purchase_line_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines_purchase_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines_purchase_lines` VALUES (1,2,NULL,4,1.0000,0.0000,'2020-12-29 20:28:08','2020-12-29 20:28:08'),(2,6,NULL,3,1.0000,0.0000,'2020-12-29 20:28:51','2020-12-29 20:28:51');
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `res_table_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_waiter_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_order_status` enum('received','cooked','served') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('received','pending','ordered','draft','final') COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_quotation` tinyint(1) NOT NULL DEFAULT 0,
  `payment_status` enum('paid','due','partial') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_type` enum('normal','abnormal') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL COMMENT 'used to add customer group while selling',
  `invoice_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscription_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscription_repeat_on` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `total_before_tax` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Total before the purchase/invoice tax, this includeds the indivisual product tax',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `tax_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(22,4) DEFAULT 0.0000,
  `rp_redeemed` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_redeemed_amount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'rp is the short form of reward points',
  `shipping_details` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delivered_to` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_charges` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_notes` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `staff_note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `round_off_amount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Difference of rounded total and actual total',
  `final_total` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `expense_category_id` int(10) unsigned DEFAULT NULL,
  `expense_for` int(10) unsigned DEFAULT NULL,
  `commission_agent` int(11) DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_direct_sale` tinyint(1) NOT NULL DEFAULT 0,
  `is_suspend` tinyint(1) NOT NULL DEFAULT 0,
  `exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `total_amount_recovered` decimal(22,4) DEFAULT NULL COMMENT 'Used for stock adjustment.',
  `transfer_parent_id` int(11) DEFAULT NULL,
  `return_parent_id` int(11) DEFAULT NULL,
  `opening_stock_product_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `import_batch` int(11) DEFAULT NULL,
  `import_time` datetime DEFAULT NULL,
  `types_of_service_id` int(11) DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `service_custom_field_1` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `service_custom_field_2` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `service_custom_field_3` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `service_custom_field_4` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_created_from_api` tinyint(1) NOT NULL DEFAULT 0,
  `rp_earned` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `order_addresses` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_recurring` tinyint(1) NOT NULL DEFAULT 0,
  `recur_interval` double(22,4) DEFAULT NULL,
  `recur_interval_type` enum('days','months','years') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recur_repetitions` int(11) DEFAULT NULL,
  `recur_stopped_on` datetime DEFAULT NULL,
  `recur_parent_id` int(11) DEFAULT NULL,
  `invoice_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `natureza_id` int(10) unsigned DEFAULT NULL,
  `placa` varchar(9) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `uf` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `valor_frete` decimal(10,2) NOT NULL DEFAULT 0.00,
  `tipo` int(11) NOT NULL DEFAULT 0,
  `qtd_volumes` int(11) NOT NULL DEFAULT 0,
  `numeracao_volumes` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `especie` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `peso_liquido` decimal(8,3) NOT NULL DEFAULT 0.000,
  `peso_bruto` decimal(8,3) NOT NULL DEFAULT 0.000,
  `numero_nfe` int(11) NOT NULL DEFAULT 0,
  `numero_nfce` int(11) NOT NULL DEFAULT 0,
  `numero_nfe_entrada` int(11) NOT NULL DEFAULT 0,
  `chave` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `chave_entrada` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sequencia_cce` int(11) NOT NULL DEFAULT 0,
  `cpf_nota` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `troco` decimal(10,2) NOT NULL DEFAULT 0.00,
  `valor_recebido` decimal(10,2) NOT NULL DEFAULT 0.00,
  `transportadora_id` int(10) unsigned DEFAULT NULL,
  `estado` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'NOVO',
  PRIMARY KEY (`id`),
  KEY `transactions_tax_id_foreign` (`tax_id`),
  KEY `transactions_business_id_index` (`business_id`),
  KEY `transactions_type_index` (`type`),
  KEY `transactions_contact_id_index` (`contact_id`),
  KEY `transactions_transaction_date_index` (`transaction_date`),
  KEY `transactions_created_by_index` (`created_by`),
  KEY `transactions_natureza_id_foreign` (`natureza_id`),
  KEY `transactions_transportadora_id_foreign` (`transportadora_id`),
  KEY `transactions_location_id_index` (`location_id`),
  KEY `transactions_expense_for_foreign` (`expense_for`),
  KEY `transactions_expense_category_id_index` (`expense_category_id`),
  KEY `transactions_sub_type_index` (`sub_type`),
  KEY `transactions_return_parent_id_index` (`return_parent_id`),
  KEY `type` (`type`),
  CONSTRAINT `transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_for_foreign` FOREIGN KEY (`expense_for`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `transactions_natureza_id_foreign` FOREIGN KEY (`natureza_id`) REFERENCES `natureza_operacaos` (`id`),
  CONSTRAINT `transactions_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_transportadora_id_foreign` FOREIGN KEY (`transportadora_id`) REFERENCES `transportadoras` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` VALUES (1,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:19:23',174.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,0.0000,174.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,2,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 20:19:23','2020-12-29 20:19:23',NULL,'','',0.00,0,0,'','',0.000,0.000,0,0,0,'','',0,'',0.00,0.00,NULL,'NOVO'),(2,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:20:10',195.6000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,0.0000,195.6000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,3,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 20:20:10','2020-12-29 20:20:10',NULL,'','',0.00,0,0,'','',0.000,0.000,0,0,0,'','',0,'',0.00,0.00,NULL,'NOVO'),(3,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:21:24',60.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,0.0000,60.0000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,4,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 20:21:24','2020-12-29 20:21:24',NULL,'','',0.00,0,0,'','',0.000,0.000,0,0,0,'','',0,'',0.00,0.00,NULL,'NOVO'),(4,2,2,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:21:56',718.8000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,0.0000,718.8000,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,6,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-29 20:21:56','2020-12-29 20:21:56',NULL,'','',0.00,0,0,'','',0.000,0.000,0,0,0,'','',0,'',0.00,0.00,NULL,'NOVO'),(5,2,2,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,2,NULL,'0001','',NULL,NULL,'2020-12-29 17:28:08',30.4000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,0.0000,30.4100,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,'days',0,NULL,NULL,'102eebe07ed367a5b74fd09ce700363b',NULL,NULL,0,'2020-12-29 20:28:08','2020-12-29 20:32:26',NULL,'','',0.00,0,0,'','',0.000,0.000,0,0,0,'','',0,'',4.60,35.00,NULL,'NOVO'),(6,2,2,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,2,NULL,'0002','',NULL,NULL,'2020-12-29 17:28:51',16.1400,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,0.0000,16.1400,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,'days',0,NULL,NULL,'ff641183b35cdcd1274b1afaca699885',NULL,NULL,0,'2020-12-29 20:28:51','2021-01-04 18:48:20',NULL,'','',0.00,0,0,'','',0.000,0.000,0,0,0,'','',0,'',18.86,35.00,NULL,'NOVO');
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transportadoras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transportadoras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `razao_social` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cnpj_cpf` varchar(19) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '000.000.000-00',
  `logradouro` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cidade_id` int(10) unsigned NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transportadoras_cidade_id_foreign` (`cidade_id`),
  KEY `transportadoras_business_id_foreign` (`business_id`),
  CONSTRAINT `transportadoras_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transportadoras_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cities` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transportadoras` WRITE;
/*!40000 ALTER TABLE `transportadoras` DISABLE KEYS */;
/*!40000 ALTER TABLE `transportadoras` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `types_of_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `types_of_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `location_price_group` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_custom_fields` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `types_of_services_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `types_of_services` WRITE;
/*!40000 ALTER TABLE `types_of_services` DISABLE KEYS */;
/*!40000 ALTER TABLE `types_of_services` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `actual_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `allow_decimal` tinyint(1) NOT NULL,
  `base_unit_id` int(11) DEFAULT NULL,
  `base_unit_multiplier` decimal(20,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `units_business_id_foreign` (`business_id`),
  KEY `units_created_by_foreign` (`created_by`),
  KEY `units_base_unit_id_index` (`base_unit_id`),
  CONSTRAINT `units_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `units_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,1,'Unidade','UNID',0,NULL,NULL,1,NULL,'2020-12-29 13:47:48','2020-12-29 13:47:48'),(2,2,'Unidade','UNID',0,NULL,NULL,2,NULL,'2020-12-29 17:51:34','2020-12-29 17:51:34'),(3,2,'BG','BG',0,NULL,NULL,2,NULL,NULL,NULL),(4,2,'Bd','Bd',0,NULL,NULL,2,NULL,NULL,NULL),(5,2,'BJ','BJ',0,NULL,NULL,2,NULL,NULL,NULL),(6,2,'C2','C2',0,NULL,NULL,2,NULL,NULL,NULL),(7,2,'CJ','CJ',0,NULL,NULL,2,NULL,NULL,NULL),(8,2,'CP','CP',0,NULL,NULL,2,NULL,NULL,NULL),(9,2,'CT','CT',0,NULL,NULL,2,NULL,NULL,NULL),(10,2,'CTO','CTO',0,NULL,NULL,2,NULL,NULL,NULL),(11,2,'CX','CX',0,NULL,NULL,2,NULL,NULL,NULL),(12,2,'CXA12','CXA12',0,NULL,NULL,2,NULL,NULL,NULL),(13,2,'CXA16','CXA16',0,NULL,NULL,2,NULL,NULL,NULL),(14,2,'CXA18','CXA18',0,NULL,NULL,2,NULL,NULL,NULL),(15,2,'CXA24','CXA24',0,NULL,NULL,2,NULL,NULL,NULL),(16,2,'DP','DP',0,NULL,NULL,2,NULL,NULL,NULL),(17,2,'DZ','DZ',0,NULL,NULL,2,NULL,NULL,NULL),(18,2,'EXB','EXB',0,NULL,NULL,2,NULL,NULL,NULL),(19,2,'FC','FC',0,NULL,NULL,2,NULL,NULL,NULL),(20,2,'FD','FD',0,NULL,NULL,2,NULL,NULL,NULL),(21,2,'GL','GL',0,NULL,NULL,2,NULL,NULL,NULL),(22,2,'KG','KG',1,NULL,NULL,2,NULL,NULL,'2020-12-29 19:39:57'),(23,2,'LT','LT',0,NULL,NULL,2,NULL,NULL,NULL),(24,2,'MIL','MIL',0,NULL,NULL,2,NULL,NULL,NULL),(25,2,'PAR','PAR',0,NULL,NULL,2,NULL,NULL,NULL),(26,2,'PC','PC',0,NULL,NULL,2,NULL,NULL,NULL),(27,2,'PCT','PCT',0,NULL,NULL,2,NULL,NULL,NULL),(28,2,'PE','PE',0,NULL,NULL,2,NULL,NULL,NULL),(29,2,'PT','PT',0,NULL,NULL,2,NULL,NULL,NULL),(30,2,'SC','SC',0,NULL,NULL,2,NULL,NULL,NULL),(31,2,'SCS','SCS',0,NULL,NULL,2,NULL,NULL,NULL),(32,2,'T','T',0,NULL,NULL,2,NULL,NULL,NULL),(33,2,'TB','TB',0,NULL,NULL,2,NULL,NULL,NULL),(34,2,'UN','UN',0,NULL,NULL,2,NULL,NULL,NULL),(35,2,'UND1','UND1',0,NULL,NULL,2,NULL,NULL,NULL),(36,2,'UNI','UNI',0,NULL,NULL,2,NULL,NULL,NULL),(37,2,'cx06','cx06',0,NULL,NULL,2,NULL,NULL,NULL),(38,2,'cx12','cx12',0,NULL,NULL,2,NULL,NULL,NULL),(39,2,'cx15','cx15',0,NULL,NULL,2,NULL,NULL,NULL),(40,2,'S1','S1C',0,NULL,NULL,2,NULL,NULL,NULL),(41,2,'F9','F9C',0,NULL,NULL,2,NULL,NULL,NULL),(42,2,'S2','S25',0,NULL,NULL,2,NULL,NULL,NULL),(43,2,'BD','BD',0,NULL,NULL,2,NULL,NULL,NULL),(44,2,'F1','F18',0,NULL,NULL,2,NULL,NULL,NULL),(45,2,'ML','ML',0,NULL,NULL,2,NULL,NULL,NULL),(46,2,'RL','RL',0,NULL,NULL,2,NULL,NULL,NULL),(47,2,'BR','BR',0,NULL,NULL,2,NULL,NULL,NULL),(48,2,'BA','BAG',0,NULL,NULL,2,NULL,NULL,NULL),(49,2,'K1','K1',0,NULL,NULL,2,NULL,NULL,NULL),(50,2,'SA','SAC',0,NULL,NULL,2,NULL,NULL,NULL),(51,2,'EB','EB',0,NULL,NULL,2,NULL,NULL,NULL),(52,2,'EX','EXB',0,NULL,NULL,2,NULL,NULL,NULL),(53,2,'BL','BL',0,NULL,NULL,2,NULL,NULL,NULL),(54,2,'PA','PAC',0,NULL,NULL,2,NULL,NULL,NULL),(55,2,'MI','MIL',0,NULL,NULL,2,NULL,NULL,NULL),(56,2,'CL','CL',0,NULL,NULL,2,NULL,NULL,NULL),(57,3,'Unidade','UNID',0,NULL,NULL,3,NULL,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(59,5,'Unidade','UNID',0,NULL,NULL,5,NULL,'2021-02-03 13:03:51','2021-02-03 13:03:51');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_contact_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_contact_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `contact_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_contact_access` WRITE;
/*!40000 ALTER TABLE `user_contact_access` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_contact_access` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'user',
  `surname` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pt',
  `contact_no` char(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `max_sales_discount_percent` decimal(5,2) DEFAULT NULL,
  `allow_login` tinyint(1) NOT NULL DEFAULT 1,
  `status` enum('active','inactive','terminated') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `is_cmmsn_agnt` tinyint(1) NOT NULL DEFAULT 0,
  `cmmsn_percent` decimal(4,2) NOT NULL DEFAULT 0.00,
  `selected_contacts` tinyint(1) NOT NULL DEFAULT 0,
  `dob` date DEFAULT NULL,
  `gender` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `marital_status` enum('married','unmarried','divorced') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blood_group` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_number` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fb_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `social_media_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `social_media_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permanent_address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guardian_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_details` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_proof_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_proof_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  KEY `users_business_id_foreign` (`business_id`),
  KEY `users_user_type_index` (`user_type`),
  CONSTRAINT `users_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'user','Sr','Bruno','Alvim','balvim','balvim@hotmail.com','$2y$10$Twwafa8y2wNF4bEBgKx3murIrWyXXQZFWYXhkJCwxKfrJAn9w5jP2','pt',NULL,NULL,NULL,1,NULL,1,'active',0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"account_holder_name\":null,\"account_number\":null,\"bank_name\":null,\"bank_code\":null,\"branch\":null,\"tax_payer_id\":null}',NULL,NULL,NULL,'2020-12-29 13:47:48','2020-12-29 18:07:07'),(2,'user','Sr','Gramado','Pães','GramadoPaes','gramadopaes@gmail.com','$2y$10$N1sXumEN1E.vQEqWfxPl3eUyGkWBNGosMZugo0ZM2v.af9OBP0RgW','pt',NULL,NULL,'RqQ3b4ETde11zLHUKWCvk6VtGnzKNAr1JDbaxvFxV8c7iCH8EiiLluvsaZSM',2,NULL,1,'active',0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"account_holder_name\":null,\"account_number\":null,\"bank_name\":null,\"bank_code\":null,\"branch\":null,\"tax_payer_id\":null}',NULL,NULL,NULL,'2020-12-29 17:51:34','2020-12-29 18:10:09'),(3,'user','Sr','Esney','Menezes','esney','comercial@docesluana.com.br','$2y$10$nRYGPw3lGUaOzNPOsquWaO.jTli9KV.Q8zOmw3dFo/9Dym1ea.TVe','pt',NULL,NULL,NULL,3,NULL,1,'active',0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-12-30 20:41:04','2020-12-30 20:41:04'),(5,'user','Sra','Ana Paula','Cardoso','boloecia','fernandamenezesmaia@hotmail.com','$2y$10$P5LMUvpXeijoN6ZrvsmrIODKG6lXQ94re1.XeVIsbddLtVolyzyuS','pt',NULL,NULL,NULL,5,NULL,1,'active',0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-02-03 13:03:51','2021-02-03 13:03:51');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_group_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_group_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_id` int(10) unsigned NOT NULL,
  `price_group_id` int(10) unsigned NOT NULL,
  `price_inc_tax` decimal(22,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_group_prices_variation_id_foreign` (`variation_id`),
  KEY `variation_group_prices_price_group_id_foreign` (`price_group_id`),
  CONSTRAINT `variation_group_prices_price_group_id_foreign` FOREIGN KEY (`price_group_id`) REFERENCES `selling_price_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variation_group_prices_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_group_prices` WRITE;
/*!40000 ALTER TABLE `variation_group_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_group_prices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_location_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_location_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `product_variation_id` int(10) unsigned NOT NULL COMMENT 'id from product_variations table',
  `variation_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `qty_available` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_location_details_location_id_foreign` (`location_id`),
  KEY `variation_location_details_product_id_index` (`product_id`),
  KEY `variation_location_details_product_variation_id_index` (`product_variation_id`),
  KEY `variation_location_details_variation_id_index` (`variation_id`),
  CONSTRAINT `variation_location_details_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `variation_location_details_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_location_details` WRITE;
/*!40000 ALTER TABLE `variation_location_details` DISABLE KEYS */;
INSERT INTO `variation_location_details` VALUES (1,2,2,2,2,30.0000,'2020-12-29 20:19:23','2020-12-29 20:19:23'),(2,3,3,3,2,30.0000,'2020-12-29 20:20:10','2020-12-29 20:20:10'),(3,4,4,4,2,9.0000,'2020-12-29 20:21:24','2020-12-29 20:28:51'),(4,6,6,6,2,119.0000,'2020-12-29 20:21:56','2020-12-29 20:28:08');
/*!40000 ALTER TABLE `variation_location_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_templates_business_id_foreign` (`business_id`),
  CONSTRAINT `variation_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_templates` WRITE;
/*!40000 ALTER TABLE `variation_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_value_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_value_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `variation_template_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_value_templates_name_index` (`name`),
  KEY `variation_value_templates_variation_template_id_index` (`variation_template_id`),
  CONSTRAINT `variation_value_templates_variation_template_id_foreign` FOREIGN KEY (`variation_template_id`) REFERENCES `variation_templates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_value_templates` WRITE;
/*!40000 ALTER TABLE `variation_value_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_value_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `sub_sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_variation_id` int(10) unsigned NOT NULL,
  `variation_value_id` int(11) DEFAULT NULL,
  `default_purchase_price` decimal(22,4) DEFAULT NULL,
  `dpp_inc_tax` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `profit_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `default_sell_price` decimal(22,4) DEFAULT NULL,
  `sell_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `combo_variations` text COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Contains the combo variation details',
  PRIMARY KEY (`id`),
  KEY `variations_product_id_foreign` (`product_id`),
  KEY `variations_product_variation_id_foreign` (`product_variation_id`),
  KEY `variations_name_index` (`name`),
  KEY `variations_sub_sku_index` (`sub_sku`),
  KEY `variations_variation_value_id_index` (`variation_value_id`),
  CONSTRAINT `variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variations_product_variation_id_foreign` FOREIGN KEY (`product_variation_id`) REFERENCES `product_variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variations` WRITE;
/*!40000 ALTER TABLE `variations` DISABLE KEYS */;
INSERT INTO `variations` VALUES (1,'DUMMY',1,'005000',1,NULL,6.0100,6.0100,98.0000,11.9000,11.9000,'2020-12-29 19:49:21','2020-12-29 19:49:21',NULL,'[]'),(2,'DUMMY',2,'7896002366304',2,NULL,5.8000,5.8000,55.1700,9.0000,9.0000,'2020-12-29 19:52:13','2020-12-29 20:13:29',NULL,'[]'),(3,'DUMMY',3,'7896002303965',3,NULL,6.5200,6.5200,38.0400,9.0000,9.0000,'2020-12-29 19:54:32','2020-12-29 20:20:01',NULL,'[]'),(4,'DUMMY',4,'002200',4,NULL,6.0000,6.0000,50.0000,9.0000,9.0000,'2020-12-29 19:56:42','2020-12-29 20:21:14',NULL,'[]'),(5,'DUMMY',5,'001500',5,NULL,13.0000,13.0000,107.6900,27.0000,27.0000,'2020-12-29 19:58:55','2020-12-29 19:58:55',NULL,'[]'),(6,'DUMMY',6,'7894900011517',6,NULL,5.9900,5.9900,33.5600,8.0000,8.0000,'2020-12-29 20:01:50','2020-12-29 20:21:47',NULL,'[]'),(7,'DUMMY',7,'001800',7,NULL,13.9900,13.9900,78.7000,25.0000,25.0000,'2020-12-29 20:06:44','2020-12-29 20:06:44',NULL,'[]'),(8,'DUMMY',8,'004000',8,NULL,35.0000,35.0000,37.1400,48.0000,48.0000,'2020-12-29 20:08:34','2020-12-29 20:08:34',NULL,'[]');
/*!40000 ALTER TABLE `variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `veiculos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `veiculos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `placa` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uf` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cor` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `marca` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `modelo` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rntrc` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_carroceira` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_rodado` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tara` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `capacidade` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `proprietario_documento` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `proprietario_nome` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `proprietario_ie` varchar(13) COLLATE utf8mb4_unicode_ci NOT NULL,
  `proprietario_uf` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `proprietario_tp` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `veiculos_business_id_foreign` (`business_id`),
  CONSTRAINT `veiculos_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `veiculos` WRITE;
/*!40000 ALTER TABLE `veiculos` DISABLE KEYS */;
/*!40000 ALTER TABLE `veiculos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warranties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(11) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duration` int(11) NOT NULL,
  `duration_type` enum('days','months','years') COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warranties` WRITE;
/*!40000 ALTER TABLE `warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `warranties` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

