<?php $__env->startSection('title', 'Manifesto XML'); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->


<!-- Main content -->
<section class="content">


	<?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>

	<?php if(count($business_locations) == 1): ?>
	<?php 
	$default_location = current(array_keys($business_locations->toArray()));
	$search_disable = false; 
	?>
	<?php else: ?>
	<?php $default_location = null;
	$search_disable = true;
	?>
	<?php endif; ?>
	<div class="col-sm-3">
		<div class="form-group">
			<?php echo Form::label('location_id', 'Atribuição de estoque em'.':*'); ?>

			<?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('tooltip.purchase_location') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
			<?php echo Form::select('location_id', $business_locations, $default_location, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required']);; ?>

		</div>
	</div>

	<input type="hidden" value="<?php echo e(json_encode($contact), false); ?>" name="contact">
	<input type="hidden" value="<?php echo e(json_encode($itens), false); ?>" name="itens">
	<input type="hidden" value="<?php echo e(json_encode($fatura), false); ?>" name="fatura">
	<input type="hidden" value="<?php echo e(json_encode($dadosNf), false); ?>" name="dadosNf">

	<div class="row">
		<div class="col-sm-12">
			<div class="form-group">
				<h3 class="box-title">Fornecedor</h3>
				<?php if($dadosNf['novoFornecedor']): ?>
				<p class="text-danger">*Este fornecedor não esta cadastrado no sistema!</p>
				<?php endif; ?>
				<div class="row">
					<div class="col-sm-6">

						<span>Nome: <strong><?php echo e($contact['name'], false); ?></strong></span><br>
						<span>CNPJ/CPF: <strong><?php echo e($contact['cpf_cnpj'], false); ?></strong></span><br>
						<span>IE/RG: <strong><?php echo e($contact['ie_rg'], false); ?></strong></span>


					</div>

					<div class="col-sm-6">

						<span>Rua: <strong><?php echo e($contact['rua'], false); ?>, <?php echo e($contact['numero'], false); ?></strong></span><br>
						<span>Bairro: <strong><?php echo e($contact['bairro'], false); ?></strong></span><br>
						<span>Cidade: <strong><?php echo e($cidade->nome, false); ?> (<?php echo e($cidade->uf, false); ?>)</strong></span>

					</div>
					<div class="col-sm-6">


						<?php if($dadosNf['novoFornecedor']): ?>
						<form method="post" action="/manifesto/salvarFornecedor">
							<?php echo csrf_field(); ?>
							<input type="hidden" value="<?php echo e(json_encode($contact), false); ?>" name="contato">
							<button class="btn btn-success">
								Incluir fornecedor
							</button>
						</form>
						<?php endif; ?>
					</div>
					
				</div>
			</div>
		</div>

		<div class="col-sm-12">
			<div class="form-group">
				<h3 class="box-title">Dados do Documento</h3>

				<div class="row">
					<div class="col-sm-12">

						<span>Chave: <strong><?php echo e($dadosNf['chave'], false); ?></strong></span><br>
						<span>Valor Integral: <strong><?php echo e($dadosNf['vProd'], false); ?></strong></span><br>
						<span>Número: <strong><?php echo e($dadosNf['nNf'], false); ?></strong></span><br>
						<span>Valor do frete: <strong><?php echo e($dadosNf['vFrete'], false); ?></strong></span><br>
						<span>Valor de desconto: <strong><?php echo e($dadosNf['vDesc'], false); ?></strong></span><br>
						<span>Valor Final: <strong><?php echo e($dadosNf['vFinal'], false); ?></strong></span><br>
					</div>

				</div>
			</div>
		</div>

		<div class="col-sm-12">
			<div class="form-group">
				<h3 class="box-title">Produtos</h3>


				<div class="">

					<!-- Inicio tabela -->
					<div class="nav-tabs-custom">

						<div class="tab-content">
							<div class="tab-pane active" id="product_list_tab">
								<br><br>
								<p class="text-danger">* Produtos em vermelho não possuem cadastro no sistema</p>
								<p class="text-info">* Produtos em azul já atribuidos no estoque</p>

								<div class="table-responsive">
									<div id="product_table_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">
										<div class="row margin-bottom-20 text-center">

											<div class="row">
												<div class="col-sm-3">
													<div class="form-group">
														<?php echo Form::label('perc_venda', '% de acrescimo para valor de venda, sobre o valor de compra' . ':'); ?>

														<?php echo Form::text('perc_venda', $lucro, ['id' => 'perc_venda', 'class' => 'form-control']);; ?>

													</div>
												</div>
											</div>

											<table class="table table-bordered table-striped ajax_view hide-footer dataTable no-footer" id="product_table" role="grid" aria-describedby="product_table_info" style="width: 1300px;">
												<thead>
													<tr role="row">

														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 200px;" aria-label="Produto">Produto</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">Código</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">NCM</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">CFOP</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">Quantidade</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">Valor Unit.</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 100px;" aria-label="Produto">Cod. Barras</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">Unidade</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">Conversão Unitária</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">Ações</th>
													</tr>
												</thead>

												<tbody id="itens">

													<?php $__currentLoopData = $itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

													<tr>
														<form <?php if(!$i['produtoNovo']): ?> action="/manifesto/atribuirEstoque" <?php else: ?> action="/manifesto/cadProd" <?php endif; ?> method="get">
															<td <?php if($i['produtoNovo']): ?> class="text-danger" <?php elseif($i['tp']): ?> class="text-info" <?php endif; ?> style="width: 200px;"><?php echo e($i['xProd'], false); ?></td>
															<td style="width: 80px;"><?php echo e($i['codigo'], false); ?></td>
															<td style="width: 80px;"><?php echo e($i['NCM'], false); ?></td>
															<td style="width: 80px;"><?php echo e($i['CFOP'], false); ?></td>
															<td style="width: 80px;"><?php echo e($i['qCom'], false); ?></td>
															<td style="width: 80px;"><?php echo e($i['vUnCom'], false); ?></td>
															<td style="width: 100px;"><?php echo e($i['codBarras'], false); ?></td>
															<td style="width: 100px;"><?php echo e($i['uCom'], false); ?></td>
															<td style="width: 80px;">
																<input value="1" type="" name="tx_conv">
																<label>Somente números</label>
															</td>

															<input type="hidden" value="<?php echo e($i['xProd'], false); ?>" name="nome">
															<input type="hidden" value="<?php echo e($i['NCM'], false); ?>" name="ncm">
															<input type="hidden" value="<?php echo e($i['CFOP'], false); ?>" name="cfop">
															<input type="hidden" value="<?php echo e($i['qCom'], false); ?>" name="quantidade">
															<input type="hidden" value="<?php echo e($i['vUnCom'], false); ?>" name="valor">
															<input type="hidden" value="<?php echo e($i['codBarras'], false); ?>" name="codBarras">
															<input type="hidden" value="<?php echo e($i['uCom'], false); ?>" name="unidade">
															<input type="hidden" value="<?php echo e($lucro, false); ?>" name="perc" class="pc">
															<input type="hidden" value="" name="location_id" class="location">
															<input type="hidden" value="<?php echo e($dadosNf['nNf'], false); ?>" name="numero_nfe">

															<td style="width: 80px;">
																<?php if($i['produtoNovo']): ?>
																<button class="btn btn-success" type="submit">
																	Adicionar
																</button>
																<?php endif; ?>

																<?php if(!$i['produtoNovo'] && !$i['tp']): ?>
																<button class="btn btn-danger" type="submit">
																	Atribuir estoque
																</button>
																<?php endif; ?>

																<?php if($i['tp']): ?>
																<a class="btn btn-danger" disabled >
																	Atribuir estoque
																</a>
																<?php endif; ?>
															</td>
														</form>

													</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

												</tbody>
											</table>

											
										</div>

									</div>


								</div>
							</div>
						</div>
					</div>

					<!-- fim tabela -->
				</div>
			</div>
		</div>

		<div class="col-sm-12">
			<div class="form-group">
				<h3 class="box-title">Fatura</h3>
				<div class="">
					
					<div class="nav-tabs-custom">


						<div class="tab-content">
							<div class="tab-pane active" id="product_list_tab">
								<br><br>
								<div class="table-responsive">
									<div id="product_table_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">
										<div class="row margin-bottom-20 text-center">
											<table class="table table-bordered table-striped ajax_view hide-footer dataTable no-footer" id="product_table" role="grid" aria-describedby="product_table_info" style="width: 700px;">
												<thead>
													<tr role="row">

														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 100px;" aria-label="Produto">Número</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 100px;" aria-label="Produto">Vencimento</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 100px;" aria-label="Produto">Valor</th>
													</tr>
												</thead>

												<tbody>

													<?php if(sizeof($fatura) > 0): ?>

													<?php $__currentLoopData = $fatura; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

													<tr>
														<td style="width: 200px;"><?php echo e($f['numero'], false); ?></td>
														<td style="width: 80px;"><?php echo e($f['vencimento'], false); ?></td>
														<td style="width: 80px;"><?php echo e($f['valor_parcela'], false); ?></td>

													</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

													
													<?php else: ?>
													<tr>
														<td colspan="3">Nenhuma fatura neste XML</td>
													</tr>
													<?php endif; ?>

												</tbody>
											</table>


										</div>
										<?php if(sizeof($fatura) > 0): ?>
										<?php if($dadosNf['novoFornecedor']): ?>

										<p class="text-danger">*Inclua o fornecedor para salvar a fatura</p>

										<?php else: ?>

										<?php if($faturaAnterior == null): ?>
										<div class="row">
											<form method="post" action="/manifesto/salvarFatura">
												<?php echo csrf_field(); ?>
												<input type="hidden" value="<?php echo e(json_encode($fatura), false); ?>" name="fatura">
												<input type="hidden" value="<?php echo e($dadosNf['vDesc'], false); ?>" name="desconto">
												<input type="hidden" value="<?php echo e($dadosNf['nNf'], false); ?>" name="numero_nfe">
												<input type="hidden" value="<?php echo e($fornecedor->id, false); ?>" name="fornecedor_id">
												<input type="hidden" value="" name="location_id" class="location">

												<button class="btn btn-danger">Salvar Fatura</button>
											</form>
										</div>
										<?php else: ?>
										<p class="text-danger">Esta fatura já foi salva!!</p>
										<?php endif; ?>
										
										<?php endif; ?>
										<?php endif; ?>

									</div>

								</div>
							</div>
						</div>
					</div>

				</div>
			</div>
		</div>

		<div class="row">


			<div class="col-sm-12">
				<a href="/manifesto/baixarXml/<?php echo e($chave, false); ?>" class="btn btn-primary pull-right btn-flat">Baixar XML</a>
			</div>
		</div>


	</div>

	<?php echo $__env->renderComponent(); ?>



</section>

<?php $__env->startSection('javascript'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.11/jquery.mask.min.js"></script>
<script type="text/javascript">

	$(document).ready( function(){
		let id = $('#location_id').val()
		$('.location').val(id)

	});

	$('#location_id').change(() => {
		let id = $('#location_id').val()
		$('.location').val(id)
	})

	$('#perc_venda').mask('000.00')

	$('#perc_venda').keyup((v) => {
		v = v.target.value
		$('.pc').val(v)
	})

	$('.cn').keyup(() => {
		percorreTabela()
	})


	function percorreTabela(){
		let valores = '';
		let valido = true;
		$('#itens tr').each(function(){
			if(!$(this).find('.cn').val()) valido = false;
			valores += ($(this).find('.cn').val()) + ',';
		});

		if(valido){
			valores = valores.substring(0, valores.length-1);
			$('#conversao').val(valores)
		}else{

		}
	}
</script>
<?php $__env->stopSection(); ?>


<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/Projetos/laravel/ultimate/resources/views/manifesto/view.blade.php ENDPATH**/ ?>