<?php $__env->startSection('title', 'Emitir NFC-e'); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>Emitir NFC-e</h1>
</section>

<!-- Main content -->
<section class="content">

  <div class="row">
    <div class="col-md-12">
      <?php $__env->startComponent('components.widget'); ?>
      
      <input type="hidden" id="id" value="<?php echo e($transaction->id, false); ?>" name="">
      <div class="col-md-5">
        <h4>Ultimo numero NFC-e: <strong><?php echo e($transaction->lastNFCe(), false); ?></strong></h4>

      </div>
      
      <div class="clearfix"></div>


      <div class="col-md-12">
        
        <a class="btn btn-lg btn-danger" target="_blank" href="/nfce/gerarXml/<?php echo e($transaction->id, false); ?>" id="submit_user_button">Gerar XML</a>
        <a class="btn btn-lg btn-success" id="send-sefaz">Transmitir para Sefaz</a>
      </div>

      
      <?php echo $__env->renderComponent(); ?>
    </div>

  </div>

  

  <input type="hidden" id="token" value="<?php echo e(csrf_token(), false); ?>" name="">

  <br>
  <div class="row" id="action" style="display: none">
    <div class="col-md-12">
      <?php $__env->startComponent('components.widget'); ?>
      <div class="info-box-content">
        <div class="col-md-4 col-md-offset-4">

          <span class="info-box-number total_purchase">
            <strong id="acao"></strong>
            <i class="fas fa-spinner fa-pulse fa-spin fa-fw margin-bottom"></i></span>
          </div>
        </div>
        <?php echo $__env->renderComponent(); ?>

      </div>
    </div>

    <?php $__env->stopSection(); ?>



    <?php $__env->startSection('javascript'); ?>
    <script type="text/javascript">
      // swal("Good job!", "You clicked the button!", "success");
      var path = window.location.protocol + '//' + window.location.host

      $('#send-sefaz').click(() => {
        $('#send-sefaz').addClass('disabled')
        $('#action').css('display', 'block')
        let token = $('#token').val();
        let id = $('#id').val();

        setTimeout(() => {
          $('#acao').html('Gerando XML');
        }, 50);

        setTimeout(() => {
          $('#acao').html('Assinando o arquivo');
        }, 800);

        setTimeout(() => {
          $('#acao').html('Transmitindo para sefaz');
        }, 1500);

        $.ajax
        ({
          type: 'POST',
          data: {
            id: id,
            _token: token
          },
          url: path + '/nfce/transmitir',
          dataType: 'json',
          success: function(e){
            console.log(e)

            swal("sucesso", "NFC-e emitida, recibo: " + e, "success")
            .then(() => {
              window.open(path + '/nfce/imprimir/'+id)
              location.reload()
            });
            $('#action').css('display', 'none')
            

          }, error: function(e){
            // let jsError = JSON.parse(e.responseJSON);
            console.log(e)
            try{
              if(e.status == 402){
                swal("Erro ao transmitir", e.responseJSON, "error");
                $('#action').css('display', 'none')

              }
              else if(e.status == 407){
                $('#action').css('display', 'none')
                swal("Erro ao criar XML", e.responseJSON, "error");
              }
              else{
                $('#action').css('display', 'none')
                let jsError = JSON.parse(e.responseJSON)
                console.log(jsError)
                swal("Erro ao transmitir", jsError.protNFe.infProt.xMotivo, "error");

              }
            }catch{
              try{
                swal("Erro", e.responseJSON, "error");
              }catch{
                let js = e.responseJSON
                swal("Erro", js.message, "error");


              }
            }
          }

        })
      })


    </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/Projetos/ultimate/resources/views/nfce/gerar.blade.php ENDPATH**/ ?>